/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.storage;

import ai2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai2.org.apache.poi.poifs.storage.BlockList;
import ai2.org.apache.poi.poifs.storage.ListManagedBlock;
import ai2.org.apache.poi.poifs.storage.RawDataBlock;
import ai2.org.apache.poi.util.IntList;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.util.ArrayList;

public final class BlockAllocationTableReader {
    private static final POILogger _logger = POILogFactory.getLogger(BlockAllocationTableReader.class);
    private static final int MAX_BLOCK_COUNT = 65535;
    private final IntList _entries;
    private POIFSBigBlockSize bigBlockSize;

    public BlockAllocationTableReader(POIFSBigBlockSize pOIFSBigBlockSize, int n, int[] nArray, int n2, int n3, BlockList blockList) throws IOException {
        this(pOIFSBigBlockSize);
        int n4;
        int n5;
        BlockAllocationTableReader.sanityCheckBlockCount(n);
        int n6 = Math.min(n, nArray.length);
        ListManagedBlock[] listManagedBlockArray = new RawDataBlock[n];
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = nArray[n5];
            if (n4 > blockList.blockCount()) {
                throw new IOException("Your file contains " + blockList.blockCount() + " sectors, but the initial DIFAT array at index " + n5 + " referenced block # " + n4 + ". This isn't allowed and " + " your file is corrupt");
            }
            listManagedBlockArray[n5] = (RawDataBlock)blockList.remove(n4);
        }
        if (n5 < n) {
            if (n3 < 0) {
                throw new IOException("BAT count exceeds limit, yet XBAT index indicates no valid entries");
            }
            n4 = n3;
            int n7 = pOIFSBigBlockSize.getXBATEntriesPerBlock();
            int n8 = pOIFSBigBlockSize.getNextXBATChainOffset();
            for (int i = 0; i < n2; ++i) {
                n6 = Math.min(n - n5, n7);
                byte[] byArray = blockList.remove(n4).getData();
                int n9 = 0;
                for (int j = 0; j < n6; ++j) {
                    listManagedBlockArray[n5++] = (RawDataBlock)blockList.remove(LittleEndian.getInt(byArray, n9));
                    n9 += 4;
                }
                n4 = LittleEndian.getInt(byArray, n8);
                if (n4 == -2) break;
            }
        }
        if (n5 != n) {
            throw new IOException("Could not find all blocks");
        }
        this.setEntries(listManagedBlockArray, blockList);
    }

    BlockAllocationTableReader(POIFSBigBlockSize pOIFSBigBlockSize, ListManagedBlock[] listManagedBlockArray, BlockList blockList) throws IOException {
        this(pOIFSBigBlockSize);
        this.setEntries(listManagedBlockArray, blockList);
    }

    BlockAllocationTableReader(POIFSBigBlockSize pOIFSBigBlockSize) {
        this.bigBlockSize = pOIFSBigBlockSize;
        this._entries = new IntList();
    }

    public static void sanityCheckBlockCount(int n) throws IOException {
        if (n <= 0) {
            throw new IOException("Illegal block count; minimum count is 1, got " + n + " instead");
        }
        if (n > 65535) {
            throw new IOException("Block count " + n + " is too high. POI maximum is " + 65535 + ".");
        }
    }

    ListManagedBlock[] fetchBlocks(int n, int n2, BlockList blockList) throws IOException {
        ArrayList<ListManagedBlock> arrayList = new ArrayList<ListManagedBlock>();
        int n3 = n;
        boolean bl = true;
        ListManagedBlock listManagedBlock = null;
        while (n3 != -2) {
            try {
                listManagedBlock = blockList.remove(n3);
                arrayList.add(listManagedBlock);
                n3 = this._entries.get(n3);
                bl = false;
            }
            catch (IOException iOException) {
                if (n3 == n2) {
                    _logger.log(5, new Object[]{"Warning, header block comes after data blocks in POIFS block listing"});
                    n3 = -2;
                    continue;
                }
                if (n3 == 0 && bl) {
                    _logger.log(5, new Object[]{"Warning, incorrectly terminated empty data blocks in POIFS block listing (should end at -2, ended at 0)"});
                    n3 = -2;
                    continue;
                }
                throw iOException;
            }
        }
        return arrayList.toArray(new ListManagedBlock[arrayList.size()]);
    }

    boolean isUsed(int n) {
        try {
            return this._entries.get(n) != -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    int getNextBlockIndex(int n) throws IOException {
        if (this.isUsed(n)) {
            return this._entries.get(n);
        }
        throw new IOException("index " + n + " is unused");
    }

    private void setEntries(ListManagedBlock[] listManagedBlockArray, BlockList blockList) throws IOException {
        int n = this.bigBlockSize.getBATEntriesPerBlock();
        for (int i = 0; i < listManagedBlockArray.length; ++i) {
            byte[] byArray = listManagedBlockArray[i].getData();
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                int n3 = LittleEndian.getInt(byArray, n2);
                if (n3 == -1) {
                    blockList.zap(this._entries.size());
                }
                this._entries.add(n3);
                n2 += 4;
            }
            listManagedBlockArray[i] = null;
        }
        blockList.setBAT(this);
    }
}

