/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.property;

import ai2.org.apache.poi.poifs.property.DirectoryProperty;
import ai2.org.apache.poi.poifs.property.DocumentProperty;
import ai2.org.apache.poi.poifs.property.Property;
import ai2.org.apache.poi.poifs.property.RootProperty;
import ai2.org.apache.poi.poifs.storage.ListManagedBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyFactory {
    private PropertyFactory() {
    }

    static List<Property> convertToProperties(ListManagedBlock[] listManagedBlockArray) throws IOException {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (int i = 0; i < listManagedBlockArray.length; ++i) {
            byte[] byArray = listManagedBlockArray[i].getData();
            PropertyFactory.convertToProperties(byArray, arrayList);
        }
        return arrayList;
    }

    static void convertToProperties(byte[] byArray, List<Property> list) throws IOException {
        int n = byArray.length / 128;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            switch (byArray[n2 + 66]) {
                case 1: {
                    list.add(new DirectoryProperty(list.size(), byArray, n2));
                    break;
                }
                case 2: {
                    list.add(new DocumentProperty(list.size(), byArray, n2));
                    break;
                }
                case 5: {
                    list.add(new RootProperty(list.size(), byArray, n2));
                    break;
                }
                default: {
                    list.add(null);
                }
            }
            n2 += 128;
        }
    }
}

