/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.filesystem;

import ai2.org.apache.poi.poifs.filesystem.BlockStore;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSStream;
import ai2.org.apache.poi.poifs.property.RootProperty;
import ai2.org.apache.poi.poifs.storage.BATBlock;
import ai2.org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import ai2.org.apache.poi.poifs.storage.HeaderBlock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPOIFSMiniStore
extends BlockStore {
    private NPOIFSFileSystem _filesystem;
    private NPOIFSStream _mini_stream;
    private List<BATBlock> _sbat_blocks;
    private HeaderBlock _header;
    private RootProperty _root;

    protected NPOIFSMiniStore(NPOIFSFileSystem nPOIFSFileSystem, RootProperty rootProperty, List<BATBlock> list, HeaderBlock headerBlock) {
        this._filesystem = nPOIFSFileSystem;
        this._sbat_blocks = list;
        this._header = headerBlock;
        this._root = rootProperty;
        this._mini_stream = new NPOIFSStream(nPOIFSFileSystem, rootProperty.getStartBlock());
    }

    @Override
    protected ByteBuffer getBlockAt(int n) throws IOException {
        int n2 = n * 64;
        int n3 = n2 / this._filesystem.getBigBlockSize();
        int n4 = n2 % this._filesystem.getBigBlockSize();
        Iterator<ByteBuffer> iterator = this._mini_stream.getBlockIterator();
        for (int i = 0; i < n3; ++i) {
            iterator.next();
        }
        ByteBuffer byteBuffer = iterator.next();
        if (byteBuffer == null) {
            throw new IndexOutOfBoundsException("Big block " + n3 + " outside stream");
        }
        byteBuffer.position(byteBuffer.position() + n4);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.limit(64);
        return byteBuffer2;
    }

    @Override
    protected ByteBuffer createBlockIfNeeded(int n) throws IOException {
        boolean bl = false;
        if (this._mini_stream.getStartBlock() == -2) {
            bl = true;
        }
        if (!bl) {
            try {
                return this.getBlockAt(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        int n2 = this._filesystem.getFreeBlock();
        this._filesystem.createBlockIfNeeded(n2);
        if (bl) {
            this._filesystem._get_property_table().getRoot().setStartBlock(n2);
            this._mini_stream = new NPOIFSStream(this._filesystem, n2);
        } else {
            BlockStore.ChainLoopDetector chainLoopDetector = this._filesystem.getChainLoopDetector();
            int n3 = this._mini_stream.getStartBlock();
            while (true) {
                chainLoopDetector.claim(n3);
                int n4 = this._filesystem.getNextBlock(n3);
                if (n4 == -2) break;
                n3 = n4;
            }
            this._filesystem.setNextBlock(n3, n2);
        }
        this._filesystem.setNextBlock(n2, -2);
        return this.createBlockIfNeeded(n);
    }

    @Override
    protected BATBlock.BATBlockAndIndex getBATBlockAndIndex(int n) {
        return BATBlock.getSBATBlockAndIndex(n, this._header, this._sbat_blocks);
    }

    @Override
    protected int getNextBlock(int n) {
        BATBlock.BATBlockAndIndex bATBlockAndIndex = this.getBATBlockAndIndex(n);
        return bATBlockAndIndex.getBlock().getValueAt(bATBlockAndIndex.getIndex());
    }

    @Override
    protected void setNextBlock(int n, int n2) {
        BATBlock.BATBlockAndIndex bATBlockAndIndex = this.getBATBlockAndIndex(n);
        bATBlockAndIndex.getBlock().setValueAt(bATBlockAndIndex.getIndex(), n2);
    }

    @Override
    protected int getFreeBlock() throws IOException {
        int n;
        int n2 = this._filesystem.getBigBlockSizeDetails().getBATEntriesPerBlock();
        int n3 = 0;
        for (int i = 0; i < this._sbat_blocks.size(); ++i) {
            BATBlock bATBlock = this._sbat_blocks.get(i);
            if (bATBlock.hasFreeSectors()) {
                for (int j = 0; j < n2; ++j) {
                    n = bATBlock.getValueAt(j);
                    if (n != -1) continue;
                    return n3 + j;
                }
            }
            n3 += n2;
        }
        BATBlock bATBlock = BATBlock.createEmptyBATBlock(this._filesystem.getBigBlockSizeDetails(), false);
        int n4 = this._filesystem.getFreeBlock();
        bATBlock.setOurBlockIndex(n4);
        if (this._header.getSBATCount() == 0) {
            this._header.setSBATStart(n4);
            this._header.setSBATBlockCount(1);
        } else {
            BlockStore.ChainLoopDetector chainLoopDetector = this._filesystem.getChainLoopDetector();
            n = this._header.getSBATStart();
            while (true) {
                chainLoopDetector.claim(n);
                int n5 = this._filesystem.getNextBlock(n);
                if (n5 == -2) break;
                n = n5;
            }
            this._filesystem.setNextBlock(n, n4);
            this._header.setSBATBlockCount(this._header.getSBATCount() + 1);
        }
        this._filesystem.setNextBlock(n4, -2);
        this._sbat_blocks.add(bATBlock);
        return n3;
    }

    @Override
    protected BlockStore.ChainLoopDetector getChainLoopDetector() throws IOException {
        return new BlockStore.ChainLoopDetector(this._root.getSize());
    }

    @Override
    protected int getBlockStoreBlockSize() {
        return 64;
    }

    protected void syncWithDataSource() throws IOException {
        int n = 0;
        for (BATBlock bATBlock : this._sbat_blocks) {
            ByteBuffer byteBuffer = this._filesystem.getBlockAt(bATBlock.getOurBlockIndex());
            BlockAllocationTableWriter.writeBlock(bATBlock, byteBuffer);
            if (!bATBlock.hasFreeSectors()) {
                n += this._filesystem.getBigBlockSizeDetails().getBATEntriesPerBlock();
                continue;
            }
            n += bATBlock.getUsedSectors(false);
        }
        this._filesystem._get_property_table().getRoot().setSize(n);
    }
}

