/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.filesystem;

import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSDocument;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSStream;
import ai2.org.apache.poi.poifs.property.DocumentProperty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class NDocumentOutputStream
extends OutputStream {
    private int _document_size;
    private boolean _closed;
    private NPOIFSDocument _document;
    private DocumentProperty _property;
    private ByteArrayOutputStream _buffer = new ByteArrayOutputStream(4096);
    private NPOIFSStream _stream;
    private OutputStream _stream_output;

    public NDocumentOutputStream(DocumentEntry documentEntry) throws IOException {
        if (!(documentEntry instanceof DocumentNode)) {
            throw new IOException("Cannot open internal document storage, " + documentEntry + " not a Document Node");
        }
        this._document_size = 0;
        this._closed = false;
        this._property = (DocumentProperty)((DocumentNode)documentEntry).getProperty();
        this._document = new NPOIFSDocument((DocumentNode)documentEntry);
        this._document.free();
    }

    public NDocumentOutputStream(DirectoryEntry directoryEntry, String string) throws IOException {
        if (!(directoryEntry instanceof DirectoryNode)) {
            throw new IOException("Cannot open internal directory storage, " + directoryEntry + " not a Directory Node");
        }
        this._document_size = 0;
        this._closed = false;
        DocumentEntry documentEntry = directoryEntry.createDocument(string, new ByteArrayInputStream(new byte[0]));
        this._property = (DocumentProperty)((DocumentNode)documentEntry).getProperty();
        this._document = new NPOIFSDocument((DocumentNode)documentEntry);
    }

    private void dieIfClosed() throws IOException {
        if (this._closed) {
            throw new IOException("cannot perform requested operation on a closed stream");
        }
    }

    private void checkBufferSize() throws IOException {
        if (this._buffer.size() > 4096) {
            byte[] byArray = this._buffer.toByteArray();
            this._buffer = null;
            this.write(byArray, 0, byArray.length);
        }
    }

    public void write(int n) throws IOException {
        this.dieIfClosed();
        if (this._buffer != null) {
            this._buffer.write(n);
            this.checkBufferSize();
        } else {
            this.write(new byte[]{(byte)n});
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.dieIfClosed();
        if (this._buffer != null) {
            this._buffer.write(byArray);
            this.checkBufferSize();
        } else {
            this.write(byArray, 0, byArray.length);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.dieIfClosed();
        if (this._buffer != null) {
            this._buffer.write(byArray, n, n2);
            this.checkBufferSize();
        } else {
            if (this._stream == null) {
                this._stream = new NPOIFSStream(this._document.getFileSystem());
                this._stream_output = this._stream.getOutputStream();
            }
            this._stream_output.write(byArray, n, n2);
            this._document_size += n2;
        }
    }

    public void close() throws IOException {
        if (this._buffer != null) {
            this._document.replaceContents(new ByteArrayInputStream(this._buffer.toByteArray()));
        } else {
            this._stream_output.close();
            this._property.updateSize(this._document_size);
            this._property.setStartBlock(this._stream.getStartBlock());
        }
        this._closed = true;
    }
}

