/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.filesystem;

import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.DocumentNode;
import ai2.org.apache.poi.poifs.filesystem.Entry;
import ai2.org.apache.poi.poifs.filesystem.FilteringDirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import ai2.org.apache.poi.util.Internal;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class EntryUtils {
    @Internal
    public static void copyNodeRecursively(Entry entry, DirectoryEntry directoryEntry) throws IOException {
        DirectoryEntry directoryEntry2 = null;
        if (entry.isDirectoryEntry()) {
            DirectoryEntry directoryEntry3 = (DirectoryEntry)entry;
            directoryEntry2 = directoryEntry.createDirectory(entry.getName());
            directoryEntry2.setStorageClsid(directoryEntry3.getStorageClsid());
            Iterator<Entry> iterator = directoryEntry3.getEntries();
            while (iterator.hasNext()) {
                EntryUtils.copyNodeRecursively(iterator.next(), directoryEntry2);
            }
        } else {
            DocumentEntry documentEntry = (DocumentEntry)entry;
            DocumentInputStream documentInputStream = new DocumentInputStream(documentEntry);
            directoryEntry.createDocument(documentEntry.getName(), documentInputStream);
            documentInputStream.close();
        }
    }

    public static void copyNodes(DirectoryEntry directoryEntry, DirectoryEntry directoryEntry2) throws IOException {
        for (Entry entry : directoryEntry) {
            EntryUtils.copyNodeRecursively(entry, directoryEntry2);
        }
    }

    public static void copyNodes(FilteringDirectoryNode filteringDirectoryNode, FilteringDirectoryNode filteringDirectoryNode2) throws IOException {
        EntryUtils.copyNodes((DirectoryEntry)filteringDirectoryNode, (DirectoryEntry)filteringDirectoryNode2);
    }

    public static void copyNodes(DirectoryEntry directoryEntry, DirectoryEntry directoryEntry2, List<String> list) throws IOException {
        Iterator<Entry> iterator = directoryEntry.getEntries();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (list.contains(entry.getName())) continue;
            EntryUtils.copyNodeRecursively(entry, directoryEntry2);
        }
    }

    public static void copyNodes(OPOIFSFileSystem oPOIFSFileSystem, OPOIFSFileSystem oPOIFSFileSystem2) throws IOException {
        EntryUtils.copyNodes(oPOIFSFileSystem.getRoot(), oPOIFSFileSystem2.getRoot());
    }

    public static void copyNodes(NPOIFSFileSystem nPOIFSFileSystem, NPOIFSFileSystem nPOIFSFileSystem2) throws IOException {
        EntryUtils.copyNodes(nPOIFSFileSystem.getRoot(), nPOIFSFileSystem2.getRoot());
    }

    public static void copyNodes(OPOIFSFileSystem oPOIFSFileSystem, OPOIFSFileSystem oPOIFSFileSystem2, List<String> list) throws IOException {
        EntryUtils.copyNodes(new FilteringDirectoryNode(oPOIFSFileSystem.getRoot(), list), new FilteringDirectoryNode(oPOIFSFileSystem2.getRoot(), list));
    }

    public static void copyNodes(NPOIFSFileSystem nPOIFSFileSystem, NPOIFSFileSystem nPOIFSFileSystem2, List<String> list) throws IOException {
        EntryUtils.copyNodes(new FilteringDirectoryNode(nPOIFSFileSystem.getRoot(), list), new FilteringDirectoryNode(nPOIFSFileSystem2.getRoot(), list));
    }

    public static boolean areDirectoriesIdentical(DirectoryEntry directoryEntry, DirectoryEntry directoryEntry2) {
        int n;
        Object object;
        if (!directoryEntry.getName().equals(directoryEntry2.getName())) {
            return false;
        }
        if (directoryEntry.getEntryCount() != directoryEntry2.getEntryCount()) {
            return false;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Entry entry : directoryEntry) {
            object = entry.getName();
            if (entry.isDirectoryEntry()) {
                hashMap.put((String)object, -12345);
                continue;
            }
            hashMap.put((String)object, ((DocumentNode)entry).getSize());
        }
        for (Entry entry : directoryEntry2) {
            object = entry.getName();
            if (!hashMap.containsKey(object)) {
                return false;
            }
            n = entry.isDirectoryEntry() ? -12345 : ((DocumentNode)entry).getSize();
            if (n != (Integer)hashMap.get(object)) {
                return false;
            }
            hashMap.remove(object);
        }
        if (!hashMap.isEmpty()) {
            return false;
        }
        for (Entry entry : directoryEntry) {
            try {
                object = directoryEntry2.getEntry(entry.getName());
                n = entry.isDirectoryEntry() ? (int)(EntryUtils.areDirectoriesIdentical((DirectoryEntry)entry, (DirectoryEntry)object) ? 1 : 0) : (int)(EntryUtils.areDocumentsIdentical((DocumentEntry)entry, (DocumentEntry)object) ? 1 : 0);
                if (n != 0) continue;
                return false;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areDocumentsIdentical(DocumentEntry documentEntry, DocumentEntry documentEntry2) throws IOException {
        if (!documentEntry.getName().equals(documentEntry2.getName())) {
            return false;
        }
        if (documentEntry.getSize() != documentEntry2.getSize()) {
            return false;
        }
        boolean bl = true;
        DocumentInputStream documentInputStream = null;
        DocumentInputStream documentInputStream2 = null;
        try {
            int n;
            int n2;
            documentInputStream = new DocumentInputStream(documentEntry);
            documentInputStream2 = new DocumentInputStream(documentEntry2);
            do {
                if ((n2 = documentInputStream.read()) == (n = documentInputStream2.read())) continue;
                bl = false;
                break;
            } while (n2 != -1 && n != -1);
        }
        finally {
            if (documentInputStream != null) {
                documentInputStream.close();
            }
            if (documentInputStream2 != null) {
                documentInputStream2.close();
            }
        }
        return bl;
    }
}

