/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.eventfilesystem;

import ai2.org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import ai2.org.apache.poi.poifs.filesystem.DocumentDescriptor;
import ai2.org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class POIFSReaderRegistry {
    private Set<POIFSReaderListener> omnivorousListeners = new HashSet<POIFSReaderListener>();
    private Map<POIFSReaderListener, Set<DocumentDescriptor>> selectiveListeners = new HashMap<POIFSReaderListener, Set<DocumentDescriptor>>();
    private Map<DocumentDescriptor, Set<POIFSReaderListener>> chosenDocumentDescriptors = new HashMap<DocumentDescriptor, Set<POIFSReaderListener>>();

    POIFSReaderRegistry() {
    }

    void registerListener(POIFSReaderListener pOIFSReaderListener, POIFSDocumentPath pOIFSDocumentPath, String string) {
        if (!this.omnivorousListeners.contains(pOIFSReaderListener)) {
            DocumentDescriptor documentDescriptor;
            Set<DocumentDescriptor> set = this.selectiveListeners.get(pOIFSReaderListener);
            if (set == null) {
                set = new HashSet<DocumentDescriptor>();
                this.selectiveListeners.put(pOIFSReaderListener, set);
            }
            if (set.add(documentDescriptor = new DocumentDescriptor(pOIFSDocumentPath, string))) {
                Set<POIFSReaderListener> set2 = this.chosenDocumentDescriptors.get(documentDescriptor);
                if (set2 == null) {
                    set2 = new HashSet<POIFSReaderListener>();
                    this.chosenDocumentDescriptors.put(documentDescriptor, set2);
                }
                set2.add(pOIFSReaderListener);
            }
        }
    }

    void registerListener(POIFSReaderListener pOIFSReaderListener) {
        if (!this.omnivorousListeners.contains(pOIFSReaderListener)) {
            this.removeSelectiveListener(pOIFSReaderListener);
            this.omnivorousListeners.add(pOIFSReaderListener);
        }
    }

    Iterator<POIFSReaderListener> getListeners(POIFSDocumentPath pOIFSDocumentPath, String string) {
        HashSet<POIFSReaderListener> hashSet = new HashSet<POIFSReaderListener>(this.omnivorousListeners);
        Set<POIFSReaderListener> set = this.chosenDocumentDescriptors.get(new DocumentDescriptor(pOIFSDocumentPath, string));
        if (set != null) {
            hashSet.addAll(set);
        }
        return hashSet.iterator();
    }

    private void removeSelectiveListener(POIFSReaderListener pOIFSReaderListener) {
        Set<DocumentDescriptor> set = this.selectiveListeners.remove(pOIFSReaderListener);
        if (set != null) {
            Iterator<DocumentDescriptor> iterator = set.iterator();
            while (iterator.hasNext()) {
                this.dropDocument(pOIFSReaderListener, iterator.next());
            }
        }
    }

    private void dropDocument(POIFSReaderListener pOIFSReaderListener, DocumentDescriptor documentDescriptor) {
        Set<POIFSReaderListener> set = this.chosenDocumentDescriptors.get(documentDescriptor);
        set.remove(pOIFSReaderListener);
        if (set.size() == 0) {
            this.chosenDocumentDescriptors.remove(documentDescriptor);
        }
    }
}

