/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.dev;

import ai2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai2.org.apache.poi.poifs.property.DirectoryProperty;
import ai2.org.apache.poi.poifs.property.Property;
import ai2.org.apache.poi.poifs.property.PropertyTable;
import ai2.org.apache.poi.poifs.storage.BlockAllocationTableReader;
import ai2.org.apache.poi.poifs.storage.HeaderBlock;
import ai2.org.apache.poi.poifs.storage.ListManagedBlock;
import ai2.org.apache.poi.poifs.storage.RawDataBlockList;
import ai2.org.apache.poi.poifs.storage.SmallBlockTableReader;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.IntList;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class POIFSHeaderDumper {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Must specify at least one file to view");
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            POIFSHeaderDumper.viewFile(stringArray[i]);
        }
    }

    public static void viewFile(String string) throws Exception {
        System.out.println("Dumping headers from: " + string);
        FileInputStream fileInputStream = new FileInputStream(string);
        HeaderBlock headerBlock = new HeaderBlock(fileInputStream);
        POIFSHeaderDumper.displayHeader(headerBlock);
        POIFSBigBlockSize pOIFSBigBlockSize = headerBlock.getBigBlockSize();
        RawDataBlockList rawDataBlockList = new RawDataBlockList(fileInputStream, pOIFSBigBlockSize);
        POIFSHeaderDumper.displayRawBlocksSummary(rawDataBlockList);
        BlockAllocationTableReader blockAllocationTableReader = new BlockAllocationTableReader(headerBlock.getBigBlockSize(), headerBlock.getBATCount(), headerBlock.getBATArray(), headerBlock.getXBATCount(), headerBlock.getXBATIndex(), rawDataBlockList);
        POIFSHeaderDumper.displayBATReader("Big Blocks", blockAllocationTableReader);
        PropertyTable propertyTable = new PropertyTable(headerBlock, rawDataBlockList);
        BlockAllocationTableReader blockAllocationTableReader2 = SmallBlockTableReader._getSmallDocumentBlockReader(pOIFSBigBlockSize, rawDataBlockList, propertyTable.getRoot(), headerBlock.getSBATStart());
        POIFSHeaderDumper.displayBATReader("Small Blocks", blockAllocationTableReader2);
        POIFSHeaderDumper.displayPropertiesSummary(propertyTable);
    }

    public static void displayHeader(HeaderBlock headerBlock) throws Exception {
        System.out.println("Header Details:");
        System.out.println(" Block size: " + headerBlock.getBigBlockSize().getBigBlockSize());
        System.out.println(" BAT (FAT) header blocks: " + headerBlock.getBATArray().length);
        System.out.println(" BAT (FAT) block count: " + headerBlock.getBATCount());
        if (headerBlock.getBATCount() > 0) {
            System.out.println(" BAT (FAT) block 1 at: " + headerBlock.getBATArray()[0]);
        }
        System.out.println(" XBAT (FAT) block count: " + headerBlock.getXBATCount());
        System.out.println(" XBAT (FAT) block 1 at: " + headerBlock.getXBATIndex());
        System.out.println(" SBAT (MiniFAT) block count: " + headerBlock.getSBATCount());
        System.out.println(" SBAT (MiniFAT) block 1 at: " + headerBlock.getSBATStart());
        System.out.println(" Property table at: " + headerBlock.getPropertyStart());
        System.out.println("");
    }

    public static void displayRawBlocksSummary(RawDataBlockList rawDataBlockList) throws Exception {
        System.out.println("Raw Blocks Details:");
        System.out.println(" Number of blocks: " + rawDataBlockList.blockCount());
        Method method = rawDataBlockList.getClass().getSuperclass().getDeclaredMethod("get", Integer.TYPE);
        method.setAccessible(true);
        for (int i = 0; i < Math.min(16, rawDataBlockList.blockCount()); ++i) {
            ListManagedBlock listManagedBlock = (ListManagedBlock)method.invoke((Object)rawDataBlockList, i);
            byte[] byArray = new byte[Math.min(48, listManagedBlock.getData().length)];
            System.arraycopy(listManagedBlock.getData(), 0, byArray, 0, byArray.length);
            System.out.println(" Block #" + i + ":");
            System.out.println(HexDump.dump(byArray, 0L, 0));
        }
        System.out.println("");
    }

    public static void displayBATReader(String string, BlockAllocationTableReader blockAllocationTableReader) throws Exception {
        System.out.println("Sectors, as referenced from the " + string + " FAT:");
        Field field = blockAllocationTableReader.getClass().getDeclaredField("_entries");
        field.setAccessible(true);
        IntList intList = (IntList)field.get(blockAllocationTableReader);
        for (int i = 0; i < intList.size(); ++i) {
            int n = intList.get(i);
            String string2 = Integer.toString(n);
            if (n == -2) {
                string2 = "End Of Chain";
            } else if (n == -4) {
                string2 = "DI Fat Block";
            } else if (n == -3) {
                string2 = "Normal Fat Block";
            } else if (n == -1) {
                string2 = "Block Not Used (Free)";
            }
            System.out.println("  Block  # " + i + " -> " + string2);
        }
        System.out.println("");
    }

    public static void displayPropertiesSummary(PropertyTable propertyTable) {
        System.out.println("Mini Stream starts at " + propertyTable.getRoot().getStartBlock());
        System.out.println("Mini Stream length is " + propertyTable.getRoot().getSize());
        System.out.println();
        System.out.println("Properties and their block start:");
        POIFSHeaderDumper.displayProperties(propertyTable.getRoot(), "");
        System.out.println("");
    }

    public static void displayProperties(DirectoryProperty directoryProperty, String string) {
        String string2 = string + "  ";
        System.out.println(string + "-> " + directoryProperty.getName());
        for (Property property : directoryProperty) {
            if (property instanceof DirectoryProperty) {
                POIFSHeaderDumper.displayProperties((DirectoryProperty)property, string2);
                continue;
            }
            System.out.println(string2 + "=> " + property.getName());
            System.out.print(string2 + "   " + property.getSize() + " bytes in ");
            if (property.shouldUseSmallBlocks()) {
                System.out.print("mini");
            } else {
                System.out.print("main");
            }
            System.out.println(" stream, starts at " + property.getStartBlock());
        }
    }
}

