/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.standard;

import ai2.org.apache.poi.poifs.crypt.ChainingMode;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.CipherProvider;
import ai2.org.apache.poi.poifs.crypt.EncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import ai2.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;

public class StandardEncryptionHeader
extends EncryptionHeader
implements EncryptionRecord {
    protected StandardEncryptionHeader(LittleEndianInput littleEndianInput) throws IOException {
        this.setFlags(littleEndianInput.readInt());
        this.setSizeExtra(littleEndianInput.readInt());
        this.setCipherAlgorithm(CipherAlgorithm.fromEcmaId(littleEndianInput.readInt()));
        this.setHashAlgorithm(HashAlgorithm.fromEcmaId(littleEndianInput.readInt()));
        int n = littleEndianInput.readInt();
        if (n == 0) {
            n = 40;
        }
        this.setKeySize(n);
        this.setBlockSize(this.getKeySize());
        this.setCipherProvider(CipherProvider.fromEcmaId(littleEndianInput.readInt()));
        littleEndianInput.readLong();
        ((InputStream)((Object)littleEndianInput)).mark(5);
        int n2 = littleEndianInput.readInt();
        ((InputStream)((Object)littleEndianInput)).reset();
        if (n2 == 16) {
            this.setCspName("");
        } else {
            char c;
            StringBuilder stringBuilder = new StringBuilder();
            while ((c = (char)littleEndianInput.readShort()) != '\u0000') {
                stringBuilder.append(c);
            }
            this.setCspName(stringBuilder.toString());
        }
        this.setChainingMode(ChainingMode.ecb);
        this.setKeySalt(null);
    }

    protected StandardEncryptionHeader(CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this.setCipherAlgorithm(cipherAlgorithm);
        this.setHashAlgorithm(hashAlgorithm);
        this.setKeySize(n);
        this.setBlockSize(n2);
        this.setCipherProvider(cipherAlgorithm.provider);
        this.setFlags(EncryptionInfo.flagCryptoAPI.setBoolean(0, true) | EncryptionInfo.flagAES.setBoolean(0, cipherAlgorithm.provider == CipherProvider.aes));
    }

    public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
        int n = littleEndianByteArrayOutputStream.getWriteIndex();
        LittleEndianOutput littleEndianOutput = littleEndianByteArrayOutputStream.createDelayedOutput(4);
        littleEndianByteArrayOutputStream.writeInt(this.getFlags());
        littleEndianByteArrayOutputStream.writeInt(0);
        littleEndianByteArrayOutputStream.writeInt(this.getCipherAlgorithm().ecmaId);
        littleEndianByteArrayOutputStream.writeInt(this.getHashAlgorithmEx().ecmaId);
        littleEndianByteArrayOutputStream.writeInt(this.getKeySize());
        littleEndianByteArrayOutputStream.writeInt(this.getCipherProvider().ecmaId);
        littleEndianByteArrayOutputStream.writeInt(0);
        littleEndianByteArrayOutputStream.writeInt(0);
        String string = this.getCspName();
        if (string == null) {
            string = this.getCipherProvider().cipherProviderName;
        }
        littleEndianByteArrayOutputStream.write(StringUtil.getToUnicodeLE(string));
        littleEndianByteArrayOutputStream.writeShort(0);
        int n2 = littleEndianByteArrayOutputStream.getWriteIndex() - n - 4;
        littleEndianOutput.writeInt(n2);
    }
}

