/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig.services;

import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevocationData {
    private final List<byte[]> crls = new ArrayList<byte[]>();
    private final List<byte[]> ocsps = new ArrayList<byte[]>();

    public void addCRL(byte[] byArray) {
        this.crls.add(byArray);
    }

    public void addCRL(X509CRL x509CRL) {
        byte[] byArray;
        try {
            byArray = x509CRL.getEncoded();
        }
        catch (CRLException cRLException) {
            throw new IllegalArgumentException("CRL coding error: " + cRLException.getMessage(), cRLException);
        }
        this.addCRL(byArray);
    }

    public void addOCSP(byte[] byArray) {
        this.ocsps.add(byArray);
    }

    public List<byte[]> getCRLs() {
        return this.crls;
    }

    public List<byte[]> getOCSPs() {
        return this.ocsps;
    }

    public boolean hasOCSPs() {
        return false == this.ocsps.isEmpty();
    }

    public boolean hasCRLs() {
        return false == this.crls.isEmpty();
    }

    public boolean hasRevocationDataEntries() {
        return this.hasOCSPs() || this.hasCRLs();
    }
}

