/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig.facets;

import ai2.org.apache.poi.poifs.crypt.dsig.facets.SignatureFacet;
import ai2.org.apache.poi.poifs.crypt.dsig.facets.XAdESSignatureFacet;
import ai2.org.apache.poi.poifs.crypt.dsig.services.RevocationData;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.crypto.MarshalException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.etsi.uri.x01903.v13.CRLIdentifierType;
import org.etsi.uri.x01903.v13.CRLRefType;
import org.etsi.uri.x01903.v13.CRLRefsType;
import org.etsi.uri.x01903.v13.CRLValuesType;
import org.etsi.uri.x01903.v13.CertIDListType;
import org.etsi.uri.x01903.v13.CertIDType;
import org.etsi.uri.x01903.v13.CompleteRevocationRefsType;
import org.etsi.uri.x01903.v13.DigestAlgAndValueType;
import org.etsi.uri.x01903.v13.EncapsulatedPKIDataType;
import org.etsi.uri.x01903.v13.OCSPIdentifierType;
import org.etsi.uri.x01903.v13.QualifyingPropertiesDocument;
import org.etsi.uri.x01903.v13.QualifyingPropertiesType;
import org.etsi.uri.x01903.v13.ResponderIDType;
import org.etsi.uri.x01903.v13.RevocationValuesType;
import org.etsi.uri.x01903.v13.UnsignedPropertiesType;
import org.etsi.uri.x01903.v13.UnsignedSignaturePropertiesType;
import org.etsi.uri.x01903.v13.XAdESTimeStampType;
import org.etsi.uri.x01903.v14.ValidationDataType;
import org.w3.x2000.x09.xmldsig.CanonicalizationMethodType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAdESXLSignatureFacet
extends SignatureFacet {
    private static final POILogger LOG = POILogFactory.getLogger(XAdESXLSignatureFacet.class);
    private final CertificateFactory certificateFactory;

    public XAdESXLSignatureFacet() {
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("X509 JCA error: " + certificateException.getMessage(), certificateException);
        }
    }

    @Override
    public void postSign(Document document) throws MarshalException {
        Calendar calendar;
        Object object;
        Object object2;
        Object object3;
        CRLRefType exception;
        Object object42;
        Object object5;
        ValidationDataType validationDataType;
        NodeList nodeList;
        UnsignedSignaturePropertiesType unsignedSignaturePropertiesType;
        LOG.log(1, new Object[]{"XAdES-X-L post sign phase"});
        QualifyingPropertiesDocument qualifyingPropertiesDocument = null;
        QualifyingPropertiesType qualifyingPropertiesType = null;
        NodeList nodeList2 = document.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "QualifyingProperties");
        if (nodeList2.getLength() == 1) {
            try {
                qualifyingPropertiesDocument = QualifyingPropertiesDocument.Factory.parse((Node)nodeList2.item(0));
            }
            catch (XmlException xmlException) {
                throw new MarshalException(xmlException);
            }
        } else {
            throw new MarshalException("no XAdES-BES extension present");
        }
        qualifyingPropertiesType = qualifyingPropertiesDocument.getQualifyingProperties();
        UnsignedPropertiesType unsignedPropertiesType = qualifyingPropertiesType.getUnsignedProperties();
        if (unsignedPropertiesType == null) {
            unsignedPropertiesType = qualifyingPropertiesType.addNewUnsignedProperties();
        }
        if ((unsignedSignaturePropertiesType = unsignedPropertiesType.getUnsignedSignatureProperties()) == null) {
            unsignedSignaturePropertiesType = unsignedPropertiesType.addNewUnsignedSignatureProperties();
        }
        if ((nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue")).getLength() != 1) {
            throw new IllegalArgumentException("SignatureValue is not set.");
        }
        RevocationData revocationData = new RevocationData();
        LOG.log(1, new Object[]{"creating XAdES-T time-stamp"});
        XAdESTimeStampType xAdESTimeStampType = this.createXAdESTimeStamp(Collections.singletonList(nodeList.item(0)), revocationData);
        unsignedSignaturePropertiesType.addNewSignatureTimeStamp().set((XmlObject)xAdESTimeStampType);
        if (revocationData.hasRevocationDataEntries()) {
            validationDataType = this.createValidationData(revocationData);
            XAdESSignatureFacet.insertXChild((XmlObject)unsignedSignaturePropertiesType, (XmlObject)validationDataType);
        }
        if (this.signatureConfig.getRevocationDataService() == null) {
            return;
        }
        validationDataType = unsignedSignaturePropertiesType.addNewCompleteCertificateRefs();
        CertIDListType certIDListType = validationDataType.addNewCertRefs();
        List<X509Certificate> list = this.signatureConfig.getSigningCertificateChain();
        int n = list.size();
        if (n > 1) {
            for (X509Certificate object72 : list.subList(1, n)) {
                object5 = certIDListType.addNewCert();
                XAdESSignatureFacet.setCertID((CertIDType)object5, this.signatureConfig, false, object72);
            }
        }
        CompleteRevocationRefsType completeRevocationRefsType = unsignedSignaturePropertiesType.addNewCompleteRevocationRefs();
        RevocationData revocationData2 = this.signatureConfig.getRevocationDataService().getRevocationData(list);
        if (revocationData2.hasCRLs()) {
            object5 = completeRevocationRefsType.addNewCRLRefs();
            completeRevocationRefsType.setCRLRefs((CRLRefsType)object5);
            for (Object object42 : revocationData2.getCRLs()) {
                exception = object5.addNewCRLRef();
                try {
                    object3 = (X509CRL)this.certificateFactory.generateCRL(new ByteArrayInputStream((byte[])object42));
                }
                catch (CRLException cRLException) {
                    throw new RuntimeException("CRL parse error: " + cRLException.getMessage(), cRLException);
                }
                CRLIdentifierType cRLException = exception.addNewCRLIdentifier();
                object2 = ((X509CRL)object3).getIssuerDN().getName().replace(",", ", ");
                cRLException.setIssuer((String)object2);
                object = Calendar.getInstance(TimeZone.getTimeZone("Z"), Locale.ROOT);
                ((Calendar)object).setTime(((X509CRL)object3).getThisUpdate());
                cRLException.setIssueTime((Calendar)object);
                cRLException.setNumber(this.getCrlNumber((X509CRL)object3));
                calendar = exception.addNewDigestAlgAndValue();
                XAdESSignatureFacet.setDigestAlgAndValue((DigestAlgAndValueType)calendar, object42, this.signatureConfig.getDigestAlgo());
            }
        }
        if (revocationData2.hasOCSPs()) {
            object5 = completeRevocationRefsType.addNewOCSPRefs();
            for (Object object42 : revocationData2.getOCSPs()) {
                try {
                    Object object6;
                    ASN1OctetString aSN1OctetString;
                    exception = object5.addNewOCSPRef();
                    object3 = exception.addNewDigestAlgAndValue();
                    XAdESSignatureFacet.setDigestAlgAndValue((DigestAlgAndValueType)object3, object42, this.signatureConfig.getDigestAlgo());
                    OCSPIdentifierType oCSPIdentifierType = exception.addNewOCSPIdentifier();
                    object2 = new OCSPResp(object42);
                    object = (BasicOCSPResp)object2.getResponseObject();
                    calendar = Calendar.getInstance(TimeZone.getTimeZone("Z"), Locale.ROOT);
                    calendar.setTime(object.getProducedAt());
                    oCSPIdentifierType.setProducedAt(calendar);
                    ResponderIDType responderIDType = oCSPIdentifierType.addNewResponderID();
                    RespID respID = object.getResponderId();
                    ResponderID responderID = respID.toASN1Object();
                    DERTaggedObject dERTaggedObject = (DERTaggedObject)responderID.toASN1Primitive();
                    if (2 == dERTaggedObject.getTagNo()) {
                        aSN1OctetString = (ASN1OctetString)dERTaggedObject.getObject();
                        object6 = aSN1OctetString.getOctets();
                        responderIDType.setByKey(object6);
                        continue;
                    }
                    aSN1OctetString = X500Name.getInstance((Object)dERTaggedObject.getObject());
                    object6 = aSN1OctetString.toString();
                    responderIDType.setByName((String)object6);
                }
                catch (Exception exception2) {
                    throw new RuntimeException("OCSP decoding error: " + exception2.getMessage(), exception2);
                }
            }
        }
        object5 = new ArrayList();
        object5.add(nodeList.item(0));
        object5.add(xAdESTimeStampType.getDomNode());
        object5.add(validationDataType.getDomNode());
        object5.add(completeRevocationRefsType.getDomNode());
        RevocationData revocationData3 = new RevocationData();
        LOG.log(1, new Object[]{"creating XAdES-X time-stamp"});
        object42 = this.createXAdESTimeStamp((List<Node>)object5, revocationData3);
        if (revocationData3.hasRevocationDataEntries()) {
            exception = this.createValidationData(revocationData3);
            XAdESSignatureFacet.insertXChild((XmlObject)unsignedSignaturePropertiesType, (XmlObject)exception);
        }
        unsignedSignaturePropertiesType.addNewSigAndRefsTimeStamp().set((XmlObject)object42);
        exception = unsignedSignaturePropertiesType.addNewCertificateValues();
        for (X509Certificate x509Certificate : list) {
            object2 = exception.addNewEncapsulatedX509Certificate();
            try {
                object2.setByteArrayValue(x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new RuntimeException("certificate encoding error: " + certificateEncodingException.getMessage(), certificateEncodingException);
            }
        }
        object3 = unsignedSignaturePropertiesType.addNewRevocationValues();
        this.createRevocationValues((RevocationValuesType)object3, revocationData2);
        Node node = document.importNode(qualifyingPropertiesType.getDomNode(), true);
        nodeList2.item(0).getParentNode().replaceChild(node, nodeList2.item(0));
    }

    public static byte[] getC14nValue(List<Node> list, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (Node node : list) {
                Canonicalizer canonicalizer = Canonicalizer.getInstance((String)string);
                byteArrayOutputStream.write(canonicalizer.canonicalizeSubtree(node));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException("c14n error: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private BigInteger getCrlNumber(X509CRL x509CRL) {
        try {
            byte[] byArray = x509CRL.getExtensionValue(Extension.cRLNumber.getId());
            if (null == byArray) {
                return null;
            }
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            byte[] byArray2 = aSN1OctetString.getOctets();
            aSN1InputStream = new ASN1InputStream(byArray2);
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1InputStream.readObject();
            BigInteger bigInteger = aSN1Integer.getPositiveValue();
            return bigInteger;
        }
        catch (Exception exception) {
            throw new RuntimeException("I/O error: " + exception.getMessage(), exception);
        }
    }

    private XAdESTimeStampType createXAdESTimeStamp(List<Node> list, RevocationData revocationData) {
        byte[] byArray = XAdESXLSignatureFacet.getC14nValue(list, this.signatureConfig.getXadesCanonicalizationMethod());
        return this.createXAdESTimeStamp(byArray, revocationData);
    }

    private XAdESTimeStampType createXAdESTimeStamp(byte[] byArray, RevocationData revocationData) {
        byte[] byArray2;
        try {
            byArray2 = this.signatureConfig.getTspService().timeStamp(byArray, revocationData);
        }
        catch (Exception exception) {
            throw new RuntimeException("error while creating a time-stamp: " + exception.getMessage(), exception);
        }
        XAdESTimeStampType xAdESTimeStampType = XAdESTimeStampType.Factory.newInstance();
        xAdESTimeStampType.setId("time-stamp-" + UUID.randomUUID().toString());
        CanonicalizationMethodType canonicalizationMethodType = xAdESTimeStampType.addNewCanonicalizationMethod();
        canonicalizationMethodType.setAlgorithm(this.signatureConfig.getXadesCanonicalizationMethod());
        EncapsulatedPKIDataType encapsulatedPKIDataType = xAdESTimeStampType.addNewEncapsulatedTimeStamp();
        encapsulatedPKIDataType.setByteArrayValue(byArray2);
        encapsulatedPKIDataType.setId("time-stamp-token-" + UUID.randomUUID().toString());
        return xAdESTimeStampType;
    }

    private ValidationDataType createValidationData(RevocationData revocationData) {
        ValidationDataType validationDataType = ValidationDataType.Factory.newInstance();
        RevocationValuesType revocationValuesType = validationDataType.addNewRevocationValues();
        this.createRevocationValues(revocationValuesType, revocationData);
        return validationDataType;
    }

    private void createRevocationValues(RevocationValuesType revocationValuesType, RevocationData revocationData) {
        EncapsulatedPKIDataType encapsulatedPKIDataType;
        CRLValuesType cRLValuesType;
        if (revocationData.hasCRLs()) {
            cRLValuesType = revocationValuesType.addNewCRLValues();
            for (byte[] byArray : revocationData.getCRLs()) {
                encapsulatedPKIDataType = cRLValuesType.addNewEncapsulatedCRLValue();
                encapsulatedPKIDataType.setByteArrayValue(byArray);
            }
        }
        if (revocationData.hasOCSPs()) {
            cRLValuesType = revocationValuesType.addNewOCSPValues();
            for (byte[] byArray : revocationData.getOCSPs()) {
                encapsulatedPKIDataType = cRLValuesType.addNewEncapsulatedOCSPValue();
                encapsulatedPKIDataType.setByteArrayValue(byArray);
            }
        }
    }
}

