/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig;

import ai2.org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SignatureMarshalListener
implements EventListener,
SignatureConfig.SignatureConfigurable {
    ThreadLocal<EventTarget> target = new ThreadLocal();
    SignatureConfig signatureConfig;

    public void setEventTarget(EventTarget eventTarget) {
        this.target.set(eventTarget);
    }

    public void handleEvent(Event event) {
        if (!(event instanceof MutationEvent)) {
            return;
        }
        MutationEvent mutationEvent = (MutationEvent)event;
        EventTarget eventTarget = mutationEvent.getTarget();
        if (!(eventTarget instanceof Element)) {
            return;
        }
        this.handleElement((Element)((Object)eventTarget));
    }

    public void handleElement(Element element) {
        EventTarget eventTarget = this.target.get();
        String string = this.signatureConfig.getPackageSignatureId();
        if (element.hasAttribute("Id")) {
            element.setIdAttribute("Id", true);
        }
        SignatureMarshalListener.setListener(eventTarget, this, false);
        if (string.equals(element.getAttribute("Id"))) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        }
        this.setPrefix(element);
        SignatureMarshalListener.setListener(eventTarget, this, true);
    }

    public static void setListener(EventTarget eventTarget, EventListener eventListener, boolean bl) {
        String string = "DOMSubtreeModified";
        boolean bl2 = false;
        if (bl) {
            eventTarget.addEventListener(string, eventListener, bl2);
        } else {
            eventTarget.removeEventListener(string, eventListener, bl2);
        }
    }

    protected void setPrefix(Node node) {
        String string = this.signatureConfig.getNamespacePrefixes().get(node.getNamespaceURI());
        if (string != null && node.getPrefix() == null) {
            node.setPrefix(string);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.setPrefix(nodeList.item(i));
        }
    }

    public void setSignatureConfig(SignatureConfig signatureConfig) {
        this.signatureConfig = signatureConfig;
    }
}

