/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.dsig.OOXMLURIDereferencer;
import ai2.org.apache.poi.poifs.crypt.dsig.SignatureMarshalListener;
import ai2.org.apache.poi.poifs.crypt.dsig.facets.KeyInfoSignatureFacet;
import ai2.org.apache.poi.poifs.crypt.dsig.facets.OOXMLSignatureFacet;
import ai2.org.apache.poi.poifs.crypt.dsig.facets.Office2010SignatureFacet;
import ai2.org.apache.poi.poifs.crypt.dsig.facets.SignatureFacet;
import ai2.org.apache.poi.poifs.crypt.dsig.facets.XAdESSignatureFacet;
import ai2.org.apache.poi.poifs.crypt.dsig.services.RevocationDataService;
import ai2.org.apache.poi.poifs.crypt.dsig.services.SignaturePolicyService;
import ai2.org.apache.poi.poifs.crypt.dsig.services.TSPTimeStampService;
import ai2.org.apache.poi.poifs.crypt.dsig.services.TimeStampService;
import ai2.org.apache.poi.poifs.crypt.dsig.services.TimeStampServiceValidator;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import org.w3c.dom.events.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureConfig {
    private static final POILogger LOG = POILogFactory.getLogger(SignatureConfig.class);
    private ThreadLocal<OPCPackage> opcPackage = new ThreadLocal();
    private ThreadLocal<XMLSignatureFactory> signatureFactory = new ThreadLocal();
    private ThreadLocal<KeyInfoFactory> keyInfoFactory = new ThreadLocal();
    private ThreadLocal<Provider> provider = new ThreadLocal();
    private List<SignatureFacet> signatureFacets = new ArrayList<SignatureFacet>();
    private HashAlgorithm digestAlgo = HashAlgorithm.sha1;
    private Date executionTime = new Date();
    private PrivateKey key;
    private List<X509Certificate> signingCertificateChain;
    private SignaturePolicyService signaturePolicyService;
    private URIDereferencer uriDereferencer = null;
    private String canonicalizationMethod = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private boolean includeEntireCertificateChain = true;
    private boolean includeIssuerSerial = false;
    private boolean includeKeyValue = false;
    private TimeStampService tspService = new TSPTimeStampService();
    private String tspUrl;
    private boolean tspOldProtocol = false;
    private HashAlgorithm tspDigestAlgo = null;
    private String tspUser;
    private String tspPass;
    private TimeStampServiceValidator tspValidator;
    private String tspRequestPolicy = "1.3.6.1.4.1.13762.3";
    private String userAgent = "POI XmlSign Service TSP Client";
    private String proxyUrl;
    private RevocationDataService revocationDataService;
    private HashAlgorithm xadesDigestAlgo = null;
    private String xadesRole = null;
    private String xadesSignatureId = "idSignedProperties";
    private boolean xadesSignaturePolicyImplied = true;
    private String xadesCanonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private boolean xadesIssuerNameNoReverseOrder = true;
    private String packageSignatureId = "idPackageSignature";
    private String signatureDescription = "Office OpenXML Document";
    EventListener signatureMarshalListener = null;
    Map<String, String> namespacePrefixes = new HashMap<String, String>();

    protected void init(boolean bl) {
        if (this.opcPackage == null) {
            throw new EncryptedDocumentException("opcPackage is null");
        }
        if (this.uriDereferencer == null) {
            this.uriDereferencer = new OOXMLURIDereferencer();
        }
        if (this.uriDereferencer instanceof SignatureConfigurable) {
            ((SignatureConfigurable)((Object)this.uriDereferencer)).setSignatureConfig(this);
        }
        if (this.namespacePrefixes.isEmpty()) {
            this.namespacePrefixes.put("http://schemas.openxmlformats.org/package/2006/digital-signature", "mdssi");
            this.namespacePrefixes.put("http://uri.etsi.org/01903/v1.3.2#", "xd");
        }
        if (bl) {
            return;
        }
        if (this.signatureMarshalListener == null) {
            this.signatureMarshalListener = new SignatureMarshalListener();
        }
        if (this.signatureMarshalListener instanceof SignatureConfigurable) {
            ((SignatureConfigurable)((Object)this.signatureMarshalListener)).setSignatureConfig(this);
        }
        if (this.tspService != null) {
            this.tspService.setSignatureConfig(this);
        }
        if (this.signatureFacets.isEmpty()) {
            this.addSignatureFacet(new OOXMLSignatureFacet());
            this.addSignatureFacet(new KeyInfoSignatureFacet());
            this.addSignatureFacet(new XAdESSignatureFacet());
            this.addSignatureFacet(new Office2010SignatureFacet());
        }
        for (SignatureFacet signatureFacet : this.signatureFacets) {
            signatureFacet.setSignatureConfig(this);
        }
    }

    public void addSignatureFacet(SignatureFacet signatureFacet) {
        this.signatureFacets.add(signatureFacet);
    }

    public List<SignatureFacet> getSignatureFacets() {
        return this.signatureFacets;
    }

    public void setSignatureFacets(List<SignatureFacet> list) {
        this.signatureFacets = list;
    }

    public HashAlgorithm getDigestAlgo() {
        return this.digestAlgo;
    }

    public void setDigestAlgo(HashAlgorithm hashAlgorithm) {
        this.digestAlgo = hashAlgorithm;
    }

    public OPCPackage getOpcPackage() {
        return this.opcPackage.get();
    }

    public void setOpcPackage(OPCPackage oPCPackage) {
        this.opcPackage.set(oPCPackage);
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public void setKey(PrivateKey privateKey) {
        this.key = privateKey;
    }

    public List<X509Certificate> getSigningCertificateChain() {
        return this.signingCertificateChain;
    }

    public void setSigningCertificateChain(List<X509Certificate> list) {
        this.signingCertificateChain = list;
    }

    public Date getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(Date date) {
        this.executionTime = date;
    }

    public SignaturePolicyService getSignaturePolicyService() {
        return this.signaturePolicyService;
    }

    public void setSignaturePolicyService(SignaturePolicyService signaturePolicyService) {
        this.signaturePolicyService = signaturePolicyService;
    }

    public URIDereferencer getUriDereferencer() {
        return this.uriDereferencer;
    }

    public void setUriDereferencer(URIDereferencer uRIDereferencer) {
        this.uriDereferencer = uRIDereferencer;
    }

    public String getSignatureDescription() {
        return this.signatureDescription;
    }

    public void setSignatureDescription(String string) {
        this.signatureDescription = string;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String string) {
        this.canonicalizationMethod = string;
    }

    public String getPackageSignatureId() {
        return this.packageSignatureId;
    }

    public void setPackageSignatureId(String string) {
        this.packageSignatureId = SignatureConfig.nvl(string, "xmldsig-" + UUID.randomUUID());
    }

    public String getTspUrl() {
        return this.tspUrl;
    }

    public void setTspUrl(String string) {
        this.tspUrl = string;
    }

    public boolean isTspOldProtocol() {
        return this.tspOldProtocol;
    }

    public void setTspOldProtocol(boolean bl) {
        this.tspOldProtocol = bl;
    }

    public HashAlgorithm getTspDigestAlgo() {
        return SignatureConfig.nvl(this.tspDigestAlgo, this.digestAlgo);
    }

    public void setTspDigestAlgo(HashAlgorithm hashAlgorithm) {
        this.tspDigestAlgo = hashAlgorithm;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String string) {
        this.proxyUrl = string;
    }

    public TimeStampService getTspService() {
        return this.tspService;
    }

    public void setTspService(TimeStampService timeStampService) {
        this.tspService = timeStampService;
    }

    public String getTspUser() {
        return this.tspUser;
    }

    public void setTspUser(String string) {
        this.tspUser = string;
    }

    public String getTspPass() {
        return this.tspPass;
    }

    public void setTspPass(String string) {
        this.tspPass = string;
    }

    public TimeStampServiceValidator getTspValidator() {
        return this.tspValidator;
    }

    public void setTspValidator(TimeStampServiceValidator timeStampServiceValidator) {
        this.tspValidator = timeStampServiceValidator;
    }

    public RevocationDataService getRevocationDataService() {
        return this.revocationDataService;
    }

    public void setRevocationDataService(RevocationDataService revocationDataService) {
        this.revocationDataService = revocationDataService;
    }

    public HashAlgorithm getXadesDigestAlgo() {
        return SignatureConfig.nvl(this.xadesDigestAlgo, this.digestAlgo);
    }

    public void setXadesDigestAlgo(HashAlgorithm hashAlgorithm) {
        this.xadesDigestAlgo = hashAlgorithm;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public String getTspRequestPolicy() {
        return this.tspRequestPolicy;
    }

    public void setTspRequestPolicy(String string) {
        this.tspRequestPolicy = string;
    }

    public boolean isIncludeEntireCertificateChain() {
        return this.includeEntireCertificateChain;
    }

    public void setIncludeEntireCertificateChain(boolean bl) {
        this.includeEntireCertificateChain = bl;
    }

    public boolean isIncludeIssuerSerial() {
        return this.includeIssuerSerial;
    }

    public void setIncludeIssuerSerial(boolean bl) {
        this.includeIssuerSerial = bl;
    }

    public boolean isIncludeKeyValue() {
        return this.includeKeyValue;
    }

    public void setIncludeKeyValue(boolean bl) {
        this.includeKeyValue = bl;
    }

    public String getXadesRole() {
        return this.xadesRole;
    }

    public void setXadesRole(String string) {
        this.xadesRole = string;
    }

    public String getXadesSignatureId() {
        return SignatureConfig.nvl(this.xadesSignatureId, "idSignedProperties");
    }

    public void setXadesSignatureId(String string) {
        this.xadesSignatureId = string;
    }

    public boolean isXadesSignaturePolicyImplied() {
        return this.xadesSignaturePolicyImplied;
    }

    public void setXadesSignaturePolicyImplied(boolean bl) {
        this.xadesSignaturePolicyImplied = bl;
    }

    public boolean isXadesIssuerNameNoReverseOrder() {
        return this.xadesIssuerNameNoReverseOrder;
    }

    public void setXadesIssuerNameNoReverseOrder(boolean bl) {
        this.xadesIssuerNameNoReverseOrder = bl;
    }

    public EventListener getSignatureMarshalListener() {
        return this.signatureMarshalListener;
    }

    public void setSignatureMarshalListener(EventListener eventListener) {
        this.signatureMarshalListener = eventListener;
    }

    public Map<String, String> getNamespacePrefixes() {
        return this.namespacePrefixes;
    }

    public void setNamespacePrefixes(Map<String, String> map) {
        this.namespacePrefixes = map;
    }

    protected static <T> T nvl(T t, T t2) {
        return t == null ? t2 : t;
    }

    public byte[] getHashMagic() {
        byte[] byArray;
        switch (this.getDigestAlgo()) {
            case sha1: {
                byArray = new byte[]{48, 31, 48, 7, 6, 5, 43, 14, 3, 2, 26, 4, 20};
                break;
            }
            case sha224: {
                byArray = new byte[]{48, 43, 48, 11, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 4, 4, 28};
                break;
            }
            case sha256: {
                byArray = new byte[]{48, 47, 48, 11, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 4, 32};
                break;
            }
            case sha384: {
                byArray = new byte[]{48, 63, 48, 11, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 4, 48};
                break;
            }
            case sha512: {
                byArray = new byte[]{48, 79, 48, 11, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 4, 64};
                break;
            }
            case ripemd128: {
                byArray = new byte[]{48, 27, 48, 7, 6, 5, 43, 36, 3, 2, 2, 4, 16};
                break;
            }
            case ripemd160: {
                byArray = new byte[]{48, 31, 48, 7, 6, 5, 43, 36, 3, 2, 1, 4, 20};
                break;
            }
            default: {
                throw new EncryptedDocumentException("Hash algorithm " + (Object)((Object)this.getDigestAlgo()) + " not supported for signing.");
            }
        }
        return byArray;
    }

    public String getSignatureMethodUri() {
        switch (this.getDigestAlgo()) {
            case sha1: {
                return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
            case sha224: {
                return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha224";
            }
            case sha256: {
                return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
            }
            case sha384: {
                return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
            }
            case sha512: {
                return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
            }
            case ripemd160: {
                return "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
            }
        }
        throw new EncryptedDocumentException("Hash algorithm " + (Object)((Object)this.getDigestAlgo()) + " not supported for signing.");
    }

    public String getDigestMethodUri() {
        return SignatureConfig.getDigestMethodUri(this.getDigestAlgo());
    }

    public static String getDigestMethodUri(HashAlgorithm hashAlgorithm) {
        switch (hashAlgorithm) {
            case sha1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case sha224: {
                return "http://www.w3.org/2001/04/xmldsig-more#sha224";
            }
            case sha256: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
            case sha384: {
                return "http://www.w3.org/2001/04/xmldsig-more#sha384";
            }
            case sha512: {
                return "http://www.w3.org/2001/04/xmlenc#sha512";
            }
            case ripemd160: {
                return "http://www.w3.org/2001/04/xmlenc#ripemd160";
            }
        }
        throw new EncryptedDocumentException("Hash algorithm " + (Object)((Object)hashAlgorithm) + " not supported for signing.");
    }

    public void setSignatureFactory(XMLSignatureFactory xMLSignatureFactory) {
        this.signatureFactory.set(xMLSignatureFactory);
    }

    public XMLSignatureFactory getSignatureFactory() {
        XMLSignatureFactory xMLSignatureFactory = this.signatureFactory.get();
        if (xMLSignatureFactory == null) {
            xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", this.getProvider());
            this.setSignatureFactory(xMLSignatureFactory);
        }
        return xMLSignatureFactory;
    }

    public void setKeyInfoFactory(KeyInfoFactory keyInfoFactory) {
        this.keyInfoFactory.set(keyInfoFactory);
    }

    public KeyInfoFactory getKeyInfoFactory() {
        KeyInfoFactory keyInfoFactory = this.keyInfoFactory.get();
        if (keyInfoFactory == null) {
            keyInfoFactory = KeyInfoFactory.getInstance("DOM", this.getProvider());
            this.setKeyInfoFactory(keyInfoFactory);
        }
        return keyInfoFactory;
    }

    public Provider getProvider() {
        Provider provider = this.provider.get();
        if (provider == null) {
            String[] stringArray;
            for (String string : stringArray = new String[]{System.getProperty("jsr105Provider"), "org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI", "org.jcp.xml.dsig.internal.dom.XMLDSigRI"}) {
                if (string == null) continue;
                try {
                    provider = (Provider)Class.forName(string).newInstance();
                    break;
                }
                catch (Exception exception) {
                    LOG.log(1, new Object[]{"XMLDsig-Provider '" + string + "' can't be found - trying next."});
                }
            }
        }
        if (provider == null) {
            throw new RuntimeException("JRE doesn't support default xml signature provider - set jsr105Provider system property!");
        }
        return provider;
    }

    public String getXadesCanonicalizationMethod() {
        return this.xadesCanonicalizationMethod;
    }

    public void setXadesCanonicalizationMethod(String string) {
        this.xadesCanonicalizationMethod = string;
    }

    public static interface SignatureConfigurable {
        public void setSignatureConfig(SignatureConfig var1);
    }
}

