/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;

public class OOXMLURIDereferencer
implements URIDereferencer,
SignatureConfig.SignatureConfigurable {
    private static final POILogger LOG = POILogFactory.getLogger(OOXMLURIDereferencer.class);
    private SignatureConfig signatureConfig;
    private URIDereferencer baseUriDereferencer;

    public void setSignatureConfig(SignatureConfig signatureConfig) {
        this.signatureConfig = signatureConfig;
    }

    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        InputStream inputStream;
        URI uRI;
        if (this.baseUriDereferencer == null) {
            this.baseUriDereferencer = this.signatureConfig.getSignatureFactory().getURIDereferencer();
        }
        if (null == uRIReference) {
            throw new NullPointerException("URIReference cannot be null");
        }
        if (null == xMLCryptoContext) {
            throw new NullPointerException("XMLCrytoContext cannot be null");
        }
        try {
            uRI = new URI(uRIReference.getURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new URIReferenceException("could not URL decode the uri: " + uRIReference.getURI(), uRISyntaxException);
        }
        PackagePart packagePart = this.findPart(uRI);
        if (packagePart == null) {
            LOG.log(1, "cannot resolve, delegating to base DOM URI dereferencer", uRI);
            return this.baseUriDereferencer.dereference(uRIReference, xMLCryptoContext);
        }
        try {
            inputStream = packagePart.getInputStream();
            if (packagePart.getPartName().toString().endsWith(".rels")) {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read()) != -1) {
                    if (n == 10 || n == 13) continue;
                    byteArrayOutputStream.write(n);
                }
                inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        }
        catch (IOException iOException) {
            throw new URIReferenceException("I/O error: " + iOException.getMessage(), iOException);
        }
        return new OctetStreamData(inputStream, uRI.toString(), null);
    }

    private PackagePart findPart(URI uRI) {
        PackagePartName packagePartName;
        LOG.log(1, "dereference", uRI);
        String string = uRI.getPath();
        if (string == null || "".equals(string)) {
            LOG.log(1, "illegal part name (expected)", uRI);
            return null;
        }
        try {
            packagePartName = PackagingURIHelper.createPartName(string);
        }
        catch (InvalidFormatException invalidFormatException) {
            LOG.log(5, "illegal part name (not expected)", uRI);
            return null;
        }
        return this.signatureConfig.getOpcPackage().getPart(packagePartName);
    }
}

