/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig;

import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfoKeySelector
extends KeySelector
implements KeySelectorResult {
    private static final POILogger LOG = POILogFactory.getLogger(KeyInfoKeySelector.class);
    private List<X509Certificate> certChain = new ArrayList<X509Certificate>();

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        LOG.log(1, new Object[]{"select key"});
        if (null == keyInfo) {
            throw new KeySelectorException("no ds:KeyInfo present");
        }
        List<XMLStructure> list = keyInfo.getContent();
        this.certChain.clear();
        for (XMLStructure xMLStructure : list) {
            if (!(xMLStructure instanceof X509Data)) continue;
            X509Data x509Data = (X509Data)xMLStructure;
            List<?> list2 = x509Data.getContent();
            for (Object obj : list2) {
                if (!(obj instanceof X509Certificate)) continue;
                X509Certificate x509Certificate = (X509Certificate)obj;
                LOG.log(1, "certificate", x509Certificate.getSubjectX500Principal());
                this.certChain.add(x509Certificate);
            }
        }
        if (this.certChain.isEmpty()) {
            throw new KeySelectorException("No key found!");
        }
        return this;
    }

    @Override
    public Key getKey() {
        return this.certChain.isEmpty() ? null : this.certChain.get(0).getPublicKey();
    }

    public X509Certificate getSigner() {
        return this.certChain.isEmpty() ? null : this.certChain.get(0);
    }

    public List<X509Certificate> getCertChain() {
        return this.certChain;
    }
}

