/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.binaryrc4;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.ChunkedCipherInputStream;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.Decryptor;
import ai2.org.apache.poi.poifs.crypt.EncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.EncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.binaryrc4.BinaryRC4EncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class BinaryRC4Decryptor
extends Decryptor {
    private long _length = -1L;

    protected BinaryRC4Decryptor(BinaryRC4EncryptionInfoBuilder binaryRC4EncryptionInfoBuilder) {
        super(binaryRC4EncryptionInfoBuilder);
    }

    public boolean verifyPassword(String string) {
        EncryptionVerifier encryptionVerifier = this.builder.getVerifier();
        SecretKey secretKey = BinaryRC4Decryptor.generateSecretKey(string, encryptionVerifier);
        try {
            Cipher cipher = BinaryRC4Decryptor.initCipherForBlock(null, 0, this.builder, secretKey, 2);
            byte[] byArray = encryptionVerifier.getEncryptedVerifier();
            byte[] byArray2 = new byte[byArray.length];
            cipher.update(byArray, 0, byArray.length, byArray2);
            this.setVerifier(byArray2);
            byte[] byArray3 = encryptionVerifier.getEncryptedVerifierHash();
            byte[] byArray4 = cipher.doFinal(byArray3);
            HashAlgorithm hashAlgorithm = encryptionVerifier.getHashAlgorithm();
            MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
            byte[] byArray5 = messageDigest.digest(byArray2);
            if (Arrays.equals(byArray5, byArray4)) {
                this.setSecretKey(secretKey);
                return true;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException(generalSecurityException);
        }
        return false;
    }

    protected static Cipher initCipherForBlock(Cipher cipher, int n, EncryptionInfoBuilder encryptionInfoBuilder, SecretKey secretKey, int n2) throws GeneralSecurityException {
        EncryptionVerifier encryptionVerifier = encryptionInfoBuilder.getVerifier();
        HashAlgorithm hashAlgorithm = encryptionVerifier.getHashAlgorithm();
        byte[] byArray = new byte[4];
        LittleEndian.putUInt(byArray, 0, n);
        byte[] byArray2 = CryptoFunctions.generateKey(secretKey.getEncoded(), hashAlgorithm, byArray, 16);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, secretKey.getAlgorithm());
        if (cipher == null) {
            EncryptionHeader encryptionHeader = encryptionInfoBuilder.getHeader();
            cipher = CryptoFunctions.getCipher(secretKeySpec, encryptionHeader.getCipherAlgorithm(), null, null, n2);
        } else {
            cipher.init(n2, secretKeySpec);
        }
        return cipher;
    }

    protected static SecretKey generateSecretKey(String string, EncryptionVerifier encryptionVerifier) {
        if (string.length() > 255) {
            string = string.substring(0, 255);
        }
        HashAlgorithm hashAlgorithm = encryptionVerifier.getHashAlgorithm();
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
        byte[] byArray = messageDigest.digest(StringUtil.getToUnicodeLE(string));
        byte[] byArray2 = encryptionVerifier.getSalt();
        messageDigest.reset();
        for (int i = 0; i < 16; ++i) {
            messageDigest.update(byArray, 0, 5);
            messageDigest.update(byArray2);
        }
        byArray = new byte[5];
        System.arraycopy(messageDigest.digest(), 0, byArray, 0, 5);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, encryptionVerifier.getCipherAlgorithm().jceId);
        return secretKeySpec;
    }

    public InputStream getDataStream(DirectoryNode directoryNode) throws IOException, GeneralSecurityException {
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream("EncryptedPackage");
        this._length = documentInputStream.readLong();
        BinaryRC4CipherInputStream binaryRC4CipherInputStream = new BinaryRC4CipherInputStream(documentInputStream, this._length);
        return binaryRC4CipherInputStream;
    }

    public long getLength() {
        if (this._length == -1L) {
            throw new IllegalStateException("Decryptor.getDataStream() was not called");
        }
        return this._length;
    }

    private class BinaryRC4CipherInputStream
    extends ChunkedCipherInputStream {
        protected Cipher initCipherForBlock(Cipher cipher, int n) throws GeneralSecurityException {
            return BinaryRC4Decryptor.initCipherForBlock(cipher, n, BinaryRC4Decryptor.this.builder, BinaryRC4Decryptor.this.getSecretKey(), 2);
        }

        public BinaryRC4CipherInputStream(DocumentInputStream documentInputStream, long l) throws GeneralSecurityException {
            super(documentInputStream, l, 512);
        }
    }
}

