/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.agile;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.ChainingMode;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.EncryptionMode;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.agile.AgileDecryptor;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptor;
import ai2.org.apache.poi.util.LittleEndianInput;
import com.microsoft.schemas.office.x2006.encryption.EncryptionDocument;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xmlbeans.XmlException;

public class AgileEncryptionInfoBuilder
implements EncryptionInfoBuilder {
    EncryptionInfo info;
    AgileEncryptionHeader header;
    AgileEncryptionVerifier verifier;
    AgileDecryptor decryptor;
    AgileEncryptor encryptor;

    public void initialize(EncryptionInfo encryptionInfo, LittleEndianInput littleEndianInput) throws IOException {
        this.info = encryptionInfo;
        EncryptionDocument encryptionDocument = AgileEncryptionInfoBuilder.parseDescriptor((InputStream)((Object)littleEndianInput));
        this.header = new AgileEncryptionHeader(encryptionDocument);
        this.verifier = new AgileEncryptionVerifier(encryptionDocument);
        if (encryptionInfo.getVersionMajor() == EncryptionMode.agile.versionMajor && encryptionInfo.getVersionMinor() == EncryptionMode.agile.versionMinor) {
            this.decryptor = new AgileDecryptor(this);
            this.encryptor = new AgileEncryptor(this);
        }
    }

    public void initialize(EncryptionInfo encryptionInfo, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this.info = encryptionInfo;
        if (cipherAlgorithm == null) {
            cipherAlgorithm = CipherAlgorithm.aes128;
        }
        if (cipherAlgorithm == CipherAlgorithm.rc4) {
            throw new EncryptedDocumentException("RC4 must not be used with agile encryption.");
        }
        if (hashAlgorithm == null) {
            hashAlgorithm = HashAlgorithm.sha1;
        }
        if (chainingMode == null) {
            chainingMode = ChainingMode.cbc;
        }
        if (chainingMode != ChainingMode.cbc && chainingMode != ChainingMode.cfb) {
            throw new EncryptedDocumentException("Agile encryption only supports CBC/CFB chaining.");
        }
        if (n == -1) {
            n = cipherAlgorithm.defaultKeySize;
        }
        if (n2 == -1) {
            n2 = cipherAlgorithm.blockSize;
        }
        boolean bl = false;
        for (int n3 : cipherAlgorithm.allowedKeySize) {
            bl |= n3 == n;
        }
        if (!bl) {
            throw new EncryptedDocumentException("KeySize " + n + " not allowed for Cipher " + cipherAlgorithm.toString());
        }
        this.header = new AgileEncryptionHeader(cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
        this.verifier = new AgileEncryptionVerifier(cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
        this.decryptor = new AgileDecryptor(this);
        this.encryptor = new AgileEncryptor(this);
    }

    public AgileEncryptionHeader getHeader() {
        return this.header;
    }

    public AgileEncryptionVerifier getVerifier() {
        return this.verifier;
    }

    public AgileDecryptor getDecryptor() {
        return this.decryptor;
    }

    public AgileEncryptor getEncryptor() {
        return this.encryptor;
    }

    protected EncryptionInfo getInfo() {
        return this.info;
    }

    protected static EncryptionDocument parseDescriptor(String string) {
        try {
            return EncryptionDocument.Factory.parse((String)string);
        }
        catch (XmlException xmlException) {
            throw new EncryptedDocumentException("Unable to parse encryption descriptor", xmlException);
        }
    }

    protected static EncryptionDocument parseDescriptor(InputStream inputStream) {
        try {
            return EncryptionDocument.Factory.parse((InputStream)inputStream);
        }
        catch (Exception exception) {
            throw new EncryptedDocumentException("Unable to parse encryption descriptor", exception);
        }
    }
}

