/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.agile;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.ChainingMode;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.EncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptionInfoBuilder;
import com.microsoft.schemas.office.x2006.encryption.CTDataIntegrity;
import com.microsoft.schemas.office.x2006.encryption.CTKeyData;
import com.microsoft.schemas.office.x2006.encryption.EncryptionDocument;

public class AgileEncryptionHeader
extends EncryptionHeader {
    private byte[] encryptedHmacKey;
    private byte[] encryptedHmacValue;

    public AgileEncryptionHeader(String string) {
        this(AgileEncryptionInfoBuilder.parseDescriptor(string));
    }

    protected AgileEncryptionHeader(EncryptionDocument encryptionDocument) {
        CTKeyData cTKeyData;
        try {
            cTKeyData = encryptionDocument.getEncryption().getKeyData();
            if (cTKeyData == null) {
                throw new NullPointerException("keyData not set");
            }
        }
        catch (Exception exception) {
            throw new EncryptedDocumentException("Unable to parse keyData");
        }
        this.setKeySize((int)cTKeyData.getKeyBits());
        this.setFlags(0);
        this.setSizeExtra(0);
        this.setCspName(null);
        this.setBlockSize(cTKeyData.getBlockSize());
        int n = (int)cTKeyData.getKeyBits();
        CipherAlgorithm cipherAlgorithm = CipherAlgorithm.fromXmlId(cTKeyData.getCipherAlgorithm().toString(), n);
        this.setCipherAlgorithm(cipherAlgorithm);
        this.setCipherProvider(cipherAlgorithm.provider);
        switch (cTKeyData.getCipherChaining().intValue()) {
            case 1: {
                this.setChainingMode(ChainingMode.cbc);
                break;
            }
            case 2: {
                this.setChainingMode(ChainingMode.cfb);
                break;
            }
            default: {
                throw new EncryptedDocumentException("Unsupported chaining mode - " + cTKeyData.getCipherChaining().toString());
            }
        }
        int n2 = cTKeyData.getHashSize();
        HashAlgorithm hashAlgorithm = HashAlgorithm.fromEcmaId(cTKeyData.getHashAlgorithm().toString());
        this.setHashAlgorithm(hashAlgorithm);
        if (this.getHashAlgorithmEx().hashSize != n2) {
            throw new EncryptedDocumentException("Unsupported hash algorithm: " + cTKeyData.getHashAlgorithm() + " @ " + n2 + " bytes");
        }
        int n3 = cTKeyData.getSaltSize();
        this.setKeySalt(cTKeyData.getSaltValue());
        if (this.getKeySalt().length != n3) {
            throw new EncryptedDocumentException("Invalid salt length");
        }
        CTDataIntegrity cTDataIntegrity = encryptionDocument.getEncryption().getDataIntegrity();
        this.setEncryptedHmacKey(cTDataIntegrity.getEncryptedHmacKey());
        this.setEncryptedHmacValue(cTDataIntegrity.getEncryptedHmacValue());
    }

    public AgileEncryptionHeader(CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this.setCipherAlgorithm(cipherAlgorithm);
        this.setHashAlgorithm(hashAlgorithm);
        this.setKeySize(n);
        this.setBlockSize(n2);
        this.setChainingMode(chainingMode);
    }

    protected void setKeySalt(byte[] byArray) {
        if (byArray == null || byArray.length != this.getBlockSize()) {
            throw new EncryptedDocumentException("invalid verifier salt");
        }
        super.setKeySalt(byArray);
    }

    public byte[] getEncryptedHmacKey() {
        return this.encryptedHmacKey;
    }

    protected void setEncryptedHmacKey(byte[] byArray) {
        this.encryptedHmacKey = byArray;
    }

    public byte[] getEncryptedHmacValue() {
        return this.encryptedHmacValue;
    }

    protected void setEncryptedHmacValue(byte[] byArray) {
        this.encryptedHmacValue = byArray;
    }
}

