/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.agile;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.ChunkedCipherInputStream;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.Decryptor;
import ai2.org.apache.poi.poifs.crypt.EncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.EncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptionVerifier;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AgileDecryptor
extends Decryptor {
    private long _length = -1L;
    protected static final byte[] kVerifierInputBlock = new byte[]{-2, -89, -46, 118, 59, 75, -98, 121};
    protected static final byte[] kHashedVerifierBlock = new byte[]{-41, -86, 15, 109, 48, 97, 52, 78};
    protected static final byte[] kCryptoKeyBlock = new byte[]{20, 110, 11, -25, -85, -84, -48, -42};
    protected static final byte[] kIntegrityKeyBlock = new byte[]{95, -78, -83, 1, 12, -71, -31, -10};
    protected static final byte[] kIntegrityValueBlock = new byte[]{-96, 103, 127, 2, -78, 44, -124, 51};

    protected AgileDecryptor(AgileEncryptionInfoBuilder agileEncryptionInfoBuilder) {
        super(agileEncryptionInfoBuilder);
    }

    public boolean verifyPassword(String string) throws GeneralSecurityException {
        AgileEncryptionVerifier agileEncryptionVerifier = (AgileEncryptionVerifier)this.builder.getVerifier();
        AgileEncryptionHeader agileEncryptionHeader = (AgileEncryptionHeader)this.builder.getHeader();
        HashAlgorithm hashAlgorithm = agileEncryptionHeader.getHashAlgorithmEx();
        CipherAlgorithm cipherAlgorithm = agileEncryptionHeader.getCipherAlgorithm();
        int n = agileEncryptionHeader.getBlockSize();
        int n2 = agileEncryptionHeader.getKeySize() / 8;
        byte[] byArray = CryptoFunctions.hashPassword(string, agileEncryptionVerifier.getHashAlgorithm(), agileEncryptionVerifier.getSalt(), agileEncryptionVerifier.getSpinCount());
        byte[] byArray2 = AgileDecryptor.hashInput(this.builder, byArray, kVerifierInputBlock, agileEncryptionVerifier.getEncryptedVerifier(), 2);
        this.setVerifier(byArray2);
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
        byte[] byArray3 = messageDigest.digest(byArray2);
        byte[] byArray4 = AgileDecryptor.hashInput(this.builder, byArray, kHashedVerifierBlock, agileEncryptionVerifier.getEncryptedVerifierHash(), 2);
        byArray4 = CryptoFunctions.getBlock0(byArray4, hashAlgorithm.hashSize);
        byte[] byArray5 = AgileDecryptor.hashInput(this.builder, byArray, kCryptoKeyBlock, agileEncryptionVerifier.getEncryptedKey(), 2);
        byArray5 = CryptoFunctions.getBlock0(byArray5, n2);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray5, agileEncryptionVerifier.getCipherAlgorithm().jceId);
        byte[] byArray6 = CryptoFunctions.generateIv(hashAlgorithm, agileEncryptionHeader.getKeySalt(), kIntegrityKeyBlock, n);
        Cipher cipher = CryptoFunctions.getCipher(secretKeySpec, cipherAlgorithm, agileEncryptionVerifier.getChainingMode(), byArray6, 2);
        byte[] byArray7 = cipher.doFinal(agileEncryptionHeader.getEncryptedHmacKey());
        byArray7 = CryptoFunctions.getBlock0(byArray7, hashAlgorithm.hashSize);
        byArray6 = CryptoFunctions.generateIv(hashAlgorithm, agileEncryptionHeader.getKeySalt(), kIntegrityValueBlock, n);
        cipher = CryptoFunctions.getCipher(secretKeySpec, cipherAlgorithm, agileEncryptionVerifier.getChainingMode(), byArray6, 2);
        byte[] byArray8 = cipher.doFinal(agileEncryptionHeader.getEncryptedHmacValue());
        byArray8 = CryptoFunctions.getBlock0(byArray8, hashAlgorithm.hashSize);
        if (Arrays.equals(byArray4, byArray3)) {
            this.setSecretKey(secretKeySpec);
            this.setIntegrityHmacKey(byArray7);
            this.setIntegrityHmacValue(byArray8);
            return true;
        }
        return false;
    }

    public boolean verifyPassword(KeyPair keyPair, X509Certificate x509Certificate) throws GeneralSecurityException {
        AgileEncryptionVerifier agileEncryptionVerifier = (AgileEncryptionVerifier)this.builder.getVerifier();
        AgileEncryptionHeader agileEncryptionHeader = (AgileEncryptionHeader)this.builder.getHeader();
        HashAlgorithm hashAlgorithm = agileEncryptionHeader.getHashAlgorithmEx();
        CipherAlgorithm cipherAlgorithm = agileEncryptionHeader.getCipherAlgorithm();
        int n = agileEncryptionHeader.getBlockSize();
        AgileEncryptionVerifier.AgileCertificateEntry agileCertificateEntry = null;
        for (AgileEncryptionVerifier.AgileCertificateEntry object2 : agileEncryptionVerifier.getCertificates()) {
            if (!x509Certificate.equals(object2.x509)) continue;
            agileCertificateEntry = object2;
            break;
        }
        if (agileCertificateEntry == null) {
            return false;
        }
        Object object3 = Cipher.getInstance("RSA");
        ((Cipher)object3).init(2, keyPair.getPrivate());
        byte[] byArray = ((Cipher)object3).doFinal(agileCertificateEntry.encryptedKey);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, agileEncryptionVerifier.getCipherAlgorithm().jceId);
        Mac mac = CryptoFunctions.getMac(hashAlgorithm);
        mac.init(secretKeySpec);
        byte[] byArray2 = mac.doFinal(agileCertificateEntry.x509.getEncoded());
        byte[] byArray3 = CryptoFunctions.generateIv(hashAlgorithm, agileEncryptionHeader.getKeySalt(), kIntegrityKeyBlock, n);
        object3 = CryptoFunctions.getCipher(secretKeySpec, cipherAlgorithm, agileEncryptionVerifier.getChainingMode(), byArray3, 2);
        byte[] byArray4 = ((Cipher)object3).doFinal(agileEncryptionHeader.getEncryptedHmacKey());
        byArray4 = CryptoFunctions.getBlock0(byArray4, hashAlgorithm.hashSize);
        byArray3 = CryptoFunctions.generateIv(hashAlgorithm, agileEncryptionHeader.getKeySalt(), kIntegrityValueBlock, n);
        object3 = CryptoFunctions.getCipher(secretKeySpec, cipherAlgorithm, agileEncryptionVerifier.getChainingMode(), byArray3, 2);
        byte[] byArray5 = ((Cipher)object3).doFinal(agileEncryptionHeader.getEncryptedHmacValue());
        byArray5 = CryptoFunctions.getBlock0(byArray5, hashAlgorithm.hashSize);
        if (Arrays.equals(agileCertificateEntry.certVerifier, byArray2)) {
            this.setSecretKey(secretKeySpec);
            this.setIntegrityHmacKey(byArray4);
            this.setIntegrityHmacValue(byArray5);
            return true;
        }
        return false;
    }

    protected static int getNextBlockSize(int n, int n2) {
        int n3;
        for (n3 = n2; n3 < n; n3 += n2) {
        }
        return n3;
    }

    protected static byte[] hashInput(EncryptionInfoBuilder encryptionInfoBuilder, byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        EncryptionVerifier encryptionVerifier = encryptionInfoBuilder.getVerifier();
        AgileDecryptor agileDecryptor = (AgileDecryptor)encryptionInfoBuilder.getDecryptor();
        int n2 = agileDecryptor.getKeySizeInBytes();
        int n3 = agileDecryptor.getBlockSizeInBytes();
        HashAlgorithm hashAlgorithm = encryptionVerifier.getHashAlgorithm();
        byte[] byArray4 = encryptionVerifier.getSalt();
        byte[] byArray5 = CryptoFunctions.generateKey(byArray, hashAlgorithm, byArray2, n2);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray5, encryptionVerifier.getCipherAlgorithm().jceId);
        byte[] byArray6 = CryptoFunctions.generateIv(hashAlgorithm, byArray4, null, n3);
        Cipher cipher = CryptoFunctions.getCipher(secretKeySpec, encryptionVerifier.getCipherAlgorithm(), encryptionVerifier.getChainingMode(), byArray6, n);
        try {
            byArray3 = CryptoFunctions.getBlock0(byArray3, AgileDecryptor.getNextBlockSize(byArray3.length, n3));
            byte[] byArray7 = cipher.doFinal(byArray3);
            return byArray7;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException(generalSecurityException);
        }
    }

    public InputStream getDataStream(DirectoryNode directoryNode) throws IOException, GeneralSecurityException {
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream("EncryptedPackage");
        this._length = documentInputStream.readLong();
        AgileCipherInputStream agileCipherInputStream = new AgileCipherInputStream(documentInputStream, this._length);
        return agileCipherInputStream;
    }

    public long getLength() {
        if (this._length == -1L) {
            throw new IllegalStateException("EcmaDecryptor.getDataStream() was not called");
        }
        return this._length;
    }

    protected static Cipher initCipherForBlock(Cipher cipher, int n, boolean bl, EncryptionInfoBuilder encryptionInfoBuilder, SecretKey secretKey, int n2) throws GeneralSecurityException {
        Object object;
        EncryptionHeader encryptionHeader = encryptionInfoBuilder.getHeader();
        if (cipher == null || bl) {
            object = bl ? "PKCS5Padding" : "NoPadding";
            cipher = CryptoFunctions.getCipher(secretKey, encryptionHeader.getCipherAlgorithm(), encryptionHeader.getChainingMode(), encryptionHeader.getKeySalt(), n2, (String)object);
        }
        object = new byte[4];
        LittleEndian.putInt((byte[])object, 0, n);
        byte[] byArray = CryptoFunctions.generateIv(encryptionHeader.getHashAlgorithmEx(), encryptionHeader.getKeySalt(), (byte[])object, encryptionHeader.getBlockSize());
        AlgorithmParameterSpec algorithmParameterSpec = encryptionHeader.getCipherAlgorithm() == CipherAlgorithm.rc2 ? new RC2ParameterSpec(secretKey.getEncoded().length * 8, byArray) : new IvParameterSpec(byArray);
        cipher.init(n2, (Key)secretKey, algorithmParameterSpec);
        return cipher;
    }

    private class AgileCipherInputStream
    extends ChunkedCipherInputStream {
        public AgileCipherInputStream(DocumentInputStream documentInputStream, long l) throws GeneralSecurityException {
            super(documentInputStream, l, 4096);
        }

        protected Cipher initCipherForBlock(Cipher cipher, int n) throws GeneralSecurityException {
            return AgileDecryptor.initCipherForBlock(cipher, n, false, AgileDecryptor.this.builder, AgileDecryptor.this.getSecretKey(), 2);
        }
    }
}

