/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;

public abstract class Decryptor {
    public static final String DEFAULT_PASSWORD = "VelvetSweatshop";
    public static final String DEFAULT_POIFS_ENTRY = "EncryptedPackage";
    protected final EncryptionInfoBuilder builder;
    private SecretKey secretKey;
    private byte[] verifier;
    private byte[] integrityHmacKey;
    private byte[] integrityHmacValue;

    protected Decryptor(EncryptionInfoBuilder encryptionInfoBuilder) {
        this.builder = encryptionInfoBuilder;
    }

    public abstract InputStream getDataStream(DirectoryNode var1) throws IOException, GeneralSecurityException;

    public abstract boolean verifyPassword(String var1) throws GeneralSecurityException;

    public abstract long getLength();

    public static Decryptor getInstance(EncryptionInfo encryptionInfo) {
        Decryptor decryptor = encryptionInfo.getDecryptor();
        if (decryptor == null) {
            throw new EncryptedDocumentException("Unsupported version");
        }
        return decryptor;
    }

    public InputStream getDataStream(NPOIFSFileSystem nPOIFSFileSystem) throws IOException, GeneralSecurityException {
        return this.getDataStream(nPOIFSFileSystem.getRoot());
    }

    public InputStream getDataStream(OPOIFSFileSystem oPOIFSFileSystem) throws IOException, GeneralSecurityException {
        return this.getDataStream(oPOIFSFileSystem.getRoot());
    }

    public InputStream getDataStream(POIFSFileSystem pOIFSFileSystem) throws IOException, GeneralSecurityException {
        return this.getDataStream(pOIFSFileSystem.getRoot());
    }

    public byte[] getVerifier() {
        return this.verifier;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public byte[] getIntegrityHmacKey() {
        return this.integrityHmacKey;
    }

    public byte[] getIntegrityHmacValue() {
        return this.integrityHmacValue;
    }

    protected void setSecretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
    }

    protected void setVerifier(byte[] byArray) {
        this.verifier = byArray;
    }

    protected void setIntegrityHmacKey(byte[] byArray) {
        this.integrityHmacKey = byArray;
    }

    protected void setIntegrityHmacValue(byte[] byArray) {
        this.integrityHmacValue = byArray;
    }

    protected int getBlockSizeInBytes() {
        return this.builder.getHeader().getBlockSize();
    }

    protected int getKeySizeInBytes() {
        return this.builder.getHeader().getKeySize() / 8;
    }
}

