/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt;

import ai2.org.apache.poi.EncryptedDocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CipherProvider {
    rc4("RC4", 1, "Microsoft Base Cryptographic Provider v1.0"),
    aes("AES", 24, "Microsoft Enhanced RSA and AES Cryptographic Provider");

    public final String jceId;
    public final int ecmaId;
    public final String cipherProviderName;

    public static CipherProvider fromEcmaId(int n) {
        for (CipherProvider cipherProvider : CipherProvider.values()) {
            if (cipherProvider.ecmaId != n) continue;
            return cipherProvider;
        }
        throw new EncryptedDocumentException("cipher provider not found");
    }

    private CipherProvider(String string2, int n2, String string3) {
        this.jceId = string2;
        this.ecmaId = n2;
        this.cipherProviderName = string3;
    }
}

