/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentOutputStream;
import ai2.org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import ai2.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.TempFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

@Internal
public abstract class ChunkedCipherOutputStream
extends FilterOutputStream {
    protected final int chunkSize;
    protected final int chunkMask;
    protected final int chunkBits;
    private final byte[] _chunk;
    private final File fileOut;
    private final DirectoryNode dir;
    private long _pos = 0L;
    private Cipher _cipher;

    public ChunkedCipherOutputStream(DirectoryNode directoryNode, int n) throws IOException, GeneralSecurityException {
        super(null);
        this.chunkSize = n;
        this.chunkMask = n - 1;
        this.chunkBits = Integer.bitCount(this.chunkMask);
        this._chunk = new byte[n];
        this.fileOut = TempFile.createTempFile("encrypted_package", "crypt");
        this.fileOut.deleteOnExit();
        this.out = new FileOutputStream(this.fileOut);
        this.dir = directoryNode;
        this._cipher = this.initCipherForBlock(null, 0, false);
    }

    protected abstract Cipher initCipherForBlock(Cipher var1, int var2, boolean var3) throws GeneralSecurityException;

    protected abstract void calculateChecksum(File var1, int var2) throws GeneralSecurityException, IOException;

    protected abstract void createEncryptionInfoEntry(DirectoryNode var1, File var2) throws IOException, GeneralSecurityException;

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (n2 < 0 || byArray.length < n + n2) {
            throw new IOException("not enough bytes in your input buffer");
        }
        while (n2 > 0) {
            int n3 = (int)(this._pos & (long)this.chunkMask);
            int n4 = Math.min(this.chunkSize - n3, n2);
            System.arraycopy(byArray, n, this._chunk, n3, n4);
            this._pos += (long)n4;
            n += n4;
            n2 -= n4;
            if ((this._pos & (long)this.chunkMask) != 0L) continue;
            try {
                this.writeChunk();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException(generalSecurityException);
            }
        }
    }

    protected void writeChunk() throws IOException, GeneralSecurityException {
        boolean bl;
        int n = (int)(this._pos & (long)this.chunkMask);
        int n2 = (int)(this._pos >> this.chunkBits);
        if (n == 0) {
            --n2;
            n = this.chunkSize;
            bl = false;
        } else {
            bl = true;
        }
        this._cipher = this.initCipherForBlock(this._cipher, n2, bl);
        int n3 = this._cipher.doFinal(this._chunk, 0, n, this._chunk);
        this.out.write(this._chunk, 0, n3);
    }

    public void close() throws IOException {
        try {
            this.writeChunk();
            super.close();
            int n = (int)(this.fileOut.length() + 8L);
            this.calculateChecksum(this.fileOut, (int)this._pos);
            this.dir.createDocument("EncryptedPackage", n, new EncryptedPackageWriter());
            this.createEncryptionInfoEntry(this.dir, this.fileOut);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException(generalSecurityException);
        }
    }

    private class EncryptedPackageWriter
    implements POIFSWriterListener {
        private EncryptedPackageWriter() {
        }

        public void processPOIFSWriterEvent(POIFSWriterEvent pOIFSWriterEvent) {
            try {
                int n;
                DocumentOutputStream documentOutputStream = pOIFSWriterEvent.getStream();
                byte[] byArray = new byte[ChunkedCipherOutputStream.this.chunkSize];
                LittleEndian.putLong(byArray, 0, ChunkedCipherOutputStream.this._pos);
                ((OutputStream)documentOutputStream).write(byArray, 0, 8);
                FileInputStream fileInputStream = new FileInputStream(ChunkedCipherOutputStream.this.fileOut);
                while ((n = fileInputStream.read(byArray)) != -1) {
                    ((OutputStream)documentOutputStream).write(byArray, 0, n);
                }
                fileInputStream.close();
                ((OutputStream)documentOutputStream).close();
                ChunkedCipherOutputStream.this.fileOut.delete();
            }
            catch (IOException iOException) {
                throw new EncryptedDocumentException(iOException);
            }
        }
    }
}

