/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.util;

import ai2.org.apache.poi.openxml4j.util.ZipEntrySource;
import ai2.org.apache.poi.openxml4j.util.ZipSecureFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipInputStreamZipEntrySource
implements ZipEntrySource {
    private ArrayList<FakeZipEntry> zipEntries = new ArrayList();

    public ZipInputStreamZipEntrySource(ZipSecureFile.ThresholdInputStream thresholdInputStream) throws IOException {
        boolean bl = true;
        while (bl) {
            ZipEntry zipEntry = thresholdInputStream.getNextEntry();
            if (zipEntry == null) {
                bl = false;
                continue;
            }
            FakeZipEntry fakeZipEntry = new FakeZipEntry(zipEntry, thresholdInputStream);
            thresholdInputStream.closeEntry();
            this.zipEntries.add(fakeZipEntry);
        }
        thresholdInputStream.close();
    }

    @Override
    public Enumeration<? extends ZipEntry> getEntries() {
        return new EntryEnumerator();
    }

    @Override
    public InputStream getInputStream(ZipEntry zipEntry) {
        assert (zipEntry instanceof FakeZipEntry);
        FakeZipEntry fakeZipEntry = (FakeZipEntry)zipEntry;
        return fakeZipEntry.getInputStream();
    }

    @Override
    public void close() {
        this.zipEntries = null;
    }

    public static class FakeZipEntry
    extends ZipEntry {
        private byte[] data;

        public FakeZipEntry(ZipEntry zipEntry, InputStream inputStream) throws IOException {
            super(zipEntry.getName());
            ByteArrayOutputStream byteArrayOutputStream;
            long l = zipEntry.getSize();
            if (l != -1L) {
                if (l >= Integer.MAX_VALUE) {
                    throw new IOException("ZIP entry size is too large");
                }
                byteArrayOutputStream = new ByteArrayOutputStream((int)l);
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream();
            }
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.data = byteArrayOutputStream.toByteArray();
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryEnumerator
    implements Enumeration<ZipEntry> {
        private Iterator<? extends ZipEntry> iterator;

        private EntryEnumerator() {
            this.iterator = ZipInputStreamZipEntrySource.this.zipEntries.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public ZipEntry nextElement() {
            return this.iterator.next();
        }
    }
}

