/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc.internal.unmarshallers;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.ZipPackage;
import ai2.org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import ai2.org.apache.poi.openxml4j.opc.internal.PartUnmarshaller;
import ai2.org.apache.poi.openxml4j.opc.internal.ZipHelper;
import ai2.org.apache.poi.openxml4j.opc.internal.unmarshallers.UnmarshallContext;
import ai2.org.apache.poi.util.DocumentHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.SAXException;

public final class PackagePropertiesUnmarshaller
implements PartUnmarshaller {
    protected static final String KEYWORD_CATEGORY = "category";
    protected static final String KEYWORD_CONTENT_STATUS = "contentStatus";
    protected static final String KEYWORD_CONTENT_TYPE = "contentType";
    protected static final String KEYWORD_CREATED = "created";
    protected static final String KEYWORD_CREATOR = "creator";
    protected static final String KEYWORD_DESCRIPTION = "description";
    protected static final String KEYWORD_IDENTIFIER = "identifier";
    protected static final String KEYWORD_KEYWORDS = "keywords";
    protected static final String KEYWORD_LANGUAGE = "language";
    protected static final String KEYWORD_LAST_MODIFIED_BY = "lastModifiedBy";
    protected static final String KEYWORD_LAST_PRINTED = "lastPrinted";
    protected static final String KEYWORD_MODIFIED = "modified";
    protected static final String KEYWORD_REVISION = "revision";
    protected static final String KEYWORD_SUBJECT = "subject";
    protected static final String KEYWORD_TITLE = "title";
    protected static final String KEYWORD_VERSION = "version";

    public PackagePart unmarshall(UnmarshallContext unmarshallContext, InputStream inputStream) throws InvalidFormatException, IOException {
        Object object;
        PackagePropertiesPart packagePropertiesPart = new PackagePropertiesPart(unmarshallContext.getPackage(), unmarshallContext.getPartName());
        if (inputStream == null) {
            if (unmarshallContext.getZipEntry() != null) {
                inputStream = ((ZipPackage)unmarshallContext.getPackage()).getZipArchive().getInputStream(unmarshallContext.getZipEntry());
            } else if (unmarshallContext.getPackage() != null) {
                object = ZipHelper.getCorePropertiesZipEntry((ZipPackage)unmarshallContext.getPackage());
                inputStream = ((ZipPackage)unmarshallContext.getPackage()).getZipArchive().getInputStream((ZipEntry)object);
            } else {
                throw new IOException("Error while trying to get the part input stream.");
            }
        }
        try {
            object = DocumentHelper.readDocument(inputStream);
            this.checkElementForOPCCompliance(object.getDocumentElement());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        packagePropertiesPart.setCategoryProperty(this.loadCategory((Document)object));
        packagePropertiesPart.setContentStatusProperty(this.loadContentStatus((Document)object));
        packagePropertiesPart.setContentTypeProperty(this.loadContentType((Document)object));
        packagePropertiesPart.setCreatedProperty(this.loadCreated((Document)object));
        packagePropertiesPart.setCreatorProperty(this.loadCreator((Document)object));
        packagePropertiesPart.setDescriptionProperty(this.loadDescription((Document)object));
        packagePropertiesPart.setIdentifierProperty(this.loadIdentifier((Document)object));
        packagePropertiesPart.setKeywordsProperty(this.loadKeywords((Document)object));
        packagePropertiesPart.setLanguageProperty(this.loadLanguage((Document)object));
        packagePropertiesPart.setLastModifiedByProperty(this.loadLastModifiedBy((Document)object));
        packagePropertiesPart.setLastPrintedProperty(this.loadLastPrinted((Document)object));
        packagePropertiesPart.setModifiedProperty(this.loadModified((Document)object));
        packagePropertiesPart.setRevisionProperty(this.loadRevision((Document)object));
        packagePropertiesPart.setSubjectProperty(this.loadSubject((Document)object));
        packagePropertiesPart.setTitleProperty(this.loadTitle((Document)object));
        packagePropertiesPart.setVersionProperty(this.loadVersion((Document)object));
        return packagePropertiesPart;
    }

    private String readElement(Document document, String string, String string2) {
        Element element = (Element)document.getDocumentElement().getElementsByTagNameNS(string2, string).item(0);
        if (element == null) {
            return null;
        }
        return element.getTextContent();
    }

    private String loadCategory(Document document) {
        return this.readElement(document, KEYWORD_CATEGORY, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
    }

    private String loadContentStatus(Document document) {
        return this.readElement(document, KEYWORD_CONTENT_STATUS, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
    }

    private String loadContentType(Document document) {
        return this.readElement(document, KEYWORD_CONTENT_TYPE, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
    }

    private String loadCreated(Document document) {
        return this.readElement(document, KEYWORD_CREATED, "http://purl.org/dc/terms/");
    }

    private String loadCreator(Document document) {
        return this.readElement(document, KEYWORD_CREATOR, "http://purl.org/dc/elements/1.1/");
    }

    private String loadDescription(Document document) {
        return this.readElement(document, KEYWORD_DESCRIPTION, "http://purl.org/dc/elements/1.1/");
    }

    private String loadIdentifier(Document document) {
        return this.readElement(document, KEYWORD_IDENTIFIER, "http://purl.org/dc/elements/1.1/");
    }

    private String loadKeywords(Document document) {
        return this.readElement(document, KEYWORD_KEYWORDS, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
    }

    private String loadLanguage(Document document) {
        return this.readElement(document, KEYWORD_LANGUAGE, "http://purl.org/dc/elements/1.1/");
    }

    private String loadLastModifiedBy(Document document) {
        return this.readElement(document, KEYWORD_LAST_MODIFIED_BY, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
    }

    private String loadLastPrinted(Document document) {
        return this.readElement(document, KEYWORD_LAST_PRINTED, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
    }

    private String loadModified(Document document) {
        return this.readElement(document, KEYWORD_MODIFIED, "http://purl.org/dc/terms/");
    }

    private String loadRevision(Document document) {
        return this.readElement(document, KEYWORD_REVISION, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
    }

    private String loadSubject(Document document) {
        return this.readElement(document, KEYWORD_SUBJECT, "http://purl.org/dc/elements/1.1/");
    }

    private String loadTitle(Document document) {
        return this.readElement(document, KEYWORD_TITLE, "http://purl.org/dc/elements/1.1/");
    }

    private String loadVersion(Document document) {
        return this.readElement(document, KEYWORD_VERSION, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
    }

    public void checkElementForOPCCompliance(Element element) throws InvalidFormatException {
        Object object;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            object = (Attr)namedNodeMap.item(0);
            if (!object.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") || !object.getValue().equals("http://schemas.openxmlformats.org/markup-compatibility/2006")) continue;
            throw new InvalidFormatException("OPC Compliance error [M4.2]: A format consumer shall consider the use of the Markup Compatibility namespace to be an error.");
        }
        String string = element.getLocalName();
        if (element.getNamespaceURI().equals("http://purl.org/dc/terms/") && !string.equals(KEYWORD_CREATED) && !string.equals(KEYWORD_MODIFIED)) {
            throw new InvalidFormatException("OPC Compliance error [M4.3]: Producers shall not create a document element that contains refinements to the Dublin Core elements, except for the two specified in the schema: <dcterms:created> and <dcterms:modified> Consumers shall consider a document element that violates this constraint to be an error.");
        }
        if (element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang") != null) {
            throw new InvalidFormatException("OPC Compliance error [M4.4]: Producers shall not create a document element that contains the xml:lang attribute. Consumers shall consider a document element that violates this constraint to be an error.");
        }
        if (element.getNamespaceURI().equals("http://purl.org/dc/terms/")) {
            if (!string.equals(KEYWORD_CREATED) && !string.equals(KEYWORD_MODIFIED)) {
                throw new InvalidFormatException("Namespace error : " + string + " shouldn't have the following naemspace -> " + "http://purl.org/dc/terms/");
            }
            object = element.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (object == null) {
                throw new InvalidFormatException("The element '" + string + "' must have the 'xsi:type' attribute present !");
            }
            if (!object.getValue().equals(element.getPrefix() + ":W3CDTF")) {
                throw new InvalidFormatException("The element '" + string + "' must have the 'xsi:type' attribute with the value '" + element.getPrefix() + ":W3CDTF', but had '" + object.getValue() + "' !");
            }
        }
        object = element.getElementsByTagName("*");
        int n2 = object.getLength();
        for (int i = 0; i < n2; ++i) {
            this.checkElementForOPCCompliance((Element)object.item(i));
        }
    }
}

