/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc.internal.marshallers;

import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.StreamHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.openxml4j.opc.internal.PartMarshaller;
import ai2.org.apache.poi.openxml4j.opc.internal.ZipHelper;
import ai2.org.apache.poi.util.DocumentHelper;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ZipPartMarshaller
implements PartMarshaller {
    private static POILogger logger = POILogFactory.getLogger(ZipPartMarshaller.class);

    public boolean marshall(PackagePart packagePart, OutputStream outputStream) throws OpenXML4JException {
        Object object;
        if (!(outputStream instanceof ZipOutputStream)) {
            logger.log(7, new Object[]{"Unexpected class " + outputStream.getClass().getName()});
            throw new OpenXML4JException("ZipOutputStream expected !");
        }
        ZipOutputStream zipOutputStream = (ZipOutputStream)outputStream;
        ZipEntry zipEntry = new ZipEntry(ZipHelper.getZipItemNameFromOPCName(packagePart.getPartName().getURI().getPath()));
        try {
            int n;
            zipOutputStream.putNextEntry(zipEntry);
            object = packagePart.getInputStream();
            byte[] byArray = new byte[8192];
            while (((InputStream)object).available() > 0 && (n = ((InputStream)object).read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            logger.log(7, new Object[]{"Cannot write: " + packagePart.getPartName() + ": in ZIP", iOException});
            return false;
        }
        if (packagePart.hasRelationships()) {
            object = PackagingURIHelper.getRelationshipPartName(packagePart.getPartName());
            ZipPartMarshaller.marshallRelationshipPart(packagePart.getRelationships(), (PackagePartName)object, zipOutputStream);
        }
        return true;
    }

    public static boolean marshallRelationshipPart(PackageRelationshipCollection packageRelationshipCollection, PackagePartName packagePartName, ZipOutputStream zipOutputStream) {
        Document document = DocumentHelper.createDocument();
        Element element = document.createElementNS("http://schemas.openxmlformats.org/package/2006/relationships", "Relationships");
        document.appendChild(element);
        URI uRI = PackagingURIHelper.getSourcePartUriFromRelationshipPartUri(packagePartName.getURI());
        for (PackageRelationship packageRelationship : packageRelationshipCollection) {
            String string;
            Element element2 = document.createElementNS("http://schemas.openxmlformats.org/package/2006/relationships", "Relationship");
            element.appendChild(element2);
            element2.setAttribute("Id", packageRelationship.getId());
            element2.setAttribute("Type", packageRelationship.getRelationshipType());
            URI uRI2 = packageRelationship.getTargetURI();
            if (packageRelationship.getTargetMode() == TargetMode.EXTERNAL) {
                string = uRI2.toString();
                element2.setAttribute("TargetMode", "External");
            } else {
                URI uRI3 = packageRelationship.getTargetURI();
                string = PackagingURIHelper.relativizeURI(uRI, uRI3, true).toString();
            }
            element2.setAttribute("Target", string);
        }
        document.normalize();
        ZipEntry zipEntry = new ZipEntry(ZipHelper.getZipURIFromOPCName(packagePartName.getURI().toASCIIString()).getPath());
        try {
            zipOutputStream.putNextEntry(zipEntry);
            if (!StreamHelper.saveXmlInStream(document, zipOutputStream)) {
                return false;
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            logger.log(7, new Object[]{"Cannot create zip entry " + packagePartName, iOException});
            return false;
        }
        return true;
    }
}

