/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc.internal.marshallers;

import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.StreamHelper;
import ai2.org.apache.poi.openxml4j.opc.internal.ZipHelper;
import ai2.org.apache.poi.openxml4j.opc.internal.marshallers.PackagePropertiesMarshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipPackagePropertiesMarshaller
extends PackagePropertiesMarshaller {
    public boolean marshall(PackagePart packagePart, OutputStream outputStream) throws OpenXML4JException {
        if (!(outputStream instanceof ZipOutputStream)) {
            throw new IllegalArgumentException("ZipOutputStream expected!");
        }
        ZipOutputStream zipOutputStream = (ZipOutputStream)outputStream;
        ZipEntry zipEntry = new ZipEntry(ZipHelper.getZipItemNameFromOPCName(packagePart.getPartName().getURI().toString()));
        try {
            zipOutputStream.putNextEntry(zipEntry);
            super.marshall(packagePart, outputStream);
            if (!StreamHelper.saveXmlInStream(this.xmlDoc, outputStream)) {
                return false;
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            throw new OpenXML4JException(iOException.getLocalizedMessage());
        }
        return true;
    }
}

