/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc.internal;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.internal.ContentType;
import ai2.org.apache.poi.openxml4j.opc.internal.MemoryPackagePartOutputStream;
import ai2.org.apache.poi.openxml4j.opc.internal.marshallers.ZipPartMarshaller;
import ai2.org.apache.poi.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class MemoryPackagePart
extends PackagePart {
    protected byte[] data;

    public MemoryPackagePart(OPCPackage oPCPackage, PackagePartName packagePartName, String string) throws InvalidFormatException {
        super(oPCPackage, packagePartName, string);
    }

    public MemoryPackagePart(OPCPackage oPCPackage, PackagePartName packagePartName, String string, boolean bl) throws InvalidFormatException {
        super(oPCPackage, packagePartName, new ContentType(string), bl);
    }

    protected InputStream getInputStreamImpl() {
        if (this.data == null) {
            this.data = new byte[0];
        }
        return new ByteArrayInputStream(this.data);
    }

    protected OutputStream getOutputStreamImpl() {
        return new MemoryPackagePartOutputStream(this);
    }

    public long getSize() {
        return this.data == null ? 0L : (long)this.data.length;
    }

    public void clear() {
        this.data = null;
    }

    public boolean save(OutputStream outputStream) throws OpenXML4JException {
        return new ZipPartMarshaller().marshall(this, outputStream);
    }

    public boolean load(InputStream inputStream) throws InvalidFormatException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copy(inputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new InvalidFormatException(iOException.getMessage());
        }
        this.data = byteArrayOutputStream.toByteArray();
        return true;
    }

    public void close() {
    }

    public void flush() {
    }
}

