/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc.internal;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.util.DocumentHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentTypeManager {
    public static final String CONTENT_TYPES_PART_NAME = "[Content_Types].xml";
    public static final String TYPES_NAMESPACE_URI = "http://schemas.openxmlformats.org/package/2006/content-types";
    private static final String TYPES_TAG_NAME = "Types";
    private static final String DEFAULT_TAG_NAME = "Default";
    private static final String EXTENSION_ATTRIBUTE_NAME = "Extension";
    private static final String CONTENT_TYPE_ATTRIBUTE_NAME = "ContentType";
    private static final String OVERRIDE_TAG_NAME = "Override";
    private static final String PART_NAME_ATTRIBUTE_NAME = "PartName";
    protected OPCPackage container;
    private TreeMap<String, String> defaultContentType;
    private TreeMap<PackagePartName, String> overrideContentType;

    public ContentTypeManager(InputStream inputStream, OPCPackage oPCPackage) throws InvalidFormatException {
        this.container = oPCPackage;
        this.defaultContentType = new TreeMap();
        if (inputStream != null) {
            try {
                this.parseContentTypesFile(inputStream);
            }
            catch (InvalidFormatException invalidFormatException) {
                InvalidFormatException invalidFormatException2 = new InvalidFormatException("Can't read content types part !");
                invalidFormatException2.initCause(invalidFormatException);
                throw invalidFormatException2;
            }
        }
    }

    public void addContentType(PackagePartName packagePartName, String string) {
        boolean bl = this.defaultContentType.containsValue(string);
        String string2 = packagePartName.getExtension().toLowerCase(Locale.ROOT);
        if (string2.length() == 0 || this.defaultContentType.containsKey(string2) && !bl) {
            this.addOverrideContentType(packagePartName, string);
        } else if (!bl) {
            this.addDefaultContentType(string2, string);
        }
    }

    private void addOverrideContentType(PackagePartName packagePartName, String string) {
        if (this.overrideContentType == null) {
            this.overrideContentType = new TreeMap();
        }
        this.overrideContentType.put(packagePartName, string);
    }

    private void addDefaultContentType(String string, String string2) {
        this.defaultContentType.put(string.toLowerCase(Locale.ROOT), string2);
    }

    public void removeContentType(PackagePartName packagePartName) throws InvalidOperationException {
        if (packagePartName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (this.overrideContentType != null && this.overrideContentType.get(packagePartName) != null) {
            this.overrideContentType.remove(packagePartName);
            return;
        }
        String string = packagePartName.getExtension();
        boolean bl = true;
        if (this.container != null) {
            try {
                for (PackagePart packagePart : this.container.getParts()) {
                    if (packagePart.getPartName().equals(packagePartName) || !packagePart.getPartName().getExtension().equalsIgnoreCase(string)) continue;
                    bl = false;
                    break;
                }
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new InvalidOperationException(invalidFormatException.getMessage());
            }
        }
        if (bl) {
            this.defaultContentType.remove(string);
        }
        if (this.container != null) {
            try {
                for (PackagePart packagePart : this.container.getParts()) {
                    if (packagePart.getPartName().equals(packagePartName) || this.getContentType(packagePart.getPartName()) != null) continue;
                    throw new InvalidOperationException("Rule M2.4 is not respected: Nor a default element or override element is associated with the part: " + packagePart.getPartName().getName());
                }
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new InvalidOperationException(invalidFormatException.getMessage());
            }
        }
    }

    public boolean isContentTypeRegister(String string) {
        if (string == null) {
            throw new IllegalArgumentException("contentType");
        }
        return this.defaultContentType.values().contains(string) || this.overrideContentType != null && this.overrideContentType.values().contains(string);
    }

    public String getContentType(PackagePartName packagePartName) {
        if (packagePartName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (this.overrideContentType != null && this.overrideContentType.containsKey(packagePartName)) {
            return this.overrideContentType.get(packagePartName);
        }
        String string = packagePartName.getExtension().toLowerCase(Locale.ROOT);
        if (this.defaultContentType.containsKey(string)) {
            return this.defaultContentType.get(string);
        }
        if (this.container != null && this.container.getPart(packagePartName) != null) {
            throw new OpenXML4JRuntimeException("Rule M2.4 exception : this error should NEVER happen! Please raise a bug at https://bz.apache.org/bugzilla/enter_bug.cgi?product=POI and attach a file that triggers it, thanks!");
        }
        return null;
    }

    public void clearAll() {
        this.defaultContentType.clear();
        if (this.overrideContentType != null) {
            this.overrideContentType.clear();
        }
    }

    public void clearOverrideContentTypes() {
        if (this.overrideContentType != null) {
            this.overrideContentType.clear();
        }
    }

    private void parseContentTypesFile(InputStream inputStream) throws InvalidFormatException {
        try {
            Object object;
            Document document = DocumentHelper.readDocument(inputStream);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName(DEFAULT_TAG_NAME);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String string = element.getAttribute(EXTENSION_ATTRIBUTE_NAME);
                object = element.getAttribute(CONTENT_TYPE_ATTRIBUTE_NAME);
                this.addDefaultContentType(string, (String)object);
            }
            NodeList nodeList2 = document.getDocumentElement().getElementsByTagName(OVERRIDE_TAG_NAME);
            int n2 = nodeList2.getLength();
            for (int i = 0; i < n2; ++i) {
                object = (Element)nodeList2.item(i);
                URI uRI = new URI(object.getAttribute(PART_NAME_ATTRIBUTE_NAME));
                PackagePartName packagePartName = PackagingURIHelper.createPartName(uRI);
                String string = object.getAttribute(CONTENT_TYPE_ATTRIBUTE_NAME);
                this.addOverrideContentType(packagePartName, string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidFormatException(uRISyntaxException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new InvalidFormatException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new InvalidFormatException(iOException.getMessage());
        }
    }

    public boolean save(OutputStream outputStream) {
        Document document = DocumentHelper.createDocument();
        Element element = document.createElementNS(TYPES_NAMESPACE_URI, TYPES_TAG_NAME);
        document.appendChild(element);
        for (Map.Entry<String, String> entry : this.defaultContentType.entrySet()) {
            this.appendDefaultType(element, entry);
        }
        if (this.overrideContentType != null) {
            for (Map.Entry<Object, String> entry : this.overrideContentType.entrySet()) {
                this.appendSpecificTypes(element, entry);
            }
        }
        document.normalize();
        return this.saveImpl(document, outputStream);
    }

    private void appendSpecificTypes(Element element, Map.Entry<PackagePartName, String> entry) {
        Element element2 = element.getOwnerDocument().createElementNS(TYPES_NAMESPACE_URI, OVERRIDE_TAG_NAME);
        element2.setAttribute(PART_NAME_ATTRIBUTE_NAME, entry.getKey().getName());
        element2.setAttribute(CONTENT_TYPE_ATTRIBUTE_NAME, entry.getValue());
        element.appendChild(element2);
    }

    private void appendDefaultType(Element element, Map.Entry<String, String> entry) {
        Element element2 = element.getOwnerDocument().createElementNS(TYPES_NAMESPACE_URI, DEFAULT_TAG_NAME);
        element2.setAttribute(EXTENSION_ATTRIBUTE_NAME, entry.getKey());
        element2.setAttribute(CONTENT_TYPE_ATTRIBUTE_NAME, entry.getValue());
        element.appendChild(element2);
    }

    public abstract boolean saveImpl(Document var1, OutputStream var2);
}

