/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackageAccess;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.util.DocumentHelper;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackageRelationshipCollection
implements Iterable<PackageRelationship> {
    private static POILogger logger = POILogFactory.getLogger(PackageRelationshipCollection.class);
    private TreeMap<String, PackageRelationship> relationshipsByID = new TreeMap();
    private TreeMap<String, PackageRelationship> relationshipsByType = new TreeMap();
    private PackagePart relationshipPart;
    private PackagePart sourcePart;
    private PackagePartName partName;
    private OPCPackage container;
    private int nextRelationshipId = -1;

    PackageRelationshipCollection() {
    }

    public PackageRelationshipCollection(PackageRelationshipCollection packageRelationshipCollection, String string) {
        this();
        for (PackageRelationship packageRelationship : packageRelationshipCollection.relationshipsByID.values()) {
            if (string != null && !packageRelationship.getRelationshipType().equals(string)) continue;
            this.addRelationship(packageRelationship);
        }
    }

    public PackageRelationshipCollection(OPCPackage oPCPackage) throws InvalidFormatException {
        this(oPCPackage, null);
    }

    public PackageRelationshipCollection(PackagePart packagePart) throws InvalidFormatException {
        this(packagePart._container, packagePart);
    }

    public PackageRelationshipCollection(OPCPackage oPCPackage, PackagePart packagePart) throws InvalidFormatException {
        this();
        if (oPCPackage == null) {
            throw new IllegalArgumentException("container");
        }
        if (packagePart != null && packagePart.isRelationshipPart()) {
            throw new IllegalArgumentException("part");
        }
        this.container = oPCPackage;
        this.sourcePart = packagePart;
        this.partName = PackageRelationshipCollection.getRelationshipPartName(packagePart);
        if (oPCPackage.getPackageAccess() != PackageAccess.WRITE && oPCPackage.containPart(this.partName)) {
            this.relationshipPart = oPCPackage.getPart(this.partName);
            this.parseRelationshipsPart(this.relationshipPart);
        }
    }

    private static PackagePartName getRelationshipPartName(PackagePart packagePart) throws InvalidOperationException {
        PackagePartName packagePartName = packagePart == null ? PackagingURIHelper.PACKAGE_ROOT_PART_NAME : packagePart.getPartName();
        return PackagingURIHelper.getRelationshipPartName(packagePartName);
    }

    public void addRelationship(PackageRelationship packageRelationship) {
        this.relationshipsByID.put(packageRelationship.getId(), packageRelationship);
        this.relationshipsByType.put(packageRelationship.getRelationshipType(), packageRelationship);
    }

    public PackageRelationship addRelationship(URI uRI, TargetMode targetMode, String string, String string2) {
        if (string2 == null) {
            if (this.nextRelationshipId == -1) {
                this.nextRelationshipId = this.size() + 1;
            }
            while (this.relationshipsByID.get(string2 = "rId" + this.nextRelationshipId++) != null) {
            }
        }
        PackageRelationship packageRelationship = new PackageRelationship(this.container, this.sourcePart, uRI, targetMode, string, string2);
        this.relationshipsByID.put(packageRelationship.getId(), packageRelationship);
        this.relationshipsByType.put(packageRelationship.getRelationshipType(), packageRelationship);
        return packageRelationship;
    }

    public void removeRelationship(String string) {
        PackageRelationship packageRelationship;
        if (this.relationshipsByID != null && this.relationshipsByType != null && (packageRelationship = this.relationshipsByID.get(string)) != null) {
            this.relationshipsByID.remove(packageRelationship.getId());
            this.relationshipsByType.values().remove(packageRelationship);
        }
    }

    public void removeRelationship(PackageRelationship packageRelationship) {
        if (packageRelationship == null) {
            throw new IllegalArgumentException("rel");
        }
        this.relationshipsByID.values().remove(packageRelationship);
        this.relationshipsByType.values().remove(packageRelationship);
    }

    public PackageRelationship getRelationship(int n) {
        if (n < 0 || n > this.relationshipsByID.values().size()) {
            throw new IllegalArgumentException("index");
        }
        PackageRelationship packageRelationship = null;
        int n2 = 0;
        for (PackageRelationship packageRelationship2 : this.relationshipsByID.values()) {
            if (n != n2++) continue;
            return packageRelationship2;
        }
        return packageRelationship;
    }

    public PackageRelationship getRelationshipByID(String string) {
        return this.relationshipsByID.get(string);
    }

    public int size() {
        return this.relationshipsByID.values().size();
    }

    public void parseRelationshipsPart(PackagePart packagePart) throws InvalidFormatException {
        try {
            logger.log(1, new Object[]{"Parsing relationship: " + packagePart.getPartName()});
            Document document = DocumentHelper.readDocument(packagePart.getInputStream());
            Element element = document.getDocumentElement();
            boolean bl = false;
            NodeList nodeList = element.getElementsByTagName("Relationship");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute("Id");
                String string2 = element2.getAttribute("Type");
                if (string2.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
                    if (!bl) {
                        bl = true;
                    } else {
                        throw new InvalidFormatException("OPC Compliance error [M4.1]: there is more than one core properties relationship in the package !");
                    }
                }
                Attr attr = element2.getAttributeNode("TargetMode");
                TargetMode targetMode = TargetMode.INTERNAL;
                if (attr != null) {
                    targetMode = attr.getValue().toLowerCase(Locale.ROOT).equals("internal") ? TargetMode.INTERNAL : TargetMode.EXTERNAL;
                }
                URI uRI = PackagingURIHelper.toURI("http://invalid.uri");
                String string3 = element2.getAttribute("Target");
                try {
                    uRI = PackagingURIHelper.toURI(string3);
                }
                catch (URISyntaxException uRISyntaxException) {
                    logger.log(7, new Object[]{"Cannot convert " + string3 + " in a valid relationship URI-> dummy-URI used", uRISyntaxException});
                }
                this.addRelationship(uRI, targetMode, string2, string);
            }
        }
        catch (Exception exception) {
            logger.log(7, new Object[]{exception});
            throw new InvalidFormatException(exception.getMessage());
        }
    }

    public PackageRelationshipCollection getRelationships(String string) {
        PackageRelationshipCollection packageRelationshipCollection = new PackageRelationshipCollection(this, string);
        return packageRelationshipCollection;
    }

    @Override
    public Iterator<PackageRelationship> iterator() {
        return this.relationshipsByID.values().iterator();
    }

    public Iterator<PackageRelationship> iterator(String string) {
        ArrayList<PackageRelationship> arrayList = new ArrayList<PackageRelationship>();
        for (PackageRelationship packageRelationship : this.relationshipsByID.values()) {
            if (!packageRelationship.getRelationshipType().equals(string)) continue;
            arrayList.add(packageRelationship);
        }
        return arrayList.iterator();
    }

    public void clear() {
        this.relationshipsByID.clear();
        this.relationshipsByType.clear();
    }

    public String toString() {
        String string = this.relationshipsByID == null ? "relationshipsByID=null" : this.relationshipsByID.size() + " relationship(s) = [";
        string = this.relationshipPart != null && this.relationshipPart._partName != null ? string + "," + this.relationshipPart._partName : string + ",relationshipPart=null";
        string = this.sourcePart != null && this.sourcePart._partName != null ? string + "," + this.sourcePart._partName : string + ",sourcePart=null";
        string = this.partName != null ? string + "," + this.partName : string + ",uri=null)";
        return string + "]";
    }
}

