/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.sprm.SprmBuffer;
import ai2.org.apache.poi.hwpf.sprm.TableSprmUncompressor;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.hwpf.usermodel.Table;
import ai2.org.apache.poi.hwpf.usermodel.TableCell;
import ai2.org.apache.poi.hwpf.usermodel.TableCellDescriptor;
import ai2.org.apache.poi.hwpf.usermodel.TableProperties;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.ArrayList;

public final class TableRow
extends Range {
    private static final POILogger logger = POILogFactory.getLogger(TableRow.class);
    private static final short SPRM_DXAGAPHALF = -27134;
    private static final short SPRM_DYAROWHEIGHT = -27641;
    private static final short SPRM_FCANTSPLIT = 13315;
    private static final short SPRM_FTABLEHEADER = 13316;
    private static final short SPRM_TJC = 21504;
    private static final char TABLE_CELL_MARK = '\u0007';
    private TableCell[] _cells;
    private boolean _cellsFound = false;
    int _levelNum;
    private SprmBuffer _papx;
    private TableProperties _tprops;

    public TableRow(int n, int n2, Table table, int n3) {
        super(n, n2, table);
        Paragraph paragraph = this.getParagraph(this.numParagraphs() - 1);
        this._papx = paragraph._papx;
        this._tprops = TableSprmUncompressor.uncompressTAP(this._papx);
        this._levelNum = n3;
        this.initCells();
    }

    public boolean cantSplit() {
        return this._tprops.getFCantSplit();
    }

    public BorderCode getBarBorder() {
        throw new UnsupportedOperationException("not applicable for TableRow");
    }

    public BorderCode getBottomBorder() {
        return this._tprops.getBrcBottom();
    }

    public TableCell getCell(int n) {
        this.initCells();
        return this._cells[n];
    }

    public int getGapHalf() {
        return this._tprops.getDxaGapHalf();
    }

    public BorderCode getHorizontalBorder() {
        return this._tprops.getBrcHorizontal();
    }

    public BorderCode getLeftBorder() {
        return this._tprops.getBrcLeft();
    }

    public BorderCode getRightBorder() {
        return this._tprops.getBrcRight();
    }

    public int getRowHeight() {
        return this._tprops.getDyaRowHeight();
    }

    public int getRowJustification() {
        return this._tprops.getJc();
    }

    public BorderCode getTopBorder() {
        return this._tprops.getBrcTop();
    }

    public BorderCode getVerticalBorder() {
        return this._tprops.getBrcVertical();
    }

    private void initCells() {
        TableCell tableCell;
        Object object;
        if (this._cellsFound) {
            return;
        }
        short s = this._tprops.getItcMac();
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>(s + 1);
        for (int i = 0; i < this.numParagraphs(); ++i) {
            Paragraph paragraph = this.getParagraph(i);
            String string = paragraph.text();
            if ((string.length() <= 0 || string.charAt(string.length() - 1) != '\u0007') && !paragraph.isEmbeddedCellMark() || paragraph.getTableLevel() != this._levelNum) continue;
            object = this._tprops.getRgtc() != null && this._tprops.getRgtc().length > arrayList.size() ? this._tprops.getRgtc()[arrayList.size()] : new TableCellDescriptor();
            short s2 = this._tprops.getRgdxaCenter() != null && this._tprops.getRgdxaCenter().length > arrayList.size() ? this._tprops.getRgdxaCenter()[arrayList.size()] : (short)0;
            short s3 = this._tprops.getRgdxaCenter() != null && this._tprops.getRgdxaCenter().length > arrayList.size() + 1 ? this._tprops.getRgdxaCenter()[arrayList.size() + 1] : (short)0;
            TableCell tableCell2 = new TableCell(this.getParagraph(n).getStartOffset(), this.getParagraph(i).getEndOffset(), this, this._levelNum, (TableCellDescriptor)object, s2, s3 - s2);
            arrayList.add(tableCell2);
            n = i + 1;
        }
        if (n < this.numParagraphs() - 1) {
            TableCellDescriptor tableCellDescriptor = this._tprops.getRgtc() != null && this._tprops.getRgtc().length > arrayList.size() ? this._tprops.getRgtc()[arrayList.size()] : new TableCellDescriptor();
            short s4 = this._tprops.getRgdxaCenter() != null && this._tprops.getRgdxaCenter().length > arrayList.size() ? this._tprops.getRgdxaCenter()[arrayList.size()] : (short)0;
            short s5 = this._tprops.getRgdxaCenter() != null && this._tprops.getRgdxaCenter().length > arrayList.size() + 1 ? this._tprops.getRgdxaCenter()[arrayList.size() + 1] : (short)0;
            object = new TableCell(n, this.numParagraphs() - 1, this, this._levelNum, tableCellDescriptor, s4, s5 - s4);
            arrayList.add(object);
        }
        if (!arrayList.isEmpty() && (tableCell = (TableCell)arrayList.get(arrayList.size() - 1)).numParagraphs() == 1 && tableCell.getParagraph(0).isTableRowEnd()) {
            arrayList.remove(arrayList.size() - 1);
        }
        if (arrayList.size() != s) {
            logger.log(5, new Object[]{"Number of found table cells (" + arrayList.size() + ") for table row [" + this.getStartOffset() + "c; " + this.getEndOffset() + "c] not equals to stored property value " + s});
            this._tprops.setItcMac((short)arrayList.size());
        }
        this._cells = arrayList.toArray(new TableCell[arrayList.size()]);
        this._cellsFound = true;
    }

    public boolean isTableHeader() {
        return this._tprops.getFTableHeader();
    }

    public int numCells() {
        this.initCells();
        return this._cells.length;
    }

    protected void reset() {
        this._cellsFound = false;
    }

    public void setCantSplit(boolean bl) {
        this._tprops.setFCantSplit(bl);
        this._papx.updateSprm((short)13315, (byte)(bl ? 1 : 0));
    }

    public void setGapHalf(int n) {
        this._tprops.setDxaGapHalf(n);
        this._papx.updateSprm((short)-27134, (short)n);
    }

    public void setRowHeight(int n) {
        this._tprops.setDyaRowHeight(n);
        this._papx.updateSprm((short)-27641, (short)n);
    }

    public void setRowJustification(int n) {
        this._tprops.setJc((short)n);
        this._papx.updateSprm((short)21504, (short)n);
    }

    public void setTableHeader(boolean bl) {
        this._tprops.setFTableHeader(bl);
        this._papx.updateSprm((short)13316, (byte)(bl ? 1 : 0));
    }
}

