/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.hwpf.usermodel.Table;

public final class TableIterator {
    Range _range;
    int _index;
    int _levelNum;

    TableIterator(Range range, int n) {
        this._range = range;
        this._index = 0;
        this._levelNum = n;
    }

    public TableIterator(Range range) {
        this(range, 1);
    }

    public boolean hasNext() {
        int n = this._range.numParagraphs();
        while (this._index < n) {
            Paragraph paragraph = this._range.getParagraph(this._index);
            if (paragraph.isInTable() && paragraph.getTableLevel() == this._levelNum) {
                return true;
            }
            ++this._index;
        }
        return false;
    }

    public Table next() {
        int n = this._range.numParagraphs();
        int n2 = this._index;
        int n3 = this._index;
        while (this._index < n) {
            Paragraph paragraph = this._range.getParagraph(this._index);
            if (!paragraph.isInTable() || paragraph.getTableLevel() < this._levelNum) {
                n3 = this._index;
                break;
            }
            ++this._index;
        }
        return new Table(this._range.getParagraph(n2).getStartOffset(), this._range.getParagraph(n3 - 1).getEndOffset(), this._range, this._levelNum);
    }
}

