/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.model.types.TCAbstractType;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.util.LittleEndian;

public final class TableCellDescriptor
extends TCAbstractType
implements Cloneable {
    public static final int SIZE = 20;

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_rgf = LittleEndian.getShort(byArray, 0 + n);
        this.field_2_wWidth = LittleEndian.getShort(byArray, 2 + n);
        this.setBrcTop(new BorderCode(byArray, 4 + n));
        this.setBrcLeft(new BorderCode(byArray, 8 + n));
        this.setBrcBottom(new BorderCode(byArray, 12 + n));
        this.setBrcRight(new BorderCode(byArray, 16 + n));
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, 0 + n, this.field_1_rgf);
        LittleEndian.putShort(byArray, 2 + n, this.field_2_wWidth);
        this.getBrcTop().serialize(byArray, 4 + n);
        this.getBrcLeft().serialize(byArray, 8 + n);
        this.getBrcBottom().serialize(byArray, 12 + n);
        this.getBrcRight().serialize(byArray, 16 + n);
    }

    public Object clone() throws CloneNotSupportedException {
        TableCellDescriptor tableCellDescriptor = (TableCellDescriptor)super.clone();
        tableCellDescriptor.setShd(this.getShd().clone());
        tableCellDescriptor.setBrcTop((BorderCode)this.getBrcTop().clone());
        tableCellDescriptor.setBrcLeft((BorderCode)this.getBrcLeft().clone());
        tableCellDescriptor.setBrcBottom((BorderCode)this.getBrcBottom().clone());
        tableCellDescriptor.setBrcRight((BorderCode)this.getBrcRight().clone());
        return tableCellDescriptor;
    }

    public static TableCellDescriptor convertBytesToTC(byte[] byArray, int n) {
        TableCellDescriptor tableCellDescriptor = new TableCellDescriptor();
        tableCellDescriptor.fillFields(byArray, n);
        return tableCellDescriptor;
    }
}

