/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.HWPFOldDocument;
import ai2.org.apache.poi.hwpf.model.SEPX;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.hwpf.usermodel.SectionProperties;

public final class Section
extends Range {
    private SectionProperties _props;

    public Section(SEPX sEPX, Range range) {
        super(Math.max(range._start, sEPX.getStart()), Math.min(range._end, sEPX.getEnd()), range);
        this._props = range.getDocument() instanceof HWPFOldDocument ? new SectionProperties() : sEPX.getSectionProperties();
    }

    public Object clone() throws CloneNotSupportedException {
        Section section = (Section)super.clone();
        section._props = (SectionProperties)this._props.clone();
        return section;
    }

    public int getDistanceBetweenColumns() {
        return this._props.getDxaColumns();
    }

    public int getMarginBottom() {
        return this._props.getDyaBottom();
    }

    public int getMarginLeft() {
        return this._props.getDxaLeft();
    }

    public int getMarginRight() {
        return this._props.getDxaRight();
    }

    public int getMarginTop() {
        return this._props.getDyaTop();
    }

    public int getNumColumns() {
        return this._props.getCcolM1() + 1;
    }

    public int getPageHeight() {
        return this._props.getYaPage();
    }

    public int getPageWidth() {
        return this._props.getXaPage();
    }

    public void setMarginBottom(int n) {
        this._props.setDyaBottom(n);
    }

    public void setMarginLeft(int n) {
        this._props.setDxaLeft(n);
    }

    public void setMarginRight(int n) {
        this._props.setDxaRight(n);
    }

    public void setMarginTop(int n) {
        this._props.setDyaTop(n);
    }

    public boolean isColumnsEvenlySpaced() {
        return this._props.getFEvenlySpaced();
    }

    public String toString() {
        return "Section [" + this.getStartOffset() + "; " + this.getEndOffset() + ")";
    }

    public int type() {
        return 2;
    }
}

