/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherBSERecord;
import ai2.org.apache.poi.ddf.EscherBlipRecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherOptRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.ddf.EscherTertiaryOptRecord;
import ai2.org.apache.poi.hwpf.model.EscherRecordHolder;
import ai2.org.apache.poi.hwpf.model.FSPA;
import ai2.org.apache.poi.hwpf.model.FSPATable;
import ai2.org.apache.poi.hwpf.usermodel.OfficeDrawing;
import ai2.org.apache.poi.hwpf.usermodel.OfficeDrawings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeDrawingsImpl
implements OfficeDrawings {
    private final EscherRecordHolder _escherRecordHolder;
    private final FSPATable _fspaTable;
    private final byte[] _mainStream;

    public OfficeDrawingsImpl(FSPATable fSPATable, EscherRecordHolder escherRecordHolder, byte[] byArray) {
        this._fspaTable = fSPATable;
        this._escherRecordHolder = escherRecordHolder;
        this._mainStream = byArray;
    }

    private EscherBlipRecord getBitmapRecord(int n) {
        List<? extends EscherContainerRecord> list = this._escherRecordHolder.getBStoreContainers();
        if (list == null || list.size() != 1) {
            return null;
        }
        EscherContainerRecord escherContainerRecord = list.get(0);
        List<EscherRecord> list2 = escherContainerRecord.getChildRecords();
        if (list2.size() < n) {
            return null;
        }
        EscherRecord escherRecord = list2.get(n - 1);
        if (escherRecord instanceof EscherBlipRecord) {
            return (EscherBlipRecord)escherRecord;
        }
        if (escherRecord instanceof EscherBSERecord) {
            DefaultEscherRecordFactory defaultEscherRecordFactory;
            EscherRecord escherRecord2;
            EscherBSERecord escherBSERecord = (EscherBSERecord)escherRecord;
            EscherBlipRecord escherBlipRecord = escherBSERecord.getBlipRecord();
            if (escherBlipRecord != null) {
                return escherBlipRecord;
            }
            if (escherBSERecord.getOffset() > 0 && (escherRecord2 = (defaultEscherRecordFactory = new DefaultEscherRecordFactory()).createRecord(this._mainStream, escherBSERecord.getOffset())) instanceof EscherBlipRecord) {
                escherRecord2.fillFields(this._mainStream, escherBSERecord.getOffset(), defaultEscherRecordFactory);
                return (EscherBlipRecord)escherRecord2;
            }
        }
        return null;
    }

    private EscherContainerRecord getEscherShapeRecordContainer(int n) {
        for (EscherContainerRecord escherContainerRecord : this._escherRecordHolder.getSpContainers()) {
            EscherSpRecord escherSpRecord = (EscherSpRecord)escherContainerRecord.getChildById((short)-4086);
            if (escherSpRecord == null || escherSpRecord.getShapeId() != n) continue;
            return escherContainerRecord;
        }
        return null;
    }

    private OfficeDrawing getOfficeDrawing(final FSPA fSPA) {
        return new OfficeDrawing(){

            public OfficeDrawing.HorizontalPositioning getHorizontalPositioning() {
                int n = this.getTertiaryPropertyValue(911, -1);
                switch (n) {
                    case 0: {
                        return OfficeDrawing.HorizontalPositioning.ABSOLUTE;
                    }
                    case 1: {
                        return OfficeDrawing.HorizontalPositioning.LEFT;
                    }
                    case 2: {
                        return OfficeDrawing.HorizontalPositioning.CENTER;
                    }
                    case 3: {
                        return OfficeDrawing.HorizontalPositioning.RIGHT;
                    }
                    case 4: {
                        return OfficeDrawing.HorizontalPositioning.INSIDE;
                    }
                    case 5: {
                        return OfficeDrawing.HorizontalPositioning.OUTSIDE;
                    }
                }
                return OfficeDrawing.HorizontalPositioning.ABSOLUTE;
            }

            public OfficeDrawing.HorizontalRelativeElement getHorizontalRelative() {
                int n = this.getTertiaryPropertyValue(912, -1);
                switch (n) {
                    case 1: {
                        return OfficeDrawing.HorizontalRelativeElement.MARGIN;
                    }
                    case 2: {
                        return OfficeDrawing.HorizontalRelativeElement.PAGE;
                    }
                    case 3: {
                        return OfficeDrawing.HorizontalRelativeElement.TEXT;
                    }
                    case 4: {
                        return OfficeDrawing.HorizontalRelativeElement.CHAR;
                    }
                }
                return OfficeDrawing.HorizontalRelativeElement.TEXT;
            }

            public EscherContainerRecord getOfficeArtSpContainer() {
                return OfficeDrawingsImpl.this.getEscherShapeRecordContainer(this.getShapeId());
            }

            public byte[] getPictureData() {
                EscherContainerRecord escherContainerRecord = OfficeDrawingsImpl.this.getEscherShapeRecordContainer(this.getShapeId());
                if (escherContainerRecord == null) {
                    return null;
                }
                EscherOptRecord escherOptRecord = (EscherOptRecord)escherContainerRecord.getChildById((short)-4085);
                if (escherOptRecord == null) {
                    return null;
                }
                EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)escherOptRecord.lookup(260);
                if (escherSimpleProperty == null) {
                    return null;
                }
                int n = escherSimpleProperty.getPropertyValue();
                EscherBlipRecord escherBlipRecord = OfficeDrawingsImpl.this.getBitmapRecord(n);
                if (escherBlipRecord == null) {
                    return null;
                }
                return escherBlipRecord.getPicturedata();
            }

            public int getRectangleBottom() {
                return fSPA.getYaBottom();
            }

            public int getRectangleLeft() {
                return fSPA.getXaLeft();
            }

            public int getRectangleRight() {
                return fSPA.getXaRight();
            }

            public int getRectangleTop() {
                return fSPA.getYaTop();
            }

            public int getShapeId() {
                return fSPA.getSpid();
            }

            private int getTertiaryPropertyValue(int n, int n2) {
                EscherContainerRecord escherContainerRecord = OfficeDrawingsImpl.this.getEscherShapeRecordContainer(this.getShapeId());
                if (escherContainerRecord == null) {
                    return n2;
                }
                EscherTertiaryOptRecord escherTertiaryOptRecord = (EscherTertiaryOptRecord)escherContainerRecord.getChildById((short)-3806);
                if (escherTertiaryOptRecord == null) {
                    return n2;
                }
                EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)escherTertiaryOptRecord.lookup(n);
                if (escherSimpleProperty == null) {
                    return n2;
                }
                int n3 = escherSimpleProperty.getPropertyValue();
                return n3;
            }

            public OfficeDrawing.VerticalPositioning getVerticalPositioning() {
                int n = this.getTertiaryPropertyValue(913, -1);
                switch (n) {
                    case 0: {
                        return OfficeDrawing.VerticalPositioning.ABSOLUTE;
                    }
                    case 1: {
                        return OfficeDrawing.VerticalPositioning.TOP;
                    }
                    case 2: {
                        return OfficeDrawing.VerticalPositioning.CENTER;
                    }
                    case 3: {
                        return OfficeDrawing.VerticalPositioning.BOTTOM;
                    }
                    case 4: {
                        return OfficeDrawing.VerticalPositioning.INSIDE;
                    }
                    case 5: {
                        return OfficeDrawing.VerticalPositioning.OUTSIDE;
                    }
                }
                return OfficeDrawing.VerticalPositioning.ABSOLUTE;
            }

            public OfficeDrawing.VerticalRelativeElement getVerticalRelativeElement() {
                int n = this.getTertiaryPropertyValue(913, -1);
                switch (n) {
                    case 1: {
                        return OfficeDrawing.VerticalRelativeElement.MARGIN;
                    }
                    case 2: {
                        return OfficeDrawing.VerticalRelativeElement.PAGE;
                    }
                    case 3: {
                        return OfficeDrawing.VerticalRelativeElement.TEXT;
                    }
                    case 4: {
                        return OfficeDrawing.VerticalRelativeElement.LINE;
                    }
                }
                return OfficeDrawing.VerticalRelativeElement.TEXT;
            }

            public String toString() {
                return "OfficeDrawingImpl: " + fSPA.toString();
            }
        };
    }

    @Override
    public OfficeDrawing getOfficeDrawingAt(int n) {
        FSPA fSPA = this._fspaTable.getFspaFromCp(n);
        if (fSPA == null) {
            return null;
        }
        return this.getOfficeDrawing(fSPA);
    }

    @Override
    public Collection<OfficeDrawing> getOfficeDrawings() {
        ArrayList<OfficeDrawing> arrayList = new ArrayList<OfficeDrawing>();
        for (FSPA fSPA : this._fspaTable.getShapes()) {
            arrayList.add(this.getOfficeDrawing(fSPA));
        }
        return Collections.unmodifiableList(arrayList);
    }
}

