/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.util.LittleEndian;

public final class LineSpacingDescriptor
implements Cloneable {
    short _dyaLine;
    short _fMultiLinespace;

    public LineSpacingDescriptor() {
        this._dyaLine = (short)240;
        this._fMultiLinespace = 1;
    }

    public LineSpacingDescriptor(byte[] byArray, int n) {
        this._dyaLine = LittleEndian.getShort(byArray, n);
        this._fMultiLinespace = LittleEndian.getShort(byArray, n + 2);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setMultiLinespace(short s) {
        this._fMultiLinespace = s;
    }

    public int toInt() {
        byte[] byArray = new byte[4];
        this.serialize(byArray, 0);
        return LittleEndian.getInt(byArray);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, n, this._dyaLine);
        LittleEndian.putShort(byArray, n + 2, this._fMultiLinespace);
    }

    public void setDyaLine(short s) {
        this._dyaLine = s;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineSpacingDescriptor)) {
            return false;
        }
        LineSpacingDescriptor lineSpacingDescriptor = (LineSpacingDescriptor)object;
        return this._dyaLine == lineSpacingDescriptor._dyaLine && this._fMultiLinespace == lineSpacingDescriptor._fMultiLinespace;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public boolean isEmpty() {
        return this._dyaLine == 0 && this._fMultiLinespace == 0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[LSPD] EMPTY";
        }
        return "[LSPD] (dyaLine: " + this._dyaLine + "; fMultLinespace: " + this._fMultiLinespace + ")";
    }
}

