/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.model.FileInformationBlock;
import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.PlexOfCps;
import ai2.org.apache.poi.hwpf.model.SubdocumentType;
import ai2.org.apache.poi.hwpf.usermodel.Range;

public final class HeaderStories {
    private Range headerStories;
    private PlexOfCps plcfHdd;
    private boolean stripFields = false;

    public HeaderStories(HWPFDocument hWPFDocument) {
        this.headerStories = hWPFDocument.getHeaderStoryRange();
        FileInformationBlock fileInformationBlock = hWPFDocument.getFileInformationBlock();
        if (fileInformationBlock.getSubdocumentTextStreamLength(SubdocumentType.HEADER) == 0) {
            return;
        }
        if (fileInformationBlock.getPlcfHddSize() == 0) {
            return;
        }
        this.plcfHdd = new PlexOfCps(hWPFDocument.getTableStream(), fileInformationBlock.getPlcfHddOffset(), fileInformationBlock.getPlcfHddSize(), 0);
    }

    @Deprecated
    public String getFootnoteSeparator() {
        return this.getAt(0);
    }

    @Deprecated
    public String getFootnoteContSeparator() {
        return this.getAt(1);
    }

    @Deprecated
    public String getFootnoteContNote() {
        return this.getAt(2);
    }

    @Deprecated
    public String getEndnoteSeparator() {
        return this.getAt(3);
    }

    @Deprecated
    public String getEndnoteContSeparator() {
        return this.getAt(4);
    }

    @Deprecated
    public String getEndnoteContNote() {
        return this.getAt(5);
    }

    public Range getFootnoteSeparatorSubrange() {
        return this.getSubrangeAt(0);
    }

    public Range getFootnoteContSeparatorSubrange() {
        return this.getSubrangeAt(1);
    }

    public Range getFootnoteContNoteSubrange() {
        return this.getSubrangeAt(2);
    }

    public Range getEndnoteSeparatorSubrange() {
        return this.getSubrangeAt(3);
    }

    public Range getEndnoteContSeparatorSubrange() {
        return this.getSubrangeAt(4);
    }

    public Range getEndnoteContNoteSubrange() {
        return this.getSubrangeAt(5);
    }

    @Deprecated
    public String getEvenHeader() {
        return this.getAt(6);
    }

    @Deprecated
    public String getOddHeader() {
        return this.getAt(7);
    }

    @Deprecated
    public String getFirstHeader() {
        return this.getAt(10);
    }

    public Range getEvenHeaderSubrange() {
        return this.getSubrangeAt(6);
    }

    public Range getOddHeaderSubrange() {
        return this.getSubrangeAt(7);
    }

    public Range getFirstHeaderSubrange() {
        return this.getSubrangeAt(10);
    }

    public String getHeader(int n) {
        if (n == 1 && this.getFirstHeader().length() > 0) {
            return this.getFirstHeader();
        }
        if (n % 2 == 0 && this.getEvenHeader().length() > 0) {
            return this.getEvenHeader();
        }
        return this.getOddHeader();
    }

    @Deprecated
    public String getEvenFooter() {
        return this.getAt(8);
    }

    @Deprecated
    public String getOddFooter() {
        return this.getAt(9);
    }

    @Deprecated
    public String getFirstFooter() {
        return this.getAt(11);
    }

    public Range getEvenFooterSubrange() {
        return this.getSubrangeAt(8);
    }

    public Range getOddFooterSubrange() {
        return this.getSubrangeAt(9);
    }

    public Range getFirstFooterSubrange() {
        return this.getSubrangeAt(11);
    }

    public String getFooter(int n) {
        if (n == 1 && this.getFirstFooter().length() > 0) {
            return this.getFirstFooter();
        }
        if (n % 2 == 0 && this.getEvenFooter().length() > 0) {
            return this.getEvenFooter();
        }
        return this.getOddFooter();
    }

    @Deprecated
    private String getAt(int n) {
        if (this.plcfHdd == null) {
            return null;
        }
        GenericPropertyNode genericPropertyNode = this.plcfHdd.getProperty(n);
        if (genericPropertyNode.getStart() == genericPropertyNode.getEnd()) {
            return "";
        }
        if (genericPropertyNode.getEnd() < genericPropertyNode.getStart()) {
            return "";
        }
        String string = this.headerStories.text();
        int n2 = Math.min(genericPropertyNode.getStart(), string.length());
        int n3 = Math.min(genericPropertyNode.getEnd(), string.length());
        String string2 = string.substring(n2, n3);
        if (this.stripFields) {
            return Range.stripFields(string2);
        }
        if (string2.equals("\r\r")) {
            return "";
        }
        return string2;
    }

    private Range getSubrangeAt(int n) {
        if (this.plcfHdd == null) {
            return null;
        }
        GenericPropertyNode genericPropertyNode = this.plcfHdd.getProperty(n);
        if (genericPropertyNode.getStart() == genericPropertyNode.getEnd()) {
            return null;
        }
        if (genericPropertyNode.getEnd() < genericPropertyNode.getStart()) {
            return null;
        }
        int n2 = this.headerStories.getEndOffset() - this.headerStories.getStartOffset();
        int n3 = Math.min(genericPropertyNode.getStart(), n2);
        int n4 = Math.min(genericPropertyNode.getEnd(), n2);
        return new Range(this.headerStories.getStartOffset() + n3, this.headerStories.getStartOffset() + n4, this.headerStories);
    }

    public Range getRange() {
        return this.headerStories;
    }

    protected PlexOfCps getPlcfHdd() {
        return this.plcfHdd;
    }

    public boolean areFieldsStripped() {
        return this.stripFields;
    }

    public void setAreFieldsStripped(boolean bl) {
        this.stripFields = bl;
    }
}

