/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.model.LFO;
import ai2.org.apache.poi.hwpf.model.LFOData;
import ai2.org.apache.poi.hwpf.model.ListData;
import ai2.org.apache.poi.hwpf.model.ListFormatOverrideLevel;
import ai2.org.apache.poi.hwpf.model.ListLevel;
import ai2.org.apache.poi.hwpf.model.ListTables;
import ai2.org.apache.poi.hwpf.model.StyleSheet;
import ai2.org.apache.poi.hwpf.sprm.CharacterSprmCompressor;
import ai2.org.apache.poi.hwpf.sprm.ParagraphSprmCompressor;
import ai2.org.apache.poi.hwpf.usermodel.CharacterProperties;
import ai2.org.apache.poi.hwpf.usermodel.ParagraphProperties;
import ai2.org.apache.poi.util.Internal;

public final class HWPFList {
    private boolean _ignoreLogicalLeftIdentation = false;
    private LFO _lfo;
    private LFOData _lfoData;
    private ListData _listData;
    private ListTables _listTables;
    private boolean _registered;
    private StyleSheet _styleSheet;

    public HWPFList(boolean bl, StyleSheet styleSheet) {
        this._listData = new ListData((int)(Math.random() * (double)System.currentTimeMillis()), bl);
        this._lfo = new LFO();
        this._lfo.setLsid(this._listData.getLsid());
        this._lfoData = new LFOData();
        this._styleSheet = styleSheet;
    }

    public HWPFList(StyleSheet styleSheet, ListTables listTables, int n) {
        this._listTables = listTables;
        this._styleSheet = styleSheet;
        this._registered = true;
        if (n == 0 || n == 63489) {
            throw new IllegalArgumentException("Paragraph not in list");
        }
        if (1 <= n && n <= 2046) {
            this._lfo = listTables.getLfo(n);
            this._lfoData = listTables.getLfoData(n);
        } else if (63490 <= n && n <= 65535) {
            int n2 = n ^ 0xFFFF;
            this._lfo = listTables.getLfo(n2);
            this._lfoData = listTables.getLfoData(n2);
            this._ignoreLogicalLeftIdentation = true;
        } else {
            throw new IllegalArgumentException("Incorrect ilfo: " + n);
        }
        this._listData = listTables.getListData(this._lfo.getLsid());
    }

    @Internal
    public LFO getLFO() {
        return this._lfo;
    }

    @Internal
    public LFOData getLFOData() {
        return this._lfoData;
    }

    @Internal
    public ListData getListData() {
        return this._listData;
    }

    public int getLsid() {
        return this._lfo.getLsid();
    }

    @Internal
    ListLevel getLVL(char c) {
        if (c >= this._listData.numLevels()) {
            throw new IllegalArgumentException("Required level " + c + " is more than number of level for list (" + this._listData.numLevels() + ")");
        }
        ListLevel listLevel = this._listData.getLevels()[c];
        return listLevel;
    }

    public int getNumberFormat(char c) {
        return this.getLVL(c).getNumberFormat();
    }

    public String getNumberText(char c) {
        return this.getLVL(c).getNumberText();
    }

    public int getStartAt(char c) {
        if (this.isStartAtOverriden(c)) {
            return this._lfoData.getRgLfoLvl()[c].getIStartAt();
        }
        return this.getLVL(c).getStartAt();
    }

    public byte getTypeOfCharFollowingTheNumber(char c) {
        return this.getLVL(c).getTypeOfCharFollowingTheNumber();
    }

    public boolean isIgnoreLogicalLeftIdentation() {
        return this._ignoreLogicalLeftIdentation;
    }

    public boolean isStartAtOverriden(char c) {
        ListFormatOverrideLevel listFormatOverrideLevel = this._lfoData.getRgLfoLvl().length > c ? this._lfoData.getRgLfoLvl()[c] : null;
        return listFormatOverrideLevel != null && listFormatOverrideLevel.getIStartAt() != 0 && !listFormatOverrideLevel.isFormatting();
    }

    public void setIgnoreLogicalLeftIdentation(boolean bl) {
        this._ignoreLogicalLeftIdentation = bl;
    }

    public void setLevelNumberProperties(int n, CharacterProperties characterProperties) {
        ListLevel listLevel = this._listData.getLevel(n);
        int n2 = this._listData.getLevelStyle(n);
        CharacterProperties characterProperties2 = this._styleSheet.getCharacterStyle(n2);
        byte[] byArray = CharacterSprmCompressor.compressCharacterProperty(characterProperties, characterProperties2);
        listLevel.setNumberProperties(byArray);
    }

    public void setLevelParagraphProperties(int n, ParagraphProperties paragraphProperties) {
        ListLevel listLevel = this._listData.getLevel(n);
        int n2 = this._listData.getLevelStyle(n);
        ParagraphProperties paragraphProperties2 = this._styleSheet.getParagraphStyle(n2);
        byte[] byArray = ParagraphSprmCompressor.compressParagraphProperty(paragraphProperties, paragraphProperties2);
        listLevel.setLevelProperties(byArray);
    }

    public void setLevelStyle(int n, int n2) {
        this._listData.setLevelStyle(n, n2);
    }
}

