/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.model.FieldsDocumentPart;
import ai2.org.apache.poi.hwpf.model.FieldsTables;
import ai2.org.apache.poi.hwpf.model.PlexOfField;
import ai2.org.apache.poi.hwpf.usermodel.Field;
import ai2.org.apache.poi.hwpf.usermodel.FieldImpl;
import ai2.org.apache.poi.hwpf.usermodel.Fields;
import ai2.org.apache.poi.util.Internal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class FieldsImpl
implements Fields {
    private Map<FieldsDocumentPart, Map<Integer, FieldImpl>> _fieldsByOffset;
    private PlexOfFieldComparator comparator = new PlexOfFieldComparator();

    private static <T> int binarySearch(List<PlexOfField> list, int n, int n2, int n3) {
        int n4;
        FieldsImpl.checkIndexForBinarySearch(list.size(), n, n2);
        int n5 = n;
        int n6 = -1;
        int n7 = n2 - 1;
        int n8 = 0;
        while (n5 <= n7) {
            n6 = n5 + n7 >>> 1;
            n4 = list.get(n6).getFcStart();
            if (n4 == n3) {
                return n6;
            }
            if (n4 < n3) {
                n5 = n6 + 1;
                continue;
            }
            n7 = n6 - 1;
        }
        if (n6 < 0) {
            n4 = n2;
            for (int i = n; i < n2; ++i) {
                if (n3 >= list.get(i).getFcStart()) continue;
                n4 = i;
            }
            return -n4 - 1;
        }
        return -n6 - (n8 >= 0 ? 1 : 2);
    }

    private static void checkIndexForBinarySearch(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        if (n < n3 || 0 > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public FieldsImpl(FieldsTables fieldsTables) {
        this._fieldsByOffset = new HashMap<FieldsDocumentPart, Map<Integer, FieldImpl>>(FieldsDocumentPart.values().length);
        for (FieldsDocumentPart fieldsDocumentPart : FieldsDocumentPart.values()) {
            ArrayList<PlexOfField> arrayList = fieldsTables.getFieldsPLCF(fieldsDocumentPart);
            this._fieldsByOffset.put(fieldsDocumentPart, this.parseFieldStructure(arrayList));
        }
    }

    @Override
    public Collection<Field> getFields(FieldsDocumentPart fieldsDocumentPart) {
        Map<Integer, FieldImpl> map = this._fieldsByOffset.get((Object)fieldsDocumentPart);
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(map.values());
    }

    @Override
    public FieldImpl getFieldByStartOffset(FieldsDocumentPart fieldsDocumentPart, int n) {
        Map<Integer, FieldImpl> map = this._fieldsByOffset.get((Object)fieldsDocumentPart);
        if (map == null || map.isEmpty()) {
            return null;
        }
        return map.get(n);
    }

    private Map<Integer, FieldImpl> parseFieldStructure(List<PlexOfField> list) {
        if (list == null || list.isEmpty()) {
            return new HashMap<Integer, FieldImpl>();
        }
        Collections.sort(list, this.comparator);
        ArrayList<FieldImpl> arrayList = new ArrayList<FieldImpl>(list.size() / 3 + 1);
        this.parseFieldStructureImpl(list, 0, list.size(), arrayList);
        HashMap<Integer, FieldImpl> hashMap = new HashMap<Integer, FieldImpl>(arrayList.size());
        for (FieldImpl fieldImpl : arrayList) {
            hashMap.put(fieldImpl.getFieldStartOffset(), fieldImpl);
        }
        return hashMap;
    }

    private void parseFieldStructureImpl(List<PlexOfField> list, int n, int n2, List<FieldImpl> list2) {
        int n3 = n;
        block4: while (n3 < n2) {
            PlexOfField plexOfField = list.get(n3);
            if (plexOfField.getFld().getBoundaryType() != 19) {
                ++n3;
                continue;
            }
            int n4 = FieldsImpl.binarySearch(list, n3 + 1, n2, plexOfField.getFcEnd());
            if (n4 < 0) {
                ++n3;
                continue;
            }
            PlexOfField plexOfField2 = list.get(n4);
            switch (plexOfField2.getFld().getBoundaryType()) {
                case 20: {
                    Object object = plexOfField2;
                    int n5 = FieldsImpl.binarySearch(list, n4, n2, ((PlexOfField)object).getFcEnd());
                    if (n5 < 0) {
                        ++n3;
                        continue block4;
                    }
                    PlexOfField plexOfField3 = list.get(n5);
                    if (plexOfField3.getFld().getBoundaryType() != 21) {
                        ++n3;
                        continue block4;
                    }
                    FieldImpl fieldImpl = new FieldImpl(plexOfField, (PlexOfField)object, plexOfField3);
                    list2.add(fieldImpl);
                    if (plexOfField.getFcStart() + 1 < ((PlexOfField)object).getFcStart() - 1) {
                        this.parseFieldStructureImpl(list, n3 + 1, n4, list2);
                    }
                    if (((PlexOfField)object).getFcStart() + 1 < plexOfField3.getFcStart() - 1) {
                        this.parseFieldStructureImpl(list, n4 + 1, n5, list2);
                    }
                    n3 = n5 + 1;
                    continue block4;
                }
                case 21: {
                    Object object = new FieldImpl(plexOfField, null, plexOfField2);
                    list2.add((FieldImpl)object);
                    if (plexOfField.getFcStart() + 1 < plexOfField2.getFcStart() - 1) {
                        this.parseFieldStructureImpl(list, n3 + 1, n4, list2);
                    }
                    n3 = n4 + 1;
                    continue block4;
                }
            }
            ++n3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PlexOfFieldComparator
    implements Comparator<PlexOfField> {
        private PlexOfFieldComparator() {
        }

        @Override
        public int compare(PlexOfField plexOfField, PlexOfField plexOfField2) {
            int n;
            int n2 = plexOfField.getFcStart();
            return n2 < (n = plexOfField2.getFcStart()) ? -1 : (n2 == n ? 0 : 1);
        }
    }
}

