/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndian;

public final class DropCapSpecifier
implements Cloneable {
    private short _fdct;
    private static BitField _lines = BitFieldFactory.getInstance(248);
    private static BitField _type = BitFieldFactory.getInstance(7);

    public DropCapSpecifier() {
        this._fdct = 0;
    }

    public DropCapSpecifier(byte[] byArray, int n) {
        this(LittleEndian.getShort(byArray, n));
    }

    public DropCapSpecifier(short s) {
        this._fdct = s;
    }

    public DropCapSpecifier clone() {
        return new DropCapSpecifier(this._fdct);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DropCapSpecifier dropCapSpecifier = (DropCapSpecifier)object;
        return this._fdct == dropCapSpecifier._fdct;
    }

    public byte getCountOfLinesToDrop() {
        return (byte)_lines.getValue(this._fdct);
    }

    public byte getDropCapType() {
        return (byte)_type.getValue(this._fdct);
    }

    public int hashCode() {
        return this._fdct;
    }

    public boolean isEmpty() {
        return this._fdct == 0;
    }

    public void setCountOfLinesToDrop(byte by) {
        this._fdct = (short)_lines.setValue(this._fdct, by);
    }

    public void setDropCapType(byte by) {
        this._fdct = (short)_type.setValue(this._fdct, by);
    }

    public short toShort() {
        return this._fdct;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[DCS] EMPTY";
        }
        return "[DCS] (type: " + this.getDropCapType() + "; count: " + this.getCountOfLinesToDrop() + ")";
    }
}

