/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LocaleUtil;
import java.util.Calendar;

public final class DateAndTime
implements Cloneable {
    public static final int SIZE = 4;
    private short _info;
    private static final BitField _minutes = BitFieldFactory.getInstance(63);
    private static final BitField _hours = BitFieldFactory.getInstance(1984);
    private static final BitField _dom = BitFieldFactory.getInstance(63488);
    private short _info2;
    private static final BitField _months = BitFieldFactory.getInstance(15);
    private static final BitField _years = BitFieldFactory.getInstance(8176);

    public DateAndTime() {
    }

    public DateAndTime(byte[] byArray, int n) {
        this._info = LittleEndian.getShort(byArray, n);
        this._info2 = LittleEndian.getShort(byArray, n + 2);
    }

    public Calendar getDate() {
        Calendar calendar = LocaleUtil.getLocaleCalendar(_years.getValue(this._info2) + 1900, _months.getValue(this._info2) - 1, _dom.getValue(this._info), _hours.getValue(this._info), _minutes.getValue(this._info), 0);
        return calendar;
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, n, this._info);
        LittleEndian.putShort(byArray, n + 2, this._info2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateAndTime)) {
            return false;
        }
        DateAndTime dateAndTime = (DateAndTime)object;
        return this._info == dateAndTime._info && this._info2 == dateAndTime._info2;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEmpty() {
        return this._info == 0 && this._info2 == 0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[DTTM] EMPTY";
        }
        return "[DTTM] " + this.getDate();
    }
}

