/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.model.BookmarksTables;
import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.PropertyNode;
import ai2.org.apache.poi.hwpf.usermodel.Bookmark;
import ai2.org.apache.poi.hwpf.usermodel.Bookmarks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksImpl
implements Bookmarks {
    private final BookmarksTables bookmarksTables;
    private Map<Integer, List<GenericPropertyNode>> sortedDescriptors = null;
    private int[] sortedStartPositions = null;

    public BookmarksImpl(BookmarksTables bookmarksTables) {
        this.bookmarksTables = bookmarksTables;
        this.reset();
    }

    void afterDelete(int n, int n2) {
        this.bookmarksTables.afterDelete(n, n2);
        this.reset();
    }

    void afterInsert(int n, int n2) {
        this.bookmarksTables.afterInsert(n, n2);
        this.reset();
    }

    private Bookmark getBookmark(GenericPropertyNode genericPropertyNode) {
        return new BookmarkImpl(genericPropertyNode);
    }

    @Override
    public Bookmark getBookmark(int n) {
        GenericPropertyNode genericPropertyNode = this.bookmarksTables.getDescriptorFirst(n);
        return this.getBookmark(genericPropertyNode);
    }

    public List<Bookmark> getBookmarksAt(int n) {
        this.updateSortedDescriptors();
        List<GenericPropertyNode> list = this.sortedDescriptors.get(n);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>(list.size());
        for (GenericPropertyNode genericPropertyNode : list) {
            arrayList.add(this.getBookmark(genericPropertyNode));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public int getBookmarksCount() {
        return this.bookmarksTables.getDescriptorsFirstCount();
    }

    @Override
    public Map<Integer, List<Bookmark>> getBookmarksStartedBetween(int n, int n2) {
        int n3;
        this.updateSortedDescriptors();
        int n4 = Arrays.binarySearch(this.sortedStartPositions, n);
        if (n4 < 0) {
            n4 = -(n4 + 1);
        }
        if ((n3 = Arrays.binarySearch(this.sortedStartPositions, n2)) < 0) {
            n3 = -(n3 + 1);
        }
        LinkedHashMap<Integer, List<Bookmark>> linkedHashMap = new LinkedHashMap<Integer, List<Bookmark>>();
        for (int i = n4; i < n3; ++i) {
            int n5 = this.sortedStartPositions[i];
            if (n5 < n) continue;
            if (n5 >= n2) break;
            List<Bookmark> list = this.getBookmarksAt(n5);
            if (list == null) continue;
            linkedHashMap.put(n5, list);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public void remove(int n) {
        this.bookmarksTables.remove(n);
    }

    private void reset() {
        this.sortedDescriptors = null;
        this.sortedStartPositions = null;
    }

    /*
     * WARNING - void declaration
     */
    private void updateSortedDescriptors() {
        Object object;
        int n;
        if (this.sortedDescriptors != null) {
            return;
        }
        HashMap<Integer, List<GenericPropertyNode>> hashMap = new HashMap<Integer, List<GenericPropertyNode>>();
        for (n = 0; n < this.bookmarksTables.getDescriptorsFirstCount(); ++n) {
            void list;
            object = this.bookmarksTables.getDescriptorFirst(n);
            Integer n2 = ((PropertyNode)object).getStart();
            List list2 = (List)hashMap.get(n2);
            if (list2 == null) {
                LinkedList linkedList = new LinkedList();
                hashMap.put(n2, linkedList);
            }
            list.add(object);
        }
        n = 0;
        object = new int[hashMap.size()];
        for (Map.Entry entry : hashMap.entrySet()) {
            object[n++] = (Integer)entry.getKey();
            ArrayList arrayList = new ArrayList((Collection)entry.getValue());
            Collections.sort(arrayList, PropertyNode.EndComparator.instance);
            entry.setValue(arrayList);
        }
        Arrays.sort((int[])object);
        this.sortedDescriptors = hashMap;
        this.sortedStartPositions = (int[])object;
    }

    private final class BookmarkImpl
    implements Bookmark {
        private final GenericPropertyNode first;

        private BookmarkImpl(GenericPropertyNode genericPropertyNode) {
            this.first = genericPropertyNode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            BookmarkImpl bookmarkImpl = (BookmarkImpl)object;
            return !(this.first == null ? bookmarkImpl.first != null : !this.first.equals(bookmarkImpl.first));
        }

        public int getEnd() {
            int n = BookmarksImpl.this.bookmarksTables.getDescriptorFirstIndex(this.first);
            try {
                GenericPropertyNode genericPropertyNode = BookmarksImpl.this.bookmarksTables.getDescriptorLim(n);
                return genericPropertyNode.getStart();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return this.first.getEnd();
            }
        }

        public String getName() {
            int n = BookmarksImpl.this.bookmarksTables.getDescriptorFirstIndex(this.first);
            try {
                return BookmarksImpl.this.bookmarksTables.getName(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return "";
            }
        }

        public int getStart() {
            return this.first.getStart();
        }

        public int hashCode() {
            return 31 + (this.first == null ? 0 : this.first.hashCode());
        }

        public void setName(String string) {
            int n = BookmarksImpl.this.bookmarksTables.getDescriptorFirstIndex(this.first);
            BookmarksImpl.this.bookmarksTables.setName(n, string);
        }

        public String toString() {
            return "Bookmark [" + this.getStart() + "; " + this.getEnd() + "): name: " + this.getName();
        }
    }
}

