/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.sprm;

import ai2.org.apache.poi.hwpf.sprm.SprmUtils;
import ai2.org.apache.poi.hwpf.usermodel.TableCellDescriptor;
import ai2.org.apache.poi.hwpf.usermodel.TableProperties;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Arrays;

@Internal
public final class TableSprmCompressor {
    public static byte[] compressTableProperty(TableProperties tableProperties) {
        int n = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        if (tableProperties.getJc() != 0) {
            n += SprmUtils.addSprm((short)21504, tableProperties.getJc(), null, arrayList);
        }
        if (tableProperties.getFCantSplit()) {
            n += SprmUtils.addSprm((short)13315, 1, null, arrayList);
        }
        if (tableProperties.getFTableHeader()) {
            n += SprmUtils.addSprm((short)13316, 1, null, arrayList);
        }
        byte[] byArray = new byte[24];
        int n2 = 0;
        tableProperties.getBrcTop().serialize(byArray, n2);
        tableProperties.getBrcLeft().serialize(byArray, n2 += 4);
        tableProperties.getBrcBottom().serialize(byArray, n2 += 4);
        tableProperties.getBrcRight().serialize(byArray, n2 += 4);
        tableProperties.getBrcHorizontal().serialize(byArray, n2 += 4);
        tableProperties.getBrcVertical().serialize(byArray, n2 += 4);
        byte[] byArray2 = new byte[24];
        if (!Arrays.equals(byArray, byArray2)) {
            n += SprmUtils.addSprm((short)-10747, 0, byArray, arrayList);
        }
        if (tableProperties.getDyaRowHeight() != 0) {
            n += SprmUtils.addSprm((short)-27641, tableProperties.getDyaRowHeight(), null, arrayList);
        }
        if (tableProperties.getItcMac() > 0) {
            short s = tableProperties.getItcMac();
            byte[] byArray3 = new byte[1 + 2 * (s + 1) + 20 * s];
            byArray3[0] = (byte)s;
            short[] sArray = tableProperties.getRgdxaCenter();
            for (int i = 0; i < sArray.length; ++i) {
                LittleEndian.putShort(byArray3, 1 + i * 2, sArray[i]);
            }
            TableCellDescriptor[] tableCellDescriptorArray = tableProperties.getRgtc();
            for (int i = 0; i < tableCellDescriptorArray.length; ++i) {
                tableCellDescriptorArray[i].serialize(byArray3, 1 + (s + 1) * 2 + i * 20);
            }
            n += SprmUtils.addSpecialSprm((short)-10744, byArray3, arrayList);
        }
        if (tableProperties.getTlp() != null && !tableProperties.getTlp().isEmpty()) {
            byte[] byArray4 = new byte[4];
            tableProperties.getTlp().serialize(byArray4, 0);
            n += SprmUtils.addSprm((short)29706, 0, byArray4, arrayList);
        }
        return SprmUtils.getGrpprl(arrayList, n);
    }
}

