/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.sprm;

import ai2.org.apache.poi.hwpf.model.TabDescriptor;
import ai2.org.apache.poi.hwpf.sprm.SprmIterator;
import ai2.org.apache.poi.hwpf.sprm.SprmOperation;
import ai2.org.apache.poi.hwpf.sprm.SprmUncompressor;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.hwpf.usermodel.DateAndTime;
import ai2.org.apache.poi.hwpf.usermodel.DropCapSpecifier;
import ai2.org.apache.poi.hwpf.usermodel.LineSpacingDescriptor;
import ai2.org.apache.poi.hwpf.usermodel.ParagraphProperties;
import ai2.org.apache.poi.hwpf.usermodel.ShadingDescriptor;
import ai2.org.apache.poi.hwpf.usermodel.ShadingDescriptor80;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

@Internal
public final class ParagraphSprmUncompressor
extends SprmUncompressor {
    private static final POILogger logger = POILogFactory.getLogger(ParagraphSprmUncompressor.class);

    public static ParagraphProperties uncompressPAP(ParagraphProperties paragraphProperties, byte[] byArray, int n) {
        ParagraphProperties paragraphProperties2 = null;
        try {
            paragraphProperties2 = (ParagraphProperties)paragraphProperties.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("There is no way this exception should happen!!");
        }
        SprmIterator sprmIterator = new SprmIterator(byArray, n);
        while (sprmIterator.hasNext()) {
            SprmOperation sprmOperation = sprmIterator.next();
            if (sprmOperation.getType() != 1) continue;
            try {
                ParagraphSprmUncompressor.unCompressPAPOperation(paragraphProperties2, sprmOperation);
            }
            catch (Exception exception) {
                logger.log(7, new Object[]{"Unable to apply SPRM operation '" + sprmOperation.getOperation() + "': ", exception});
            }
        }
        return paragraphProperties2;
    }

    static void unCompressPAPOperation(ParagraphProperties paragraphProperties, SprmOperation sprmOperation) {
        switch (sprmOperation.getOperation()) {
            case 0: {
                paragraphProperties.setIstd(sprmOperation.getOperand());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (paragraphProperties.getIstd() > 9 && paragraphProperties.getIstd() < 1) break;
                byte by = (byte)sprmOperation.getOperand();
                paragraphProperties.setIstd(paragraphProperties.getIstd() + by);
                paragraphProperties.setLvl((byte)(paragraphProperties.getLvl() + by));
                if ((by >> 7 & 1) == 1) {
                    paragraphProperties.setIstd(Math.max(paragraphProperties.getIstd(), 1));
                    break;
                }
                paragraphProperties.setIstd(Math.min(paragraphProperties.getIstd(), 9));
                break;
            }
            case 3: {
                paragraphProperties.setJc((byte)sprmOperation.getOperand());
                break;
            }
            case 4: {
                paragraphProperties.setFSideBySide(sprmOperation.getOperand() != 0);
                break;
            }
            case 5: {
                paragraphProperties.setFKeep(sprmOperation.getOperand() != 0);
                break;
            }
            case 6: {
                paragraphProperties.setFKeepFollow(sprmOperation.getOperand() != 0);
                break;
            }
            case 7: {
                paragraphProperties.setFPageBreakBefore(sprmOperation.getOperand() != 0);
                break;
            }
            case 8: {
                paragraphProperties.setBrcl((byte)sprmOperation.getOperand());
                break;
            }
            case 9: {
                paragraphProperties.setBrcp((byte)sprmOperation.getOperand());
                break;
            }
            case 10: {
                paragraphProperties.setIlvl((byte)sprmOperation.getOperand());
                break;
            }
            case 11: {
                paragraphProperties.setIlfo(sprmOperation.getOperandShortSigned());
                break;
            }
            case 12: {
                paragraphProperties.setFNoLnn(sprmOperation.getOperand() != 0);
                break;
            }
            case 13: {
                ParagraphSprmUncompressor.handleTabs(paragraphProperties, sprmOperation);
                break;
            }
            case 14: {
                paragraphProperties.setDxaRight(sprmOperation.getOperand());
                break;
            }
            case 15: {
                paragraphProperties.setDxaLeft(sprmOperation.getOperand());
                break;
            }
            case 16: {
                paragraphProperties.setDxaLeft(paragraphProperties.getDxaLeft() + sprmOperation.getOperand());
                paragraphProperties.setDxaLeft(Math.max(0, paragraphProperties.getDxaLeft()));
                break;
            }
            case 17: {
                paragraphProperties.setDxaLeft1(sprmOperation.getOperand());
                break;
            }
            case 18: {
                paragraphProperties.setLspd(new LineSpacingDescriptor(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 19: {
                paragraphProperties.setDyaBefore(sprmOperation.getOperand());
                break;
            }
            case 20: {
                paragraphProperties.setDyaAfter(sprmOperation.getOperand());
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                paragraphProperties.setFInTable(sprmOperation.getOperand() != 0);
                break;
            }
            case 23: {
                paragraphProperties.setFTtp(sprmOperation.getOperand() != 0);
                break;
            }
            case 24: {
                paragraphProperties.setDxaAbs(sprmOperation.getOperand());
                break;
            }
            case 25: {
                paragraphProperties.setDyaAbs(sprmOperation.getOperand());
                break;
            }
            case 26: {
                paragraphProperties.setDxaWidth(sprmOperation.getOperand());
                break;
            }
            case 27: {
                byte by = (byte)sprmOperation.getOperand();
                byte by2 = (byte)((by & 0xC) >> 2);
                byte by3 = (byte)(by & 3);
                if (by2 != 3) {
                    paragraphProperties.setPcVert(by2);
                }
                if (by3 == 3) break;
                paragraphProperties.setPcHorz(by3);
                break;
            }
            case 34: {
                paragraphProperties.setDxaFromText(sprmOperation.getOperand());
                break;
            }
            case 35: {
                paragraphProperties.setWr((byte)sprmOperation.getOperand());
                break;
            }
            case 36: {
                paragraphProperties.setBrcTop(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 37: {
                paragraphProperties.setBrcLeft(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 38: {
                paragraphProperties.setBrcBottom(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 39: {
                paragraphProperties.setBrcRight(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 40: {
                paragraphProperties.setBrcBetween(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 41: {
                paragraphProperties.setBrcBar(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 42: {
                paragraphProperties.setFNoAutoHyph(sprmOperation.getOperand() != 0);
                break;
            }
            case 43: {
                paragraphProperties.setDyaHeight(sprmOperation.getOperand());
                break;
            }
            case 44: {
                paragraphProperties.setDcs(new DropCapSpecifier((short)sprmOperation.getOperand()));
                break;
            }
            case 45: {
                paragraphProperties.setShd(new ShadingDescriptor80((short)sprmOperation.getOperand()).toShadingDescriptor());
                break;
            }
            case 46: {
                paragraphProperties.setDyaFromText(sprmOperation.getOperand());
                break;
            }
            case 47: {
                paragraphProperties.setDxaFromText(sprmOperation.getOperand());
                break;
            }
            case 48: {
                paragraphProperties.setFLocked(sprmOperation.getOperand() != 0);
                break;
            }
            case 49: {
                paragraphProperties.setFWidowControl(sprmOperation.getOperand() != 0);
                break;
            }
            case 51: {
                paragraphProperties.setFKinsoku(sprmOperation.getOperand() != 0);
                break;
            }
            case 52: {
                paragraphProperties.setFWordWrap(sprmOperation.getOperand() != 0);
                break;
            }
            case 53: {
                paragraphProperties.setFOverflowPunct(sprmOperation.getOperand() != 0);
                break;
            }
            case 54: {
                paragraphProperties.setFTopLinePunct(sprmOperation.getOperand() != 0);
                break;
            }
            case 55: {
                paragraphProperties.setFAutoSpaceDE(sprmOperation.getOperand() != 0);
                break;
            }
            case 56: {
                paragraphProperties.setFAutoSpaceDN(sprmOperation.getOperand() != 0);
                break;
            }
            case 57: {
                paragraphProperties.setWAlignFont(sprmOperation.getOperand());
                break;
            }
            case 58: {
                paragraphProperties.setFontAlign((short)sprmOperation.getOperand());
                break;
            }
            case 59: {
                break;
            }
            case 62: {
                byte[] byArray = new byte[sprmOperation.size() - 3];
                System.arraycopy(byArray, 0, sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset(), byArray.length);
                paragraphProperties.setAnld(byArray);
                break;
            }
            case 63: {
                byte[] byArray = sprmOperation.getGrpprl();
                int n = sprmOperation.getGrpprlOffset();
                paragraphProperties.setFPropRMark(byArray[n] != 0);
                paragraphProperties.setIbstPropRMark(LittleEndian.getShort(byArray, n + 1));
                paragraphProperties.setDttmPropRMark(new DateAndTime(byArray, n + 3));
                break;
            }
            case 64: {
                paragraphProperties.setLvl((byte)sprmOperation.getOperand());
                break;
            }
            case 65: {
                paragraphProperties.setFBiDi(sprmOperation.getOperand() != 0);
                break;
            }
            case 67: {
                paragraphProperties.setFNumRMIns(sprmOperation.getOperand() != 0);
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                if (sprmOperation.getSizeCode() != 6) break;
                byte[] byArray = new byte[sprmOperation.size() - 3];
                System.arraycopy(byArray, 0, sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset(), byArray.length);
                paragraphProperties.setNumrm(byArray);
                break;
            }
            case 71: {
                paragraphProperties.setFUsePgsuSettings(sprmOperation.getOperand() != 0);
                break;
            }
            case 72: {
                paragraphProperties.setFAdjustRight(sprmOperation.getOperand() != 0);
                break;
            }
            case 73: {
                paragraphProperties.setItap(sprmOperation.getOperand());
                break;
            }
            case 74: {
                paragraphProperties.setItap((byte)(paragraphProperties.getItap() + sprmOperation.getOperand()));
                break;
            }
            case 75: {
                paragraphProperties.setFInnerTableCell(sprmOperation.getOperand() != 0);
                break;
            }
            case 76: {
                paragraphProperties.setFTtpEmbedded(sprmOperation.getOperand() != 0);
                break;
            }
            case 77: {
                ShadingDescriptor shadingDescriptor = new ShadingDescriptor(sprmOperation.getGrpprl(), 3);
                paragraphProperties.setShading(shadingDescriptor);
                break;
            }
            case 93: {
                paragraphProperties.setDxaRight(sprmOperation.getOperand());
                break;
            }
            case 94: {
                paragraphProperties.setDxaLeft(sprmOperation.getOperand());
                break;
            }
            case 96: {
                paragraphProperties.setDxaLeft1(sprmOperation.getOperand());
                break;
            }
            case 97: {
                paragraphProperties.setJustificationLogical((byte)sprmOperation.getOperand());
                break;
            }
            case 103: {
                paragraphProperties.setRsid(sprmOperation.getOperand());
                break;
            }
            default: {
                logger.log(1, new Object[]{"Unknown PAP sprm ignored: " + sprmOperation});
            }
        }
    }

    private static void handleTabs(ParagraphProperties paragraphProperties, SprmOperation sprmOperation) {
        Object object;
        int n;
        byte[] byArray = sprmOperation.getGrpprl();
        int n2 = sprmOperation.getGrpprlOffset();
        int n3 = byArray[n2++];
        int[] nArray = paragraphProperties.getRgdxaTab();
        TabDescriptor[] tabDescriptorArray = paragraphProperties.getRgtbd();
        HashMap<Integer, TabDescriptor> hashMap = new HashMap<Integer, TabDescriptor>();
        for (n = 0; n < nArray.length; ++n) {
            hashMap.put(nArray[n], tabDescriptorArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            hashMap.remove(LittleEndian.getShort(byArray, n2));
            n2 += 2;
        }
        n = byArray[n2++];
        int n4 = n2;
        for (int i = 0; i < n; ++i) {
            Integer n5 = LittleEndian.getShort(byArray, n2);
            object = new TabDescriptor(byArray, n4 + (TabDescriptor.getSize() * n + i));
            hashMap.put(n5, (TabDescriptor)object);
            n2 += 2;
        }
        nArray = new int[hashMap.size()];
        tabDescriptorArray = new TabDescriptor[nArray.length];
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < nArray.length; ++i) {
            object = (Integer)arrayList.get(i);
            nArray[i] = (Integer)object;
            tabDescriptorArray[i] = hashMap.containsKey(object) ? (TabDescriptor)hashMap.get(object) : new TabDescriptor();
        }
        paragraphProperties.setRgdxaTab(nArray);
        paragraphProperties.setRgtbd(tabDescriptorArray);
    }
}

