/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.sprm;

import ai2.org.apache.poi.hwpf.sprm.SprmUtils;
import ai2.org.apache.poi.hwpf.usermodel.ParagraphProperties;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Arrays;

@Internal
public final class ParagraphSprmCompressor {
    public static byte[] compressParagraphProperty(ParagraphProperties paragraphProperties, ParagraphProperties paragraphProperties2) {
        byte[] byArray;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = 0;
        if (paragraphProperties.getIstd() != paragraphProperties2.getIstd()) {
            n += SprmUtils.addSprm((short)17920, paragraphProperties.getIstd(), null, arrayList);
        }
        if (paragraphProperties.getJc() != paragraphProperties2.getJc()) {
            n += SprmUtils.addSprm((short)9219, paragraphProperties.getJc(), null, arrayList);
        }
        if (paragraphProperties.getFSideBySide() != paragraphProperties2.getFSideBySide()) {
            n += SprmUtils.addSprm((short)9220, paragraphProperties.getFSideBySide(), arrayList);
        }
        if (paragraphProperties.getFKeep() != paragraphProperties2.getFKeep()) {
            n += SprmUtils.addSprm((short)9221, paragraphProperties.getFKeep(), arrayList);
        }
        if (paragraphProperties.getFKeepFollow() != paragraphProperties2.getFKeepFollow()) {
            n += SprmUtils.addSprm((short)9222, paragraphProperties.getFKeepFollow(), arrayList);
        }
        if (paragraphProperties.getFPageBreakBefore() != paragraphProperties2.getFPageBreakBefore()) {
            n += SprmUtils.addSprm((short)9223, paragraphProperties.getFPageBreakBefore(), arrayList);
        }
        if (paragraphProperties.getBrcl() != paragraphProperties2.getBrcl()) {
            n += SprmUtils.addSprm((short)9224, paragraphProperties.getBrcl(), null, arrayList);
        }
        if (paragraphProperties.getBrcp() != paragraphProperties2.getBrcp()) {
            n += SprmUtils.addSprm((short)9225, paragraphProperties.getBrcp(), null, arrayList);
        }
        if (paragraphProperties.getIlvl() != paragraphProperties2.getIlvl()) {
            n += SprmUtils.addSprm((short)9738, paragraphProperties.getIlvl(), null, arrayList);
        }
        if (paragraphProperties.getIlfo() != paragraphProperties2.getIlfo()) {
            n += SprmUtils.addSprm((short)17931, paragraphProperties.getIlfo(), null, arrayList);
        }
        if (paragraphProperties.getFNoLnn() != paragraphProperties2.getFNoLnn()) {
            n += SprmUtils.addSprm((short)9228, paragraphProperties.getFNoLnn(), arrayList);
        }
        if (paragraphProperties.getItbdMac() != paragraphProperties2.getItbdMac() || !Arrays.equals(paragraphProperties.getRgdxaTab(), paragraphProperties2.getRgdxaTab()) || !Arrays.equals(paragraphProperties.getRgtbd(), paragraphProperties2.getRgtbd())) {
            // empty if block
        }
        if (paragraphProperties.getDxaLeft() != paragraphProperties2.getDxaLeft()) {
            n += SprmUtils.addSprm((short)-31729, paragraphProperties.getDxaLeft(), null, arrayList);
        }
        if (paragraphProperties.getDxaLeft1() != paragraphProperties2.getDxaLeft1()) {
            n += SprmUtils.addSprm((short)-31727, paragraphProperties.getDxaLeft1(), null, arrayList);
        }
        if (paragraphProperties.getDxaRight() != paragraphProperties2.getDxaRight()) {
            n += SprmUtils.addSprm((short)-31730, paragraphProperties.getDxaRight(), null, arrayList);
        }
        if (paragraphProperties.getDxcLeft() != paragraphProperties2.getDxcLeft()) {
            n += SprmUtils.addSprm((short)17494, paragraphProperties.getDxcLeft(), null, arrayList);
        }
        if (paragraphProperties.getDxcLeft1() != paragraphProperties2.getDxcLeft1()) {
            n += SprmUtils.addSprm((short)17495, paragraphProperties.getDxcLeft1(), null, arrayList);
        }
        if (paragraphProperties.getDxcRight() != paragraphProperties2.getDxcRight()) {
            n += SprmUtils.addSprm((short)17493, paragraphProperties.getDxcRight(), null, arrayList);
        }
        if (!paragraphProperties.getLspd().equals(paragraphProperties2.getLspd())) {
            byArray = new byte[4];
            paragraphProperties.getLspd().serialize(byArray, 0);
            n += SprmUtils.addSprm((short)25618, LittleEndian.getInt(byArray), null, arrayList);
        }
        if (paragraphProperties.getDyaBefore() != paragraphProperties2.getDyaBefore()) {
            n += SprmUtils.addSprm((short)-23533, paragraphProperties.getDyaBefore(), null, arrayList);
        }
        if (paragraphProperties.getDyaAfter() != paragraphProperties2.getDyaAfter()) {
            n += SprmUtils.addSprm((short)-23532, paragraphProperties.getDyaAfter(), null, arrayList);
        }
        if (paragraphProperties.getFDyaBeforeAuto() != paragraphProperties2.getFDyaBeforeAuto()) {
            n += SprmUtils.addSprm((short)9307, paragraphProperties.getFDyaBeforeAuto(), arrayList);
        }
        if (paragraphProperties.getFDyaAfterAuto() != paragraphProperties2.getFDyaAfterAuto()) {
            n += SprmUtils.addSprm((short)9308, paragraphProperties.getFDyaAfterAuto(), arrayList);
        }
        if (paragraphProperties.getFInTable() != paragraphProperties2.getFInTable()) {
            n += SprmUtils.addSprm((short)9238, paragraphProperties.getFInTable(), arrayList);
        }
        if (paragraphProperties.getFTtp() != paragraphProperties2.getFTtp()) {
            n += SprmUtils.addSprm((short)9239, paragraphProperties.getFTtp(), arrayList);
        }
        if (paragraphProperties.getDxaAbs() != paragraphProperties2.getDxaAbs()) {
            n += SprmUtils.addSprm((short)-31720, paragraphProperties.getDxaAbs(), null, arrayList);
        }
        if (paragraphProperties.getDyaAbs() != paragraphProperties2.getDyaAbs()) {
            n += SprmUtils.addSprm((short)-31719, paragraphProperties.getDyaAbs(), null, arrayList);
        }
        if (paragraphProperties.getDxaWidth() != paragraphProperties2.getDxaWidth()) {
            n += SprmUtils.addSprm((short)-31718, paragraphProperties.getDxaWidth(), null, arrayList);
        }
        if (paragraphProperties.getWr() != paragraphProperties2.getWr()) {
            n += SprmUtils.addSprm((short)9251, paragraphProperties.getWr(), null, arrayList);
        }
        if (paragraphProperties.getBrcBar().equals(paragraphProperties2.getBrcBar())) {
            int n2 = paragraphProperties.getBrcBar().toInt();
            n += SprmUtils.addSprm((short)25640, n2, null, arrayList);
        }
        if (!paragraphProperties.getBrcBottom().equals(paragraphProperties2.getBrcBottom())) {
            int n3 = paragraphProperties.getBrcBottom().toInt();
            n += SprmUtils.addSprm((short)25638, n3, null, arrayList);
        }
        if (!paragraphProperties.getBrcLeft().equals(paragraphProperties2.getBrcLeft())) {
            int n4 = paragraphProperties.getBrcLeft().toInt();
            n += SprmUtils.addSprm((short)25637, n4, null, arrayList);
        }
        if (!paragraphProperties.getBrcRight().equals(paragraphProperties2.getBrcRight())) {
            int n5 = paragraphProperties.getBrcRight().toInt();
            n += SprmUtils.addSprm((short)25639, n5, null, arrayList);
        }
        if (!paragraphProperties.getBrcTop().equals(paragraphProperties2.getBrcTop())) {
            int n6 = paragraphProperties.getBrcTop().toInt();
            n += SprmUtils.addSprm((short)25636, n6, null, arrayList);
        }
        if (paragraphProperties.getFNoAutoHyph() != paragraphProperties2.getFNoAutoHyph()) {
            n += SprmUtils.addSprm((short)9258, paragraphProperties.getFNoAutoHyph(), arrayList);
        }
        if (paragraphProperties.getDyaHeight() != paragraphProperties2.getDyaHeight() || paragraphProperties.getFMinHeight() != paragraphProperties2.getFMinHeight()) {
            short s = (short)paragraphProperties.getDyaHeight();
            if (paragraphProperties.getFMinHeight()) {
                s = (short)(s | 0x8000);
            }
            n += SprmUtils.addSprm((short)17451, s, null, arrayList);
        }
        if (paragraphProperties.getDcs() != null && !paragraphProperties.getDcs().equals(paragraphProperties2.getDcs())) {
            n += SprmUtils.addSprm((short)17452, paragraphProperties.getDcs().toShort(), null, arrayList);
        }
        if (paragraphProperties.getDyaFromText() != paragraphProperties2.getDyaFromText()) {
            n += SprmUtils.addSprm((short)-31698, paragraphProperties.getDyaFromText(), null, arrayList);
        }
        if (paragraphProperties.getDxaFromText() != paragraphProperties2.getDxaFromText()) {
            n += SprmUtils.addSprm((short)-31697, paragraphProperties.getDxaFromText(), null, arrayList);
        }
        if (paragraphProperties.getFLocked() != paragraphProperties2.getFLocked()) {
            n += SprmUtils.addSprm((short)9264, paragraphProperties.getFLocked(), arrayList);
        }
        if (paragraphProperties.getFWidowControl() != paragraphProperties2.getFWidowControl()) {
            n += SprmUtils.addSprm((short)9265, paragraphProperties.getFWidowControl(), arrayList);
        }
        if (paragraphProperties.getFKinsoku() != paragraphProperties2.getFKinsoku()) {
            n += SprmUtils.addSprm((short)9267, paragraphProperties.getDyaBefore(), null, arrayList);
        }
        if (paragraphProperties.getFWordWrap() != paragraphProperties2.getFWordWrap()) {
            n += SprmUtils.addSprm((short)9268, paragraphProperties.getFWordWrap(), arrayList);
        }
        if (paragraphProperties.getFOverflowPunct() != paragraphProperties2.getFOverflowPunct()) {
            n += SprmUtils.addSprm((short)9269, paragraphProperties.getFOverflowPunct(), arrayList);
        }
        if (paragraphProperties.getFTopLinePunct() != paragraphProperties2.getFTopLinePunct()) {
            n += SprmUtils.addSprm((short)9270, paragraphProperties.getFTopLinePunct(), arrayList);
        }
        if (paragraphProperties.getFAutoSpaceDE() != paragraphProperties2.getFAutoSpaceDE()) {
            n += SprmUtils.addSprm((short)9271, paragraphProperties.getFAutoSpaceDE(), arrayList);
        }
        if (paragraphProperties.getFAutoSpaceDN() != paragraphProperties2.getFAutoSpaceDN()) {
            n += SprmUtils.addSprm((short)9272, paragraphProperties.getFAutoSpaceDN(), arrayList);
        }
        if (paragraphProperties.getWAlignFont() != paragraphProperties2.getWAlignFont()) {
            n += SprmUtils.addSprm((short)17465, paragraphProperties.getWAlignFont(), null, arrayList);
        }
        if (paragraphProperties.isFBackward() != paragraphProperties2.isFBackward() || paragraphProperties.isFVertical() != paragraphProperties2.isFVertical() || paragraphProperties.isFRotateFont() != paragraphProperties2.isFRotateFont()) {
            int n7 = 0;
            if (paragraphProperties.isFBackward()) {
                n7 |= 2;
            }
            if (paragraphProperties.isFVertical()) {
                n7 |= 1;
            }
            if (paragraphProperties.isFRotateFont()) {
                n7 |= 4;
            }
            n += SprmUtils.addSprm((short)17466, n7, null, arrayList);
        }
        if (!Arrays.equals(paragraphProperties.getAnld(), paragraphProperties2.getAnld())) {
            n += SprmUtils.addSprm((short)-14786, 0, paragraphProperties.getAnld(), arrayList);
        }
        if (paragraphProperties.getFPropRMark() != paragraphProperties2.getFPropRMark() || paragraphProperties.getIbstPropRMark() != paragraphProperties2.getIbstPropRMark() || !paragraphProperties.getDttmPropRMark().equals(paragraphProperties2.getDttmPropRMark())) {
            byArray = new byte[7];
            byArray[0] = (byte)(paragraphProperties.getFPropRMark() ? 1 : 0);
            LittleEndian.putShort(byArray, 1, (short)paragraphProperties.getIbstPropRMark());
            paragraphProperties.getDttmPropRMark().serialize(byArray, 3);
            n += SprmUtils.addSprm((short)-14785, 0, byArray, arrayList);
        }
        if (paragraphProperties.getLvl() != paragraphProperties2.getLvl()) {
            n += SprmUtils.addSprm((short)9792, paragraphProperties.getLvl(), null, arrayList);
        }
        if (paragraphProperties.getFBiDi() != paragraphProperties2.getFBiDi()) {
            n += SprmUtils.addSprm((short)9281, paragraphProperties.getFBiDi(), arrayList);
        }
        if (paragraphProperties.getFNumRMIns() != paragraphProperties2.getFNumRMIns()) {
            n += SprmUtils.addSprm((short)9283, paragraphProperties.getFNumRMIns(), arrayList);
        }
        if (!Arrays.equals(paragraphProperties.getNumrm(), paragraphProperties2.getNumrm())) {
            n += SprmUtils.addSprm((short)-14779, 0, paragraphProperties.getNumrm(), arrayList);
        }
        if (paragraphProperties.getFInnerTableCell() != paragraphProperties2.getFInnerTableCell()) {
            n += SprmUtils.addSprm((short)9291, paragraphProperties.getFInnerTableCell(), arrayList);
        }
        if (paragraphProperties.getFTtpEmbedded() != paragraphProperties2.getFTtpEmbedded()) {
            n += SprmUtils.addSprm((short)9292, paragraphProperties.getFTtpEmbedded(), arrayList);
        }
        if (paragraphProperties.getShd() != null && !paragraphProperties.getShd().equals(paragraphProperties2.getShd())) {
            n += SprmUtils.addSprm((short)-14771, 0, paragraphProperties.getShd().serialize(), arrayList);
        }
        if (paragraphProperties.getItap() != paragraphProperties2.getItap()) {
            n += SprmUtils.addSprm((short)26185, paragraphProperties.getItap(), null, arrayList);
        }
        if (paragraphProperties.getRsid() != paragraphProperties2.getRsid()) {
            byArray = new byte[4];
            LittleEndian.putUInt(byArray, paragraphProperties.getRsid());
            n += SprmUtils.addSprm((short)25703, 0, byArray, arrayList);
        }
        return SprmUtils.getGrpprl(arrayList, n);
    }
}

