/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class StshifAbstractType {
    protected int field_1_cstd;
    protected int field_2_cbSTDBaseInFile;
    protected int field_3_info3;
    private static final BitField fHasOriginalStyle = new BitField(1);
    private static final BitField fReserved = new BitField(65534);
    protected int field_4_stiMaxWhenSaved;
    protected int field_5_istdMaxFixedWhenSaved;
    protected int field_6_nVerBuiltInNamesWhenSaved;
    protected short field_7_ftcAsci;
    protected short field_8_ftcFE;
    protected short field_9_ftcOther;

    protected StshifAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_cstd = LittleEndian.getShort(byArray, 0 + n);
        this.field_2_cbSTDBaseInFile = LittleEndian.getShort(byArray, 2 + n);
        this.field_3_info3 = LittleEndian.getShort(byArray, 4 + n);
        this.field_4_stiMaxWhenSaved = LittleEndian.getShort(byArray, 6 + n);
        this.field_5_istdMaxFixedWhenSaved = LittleEndian.getShort(byArray, 8 + n);
        this.field_6_nVerBuiltInNamesWhenSaved = LittleEndian.getShort(byArray, 10 + n);
        this.field_7_ftcAsci = LittleEndian.getShort(byArray, 12 + n);
        this.field_8_ftcFE = LittleEndian.getShort(byArray, 14 + n);
        this.field_9_ftcOther = LittleEndian.getShort(byArray, 16 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putUShort(byArray, 0 + n, this.field_1_cstd);
        LittleEndian.putUShort(byArray, 2 + n, this.field_2_cbSTDBaseInFile);
        LittleEndian.putUShort(byArray, 4 + n, this.field_3_info3);
        LittleEndian.putUShort(byArray, 6 + n, this.field_4_stiMaxWhenSaved);
        LittleEndian.putUShort(byArray, 8 + n, this.field_5_istdMaxFixedWhenSaved);
        LittleEndian.putUShort(byArray, 10 + n, this.field_6_nVerBuiltInNamesWhenSaved);
        LittleEndian.putShort(byArray, 12 + n, this.field_7_ftcAsci);
        LittleEndian.putShort(byArray, 14 + n, this.field_8_ftcFE);
        LittleEndian.putShort(byArray, 16 + n, this.field_9_ftcOther);
    }

    public static int getSize() {
        return 18;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Stshif]\n");
        stringBuilder.append("    .cstd                 = ");
        stringBuilder.append(" (").append(this.getCstd()).append(" )\n");
        stringBuilder.append("    .cbSTDBaseInFile      = ");
        stringBuilder.append(" (").append(this.getCbSTDBaseInFile()).append(" )\n");
        stringBuilder.append("    .info3                = ");
        stringBuilder.append(" (").append(this.getInfo3()).append(" )\n");
        stringBuilder.append("         .fHasOriginalStyle        = ").append(this.isFHasOriginalStyle()).append('\n');
        stringBuilder.append("         .fReserved                = ").append(this.getFReserved()).append('\n');
        stringBuilder.append("    .stiMaxWhenSaved      = ");
        stringBuilder.append(" (").append(this.getStiMaxWhenSaved()).append(" )\n");
        stringBuilder.append("    .istdMaxFixedWhenSaved = ");
        stringBuilder.append(" (").append(this.getIstdMaxFixedWhenSaved()).append(" )\n");
        stringBuilder.append("    .nVerBuiltInNamesWhenSaved = ");
        stringBuilder.append(" (").append(this.getNVerBuiltInNamesWhenSaved()).append(" )\n");
        stringBuilder.append("    .ftcAsci              = ");
        stringBuilder.append(" (").append(this.getFtcAsci()).append(" )\n");
        stringBuilder.append("    .ftcFE                = ");
        stringBuilder.append(" (").append(this.getFtcFE()).append(" )\n");
        stringBuilder.append("    .ftcOther             = ");
        stringBuilder.append(" (").append(this.getFtcOther()).append(" )\n");
        stringBuilder.append("[/Stshif]\n");
        return stringBuilder.toString();
    }

    @Internal
    public int getCstd() {
        return this.field_1_cstd;
    }

    @Internal
    public void setCstd(int n) {
        this.field_1_cstd = n;
    }

    @Internal
    public int getCbSTDBaseInFile() {
        return this.field_2_cbSTDBaseInFile;
    }

    @Internal
    public void setCbSTDBaseInFile(int n) {
        this.field_2_cbSTDBaseInFile = n;
    }

    @Internal
    public int getInfo3() {
        return this.field_3_info3;
    }

    @Internal
    public void setInfo3(int n) {
        this.field_3_info3 = n;
    }

    @Internal
    public int getStiMaxWhenSaved() {
        return this.field_4_stiMaxWhenSaved;
    }

    @Internal
    public void setStiMaxWhenSaved(int n) {
        this.field_4_stiMaxWhenSaved = n;
    }

    @Internal
    public int getIstdMaxFixedWhenSaved() {
        return this.field_5_istdMaxFixedWhenSaved;
    }

    @Internal
    public void setIstdMaxFixedWhenSaved(int n) {
        this.field_5_istdMaxFixedWhenSaved = n;
    }

    @Internal
    public int getNVerBuiltInNamesWhenSaved() {
        return this.field_6_nVerBuiltInNamesWhenSaved;
    }

    @Internal
    public void setNVerBuiltInNamesWhenSaved(int n) {
        this.field_6_nVerBuiltInNamesWhenSaved = n;
    }

    @Internal
    public short getFtcAsci() {
        return this.field_7_ftcAsci;
    }

    @Internal
    public void setFtcAsci(short s) {
        this.field_7_ftcAsci = s;
    }

    @Internal
    public short getFtcFE() {
        return this.field_8_ftcFE;
    }

    @Internal
    public void setFtcFE(short s) {
        this.field_8_ftcFE = s;
    }

    @Internal
    public short getFtcOther() {
        return this.field_9_ftcOther;
    }

    @Internal
    public void setFtcOther(short s) {
        this.field_9_ftcOther = s;
    }

    @Internal
    public void setFHasOriginalStyle(boolean bl) {
        this.field_3_info3 = fHasOriginalStyle.setBoolean(this.field_3_info3, bl);
    }

    @Internal
    public boolean isFHasOriginalStyle() {
        return fHasOriginalStyle.isSet(this.field_3_info3);
    }

    @Internal
    public void setFReserved(short s) {
        this.field_3_info3 = fReserved.setValue(this.field_3_info3, s);
    }

    @Internal
    public short getFReserved() {
        return (short)fReserved.getValue(this.field_3_info3);
    }
}

