/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class StdfPost2000AbstractType {
    protected short field_1_info1;
    private static final BitField istdLink = new BitField(4095);
    private static final BitField fHasOriginalStyle = new BitField(4096);
    private static final BitField fSpare = new BitField(57344);
    protected long field_2_rsid;
    protected short field_3_info3;
    private static final BitField iftcHtml = new BitField(7);
    private static final BitField unused = new BitField(8);
    private static final BitField iPriority = new BitField(65520);

    protected StdfPost2000AbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_info1 = LittleEndian.getShort(byArray, 0 + n);
        this.field_2_rsid = LittleEndian.getUInt(byArray, 2 + n);
        this.field_3_info3 = LittleEndian.getShort(byArray, 6 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, 0 + n, this.field_1_info1);
        LittleEndian.putUInt(byArray, 2 + n, this.field_2_rsid);
        LittleEndian.putShort(byArray, 6 + n, this.field_3_info3);
    }

    public static int getSize() {
        return 8;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[StdfPost2000]\n");
        stringBuilder.append("    .info1                = ");
        stringBuilder.append(" (").append(this.getInfo1()).append(" )\n");
        stringBuilder.append("         .istdLink                 = ").append(this.getIstdLink()).append('\n');
        stringBuilder.append("         .fHasOriginalStyle        = ").append(this.isFHasOriginalStyle()).append('\n');
        stringBuilder.append("         .fSpare                   = ").append(this.getFSpare()).append('\n');
        stringBuilder.append("    .rsid                 = ");
        stringBuilder.append(" (").append(this.getRsid()).append(" )\n");
        stringBuilder.append("    .info3                = ");
        stringBuilder.append(" (").append(this.getInfo3()).append(" )\n");
        stringBuilder.append("         .iftcHtml                 = ").append(this.getIftcHtml()).append('\n');
        stringBuilder.append("         .unused                   = ").append(this.isUnused()).append('\n');
        stringBuilder.append("         .iPriority                = ").append(this.getIPriority()).append('\n');
        stringBuilder.append("[/StdfPost2000]\n");
        return stringBuilder.toString();
    }

    @Internal
    public short getInfo1() {
        return this.field_1_info1;
    }

    @Internal
    public void setInfo1(short s) {
        this.field_1_info1 = s;
    }

    @Internal
    public long getRsid() {
        return this.field_2_rsid;
    }

    @Internal
    public void setRsid(long l) {
        this.field_2_rsid = l;
    }

    @Internal
    public short getInfo3() {
        return this.field_3_info3;
    }

    @Internal
    public void setInfo3(short s) {
        this.field_3_info3 = s;
    }

    @Internal
    public void setIstdLink(short s) {
        this.field_1_info1 = (short)istdLink.setValue(this.field_1_info1, s);
    }

    @Internal
    public short getIstdLink() {
        return (short)istdLink.getValue(this.field_1_info1);
    }

    @Internal
    public void setFHasOriginalStyle(boolean bl) {
        this.field_1_info1 = (short)fHasOriginalStyle.setBoolean(this.field_1_info1, bl);
    }

    @Internal
    public boolean isFHasOriginalStyle() {
        return fHasOriginalStyle.isSet(this.field_1_info1);
    }

    @Internal
    public void setFSpare(byte by) {
        this.field_1_info1 = (short)fSpare.setValue(this.field_1_info1, by);
    }

    @Internal
    public byte getFSpare() {
        return (byte)fSpare.getValue(this.field_1_info1);
    }

    @Internal
    public void setIftcHtml(byte by) {
        this.field_3_info3 = (short)iftcHtml.setValue(this.field_3_info3, by);
    }

    @Internal
    public byte getIftcHtml() {
        return (byte)iftcHtml.getValue(this.field_3_info3);
    }

    @Internal
    public void setUnused(boolean bl) {
        this.field_3_info3 = (short)unused.setBoolean(this.field_3_info3, bl);
    }

    @Internal
    public boolean isUnused() {
        return unused.isSet(this.field_3_info3);
    }

    @Internal
    public void setIPriority(short s) {
        this.field_3_info3 = (short)iPriority.setValue(this.field_3_info3, s);
    }

    @Internal
    public short getIPriority() {
        return (short)iPriority.getValue(this.field_3_info3);
    }
}

