/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.hwpf.model.Colorref;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class SHDAbstractType {
    protected Colorref field_1_cvFore = new Colorref();
    protected Colorref field_2_cvBack = new Colorref();
    protected int field_3_ipat;

    protected SHDAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_cvFore = new Colorref(byArray, 0 + n);
        this.field_2_cvBack = new Colorref(byArray, 4 + n);
        this.field_3_ipat = LittleEndian.getShort(byArray, 8 + n);
    }

    public void serialize(byte[] byArray, int n) {
        this.field_1_cvFore.serialize(byArray, 0 + n);
        this.field_2_cvBack.serialize(byArray, 4 + n);
        LittleEndian.putUShort(byArray, 8 + n, this.field_3_ipat);
    }

    public byte[] serialize() {
        byte[] byArray = new byte[SHDAbstractType.getSize()];
        this.serialize(byArray, 0);
        return byArray;
    }

    public static int getSize() {
        return 10;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SHDAbstractType sHDAbstractType = (SHDAbstractType)object;
        if (this.field_1_cvFore != sHDAbstractType.field_1_cvFore) {
            return false;
        }
        if (this.field_2_cvBack != sHDAbstractType.field_2_cvBack) {
            return false;
        }
        return this.field_3_ipat == sHDAbstractType.field_3_ipat;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.field_1_cvFore.hashCode();
        n = 31 * n + this.field_2_cvBack.hashCode();
        n = 31 * n + this.field_3_ipat;
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[SHD]\n");
        stringBuilder.append("    .cvFore               = ");
        stringBuilder.append(" (").append(this.getCvFore()).append(" )\n");
        stringBuilder.append("    .cvBack               = ");
        stringBuilder.append(" (").append(this.getCvBack()).append(" )\n");
        stringBuilder.append("    .ipat                 = ");
        stringBuilder.append(" (").append(this.getIpat()).append(" )\n");
        stringBuilder.append("[/SHD]\n");
        return stringBuilder.toString();
    }

    @Internal
    public Colorref getCvFore() {
        return this.field_1_cvFore;
    }

    @Internal
    public void setCvFore(Colorref colorref) {
        this.field_1_cvFore = colorref;
    }

    @Internal
    public Colorref getCvBack() {
        return this.field_2_cvBack;
    }

    @Internal
    public void setCvBack(Colorref colorref) {
        this.field_2_cvBack = colorref;
    }

    @Internal
    public int getIpat() {
        return this.field_3_ipat;
    }

    @Internal
    public void setIpat(int n) {
        this.field_3_ipat = n;
    }
}

