/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.hwpf.model.Grfhic;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.Arrays;

@Internal
public abstract class LVLFAbstractType {
    protected int field_1_iStartAt;
    protected byte field_2_nfc;
    protected byte field_3_info;
    private static final BitField jc = new BitField(3);
    private static final BitField fLegal = new BitField(4);
    private static final BitField fNoRestart = new BitField(8);
    private static final BitField fIndentSav = new BitField(16);
    private static final BitField fConverted = new BitField(32);
    private static final BitField unused1 = new BitField(64);
    private static final BitField fTentative = new BitField(128);
    protected byte[] field_4_rgbxchNums = new byte[9];
    protected byte field_5_ixchFollow;
    protected int field_6_dxaIndentSav;
    protected int field_7_unused2;
    protected short field_8_cbGrpprlChpx;
    protected short field_9_cbGrpprlPapx;
    protected short field_10_ilvlRestartLim;
    protected Grfhic field_11_grfhic = new Grfhic();

    protected LVLFAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_iStartAt = LittleEndian.getInt(byArray, 0 + n);
        this.field_2_nfc = byArray[4 + n];
        this.field_3_info = byArray[5 + n];
        this.field_4_rgbxchNums = LittleEndian.getByteArray(byArray, 6 + n, 9);
        this.field_5_ixchFollow = byArray[15 + n];
        this.field_6_dxaIndentSav = LittleEndian.getInt(byArray, 16 + n);
        this.field_7_unused2 = LittleEndian.getInt(byArray, 20 + n);
        this.field_8_cbGrpprlChpx = LittleEndian.getUByte(byArray, 24 + n);
        this.field_9_cbGrpprlPapx = LittleEndian.getUByte(byArray, 25 + n);
        this.field_10_ilvlRestartLim = LittleEndian.getUByte(byArray, 26 + n);
        this.field_11_grfhic = new Grfhic(byArray, 27 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putInt(byArray, 0 + n, this.field_1_iStartAt);
        byArray[4 + n] = this.field_2_nfc;
        byArray[5 + n] = this.field_3_info;
        System.arraycopy(this.field_4_rgbxchNums, 0, byArray, 6 + n, this.field_4_rgbxchNums.length);
        byArray[15 + n] = this.field_5_ixchFollow;
        LittleEndian.putInt(byArray, 16 + n, this.field_6_dxaIndentSav);
        LittleEndian.putInt(byArray, 20 + n, this.field_7_unused2);
        LittleEndian.putUByte(byArray, 24 + n, this.field_8_cbGrpprlChpx);
        LittleEndian.putUByte(byArray, 25 + n, this.field_9_cbGrpprlPapx);
        LittleEndian.putUByte(byArray, 26 + n, this.field_10_ilvlRestartLim);
        this.field_11_grfhic.serialize(byArray, 27 + n);
    }

    public byte[] serialize() {
        byte[] byArray = new byte[LVLFAbstractType.getSize()];
        this.serialize(byArray, 0);
        return byArray;
    }

    public static int getSize() {
        return 28;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LVLFAbstractType lVLFAbstractType = (LVLFAbstractType)object;
        if (this.field_1_iStartAt != lVLFAbstractType.field_1_iStartAt) {
            return false;
        }
        if (this.field_2_nfc != lVLFAbstractType.field_2_nfc) {
            return false;
        }
        if (this.field_3_info != lVLFAbstractType.field_3_info) {
            return false;
        }
        if (!Arrays.equals(this.field_4_rgbxchNums, lVLFAbstractType.field_4_rgbxchNums)) {
            return false;
        }
        if (this.field_5_ixchFollow != lVLFAbstractType.field_5_ixchFollow) {
            return false;
        }
        if (this.field_6_dxaIndentSav != lVLFAbstractType.field_6_dxaIndentSav) {
            return false;
        }
        if (this.field_7_unused2 != lVLFAbstractType.field_7_unused2) {
            return false;
        }
        if (this.field_8_cbGrpprlChpx != lVLFAbstractType.field_8_cbGrpprlChpx) {
            return false;
        }
        if (this.field_9_cbGrpprlPapx != lVLFAbstractType.field_9_cbGrpprlPapx) {
            return false;
        }
        if (this.field_10_ilvlRestartLim != lVLFAbstractType.field_10_ilvlRestartLim) {
            return false;
        }
        return !(this.field_11_grfhic == null ? lVLFAbstractType.field_11_grfhic != null : !this.field_11_grfhic.equals(lVLFAbstractType.field_11_grfhic));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.field_1_iStartAt;
        n = 31 * n + this.field_2_nfc;
        n = 31 * n + this.field_3_info;
        n = 31 * n + Arrays.hashCode(this.field_4_rgbxchNums);
        n = 31 * n + this.field_5_ixchFollow;
        n = 31 * n + this.field_6_dxaIndentSav;
        n = 31 * n + this.field_7_unused2;
        n = 31 * n + this.field_8_cbGrpprlChpx;
        n = 31 * n + this.field_9_cbGrpprlPapx;
        n = 31 * n + this.field_10_ilvlRestartLim;
        n = 31 * n + this.field_11_grfhic.hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[LVLF]\n");
        stringBuilder.append("    .iStartAt             = ");
        stringBuilder.append(" (").append(this.getIStartAt()).append(" )\n");
        stringBuilder.append("    .nfc                  = ");
        stringBuilder.append(" (").append(this.getNfc()).append(" )\n");
        stringBuilder.append("    .info                 = ");
        stringBuilder.append(" (").append(this.getInfo()).append(" )\n");
        stringBuilder.append("         .jc                       = ").append(this.getJc()).append('\n');
        stringBuilder.append("         .fLegal                   = ").append(this.isFLegal()).append('\n');
        stringBuilder.append("         .fNoRestart               = ").append(this.isFNoRestart()).append('\n');
        stringBuilder.append("         .fIndentSav               = ").append(this.isFIndentSav()).append('\n');
        stringBuilder.append("         .fConverted               = ").append(this.isFConverted()).append('\n');
        stringBuilder.append("         .unused1                  = ").append(this.isUnused1()).append('\n');
        stringBuilder.append("         .fTentative               = ").append(this.isFTentative()).append('\n');
        stringBuilder.append("    .rgbxchNums           = ");
        stringBuilder.append(" (").append(Arrays.toString(this.getRgbxchNums())).append(" )\n");
        stringBuilder.append("    .ixchFollow           = ");
        stringBuilder.append(" (").append(this.getIxchFollow()).append(" )\n");
        stringBuilder.append("    .dxaIndentSav         = ");
        stringBuilder.append(" (").append(this.getDxaIndentSav()).append(" )\n");
        stringBuilder.append("    .unused2              = ");
        stringBuilder.append(" (").append(this.getUnused2()).append(" )\n");
        stringBuilder.append("    .cbGrpprlChpx         = ");
        stringBuilder.append(" (").append(this.getCbGrpprlChpx()).append(" )\n");
        stringBuilder.append("    .cbGrpprlPapx         = ");
        stringBuilder.append(" (").append(this.getCbGrpprlPapx()).append(" )\n");
        stringBuilder.append("    .ilvlRestartLim       = ");
        stringBuilder.append(" (").append(this.getIlvlRestartLim()).append(" )\n");
        stringBuilder.append("    .grfhic               = ");
        stringBuilder.append(" (").append(this.getGrfhic()).append(" )\n");
        stringBuilder.append("[/LVLF]\n");
        return stringBuilder.toString();
    }

    @Internal
    public int getIStartAt() {
        return this.field_1_iStartAt;
    }

    @Internal
    public void setIStartAt(int n) {
        this.field_1_iStartAt = n;
    }

    @Internal
    public byte getNfc() {
        return this.field_2_nfc;
    }

    @Internal
    public void setNfc(byte by) {
        this.field_2_nfc = by;
    }

    @Internal
    public byte getInfo() {
        return this.field_3_info;
    }

    @Internal
    public void setInfo(byte by) {
        this.field_3_info = by;
    }

    @Internal
    public byte[] getRgbxchNums() {
        return this.field_4_rgbxchNums;
    }

    @Internal
    public void setRgbxchNums(byte[] byArray) {
        this.field_4_rgbxchNums = byArray;
    }

    @Internal
    public byte getIxchFollow() {
        return this.field_5_ixchFollow;
    }

    @Internal
    public void setIxchFollow(byte by) {
        this.field_5_ixchFollow = by;
    }

    @Internal
    public int getDxaIndentSav() {
        return this.field_6_dxaIndentSav;
    }

    @Internal
    public void setDxaIndentSav(int n) {
        this.field_6_dxaIndentSav = n;
    }

    @Internal
    public int getUnused2() {
        return this.field_7_unused2;
    }

    @Internal
    public void setUnused2(int n) {
        this.field_7_unused2 = n;
    }

    @Internal
    public short getCbGrpprlChpx() {
        return this.field_8_cbGrpprlChpx;
    }

    @Internal
    public void setCbGrpprlChpx(short s) {
        this.field_8_cbGrpprlChpx = s;
    }

    @Internal
    public short getCbGrpprlPapx() {
        return this.field_9_cbGrpprlPapx;
    }

    @Internal
    public void setCbGrpprlPapx(short s) {
        this.field_9_cbGrpprlPapx = s;
    }

    @Internal
    public short getIlvlRestartLim() {
        return this.field_10_ilvlRestartLim;
    }

    @Internal
    public void setIlvlRestartLim(short s) {
        this.field_10_ilvlRestartLim = s;
    }

    @Internal
    public Grfhic getGrfhic() {
        return this.field_11_grfhic;
    }

    @Internal
    public void setGrfhic(Grfhic grfhic) {
        this.field_11_grfhic = grfhic;
    }

    @Internal
    public void setJc(byte by) {
        this.field_3_info = (byte)jc.setValue(this.field_3_info, by);
    }

    @Internal
    public byte getJc() {
        return (byte)jc.getValue(this.field_3_info);
    }

    @Internal
    public void setFLegal(boolean bl) {
        this.field_3_info = (byte)fLegal.setBoolean(this.field_3_info, bl);
    }

    @Internal
    public boolean isFLegal() {
        return fLegal.isSet(this.field_3_info);
    }

    @Internal
    public void setFNoRestart(boolean bl) {
        this.field_3_info = (byte)fNoRestart.setBoolean(this.field_3_info, bl);
    }

    @Internal
    public boolean isFNoRestart() {
        return fNoRestart.isSet(this.field_3_info);
    }

    @Internal
    public void setFIndentSav(boolean bl) {
        this.field_3_info = (byte)fIndentSav.setBoolean(this.field_3_info, bl);
    }

    @Internal
    public boolean isFIndentSav() {
        return fIndentSav.isSet(this.field_3_info);
    }

    @Internal
    public void setFConverted(boolean bl) {
        this.field_3_info = (byte)fConverted.setBoolean(this.field_3_info, bl);
    }

    @Internal
    public boolean isFConverted() {
        return fConverted.isSet(this.field_3_info);
    }

    @Internal
    public void setUnused1(boolean bl) {
        this.field_3_info = (byte)unused1.setBoolean(this.field_3_info, bl);
    }

    @Internal
    @Deprecated
    public boolean isUnused1() {
        return unused1.isSet(this.field_3_info);
    }

    @Internal
    public void setFTentative(boolean bl) {
        this.field_3_info = (byte)fTentative.setBoolean(this.field_3_info, bl);
    }

    @Internal
    public boolean isFTentative() {
        return fTentative.isSet(this.field_3_info);
    }
}

