/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.hwpf.model.Grfhic;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class LFOAbstractType {
    protected int field_1_lsid;
    protected int field_2_unused1;
    protected int field_3_unused2;
    protected byte field_4_clfolvl;
    protected byte field_5_ibstFltAutoNum;
    protected Grfhic field_6_grfhic = new Grfhic();
    protected byte field_7_unused3;

    protected LFOAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_lsid = LittleEndian.getInt(byArray, 0 + n);
        this.field_2_unused1 = LittleEndian.getInt(byArray, 4 + n);
        this.field_3_unused2 = LittleEndian.getInt(byArray, 8 + n);
        this.field_4_clfolvl = byArray[12 + n];
        this.field_5_ibstFltAutoNum = byArray[13 + n];
        this.field_6_grfhic = new Grfhic(byArray, 14 + n);
        this.field_7_unused3 = byArray[15 + n];
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putInt(byArray, 0 + n, this.field_1_lsid);
        LittleEndian.putInt(byArray, 4 + n, this.field_2_unused1);
        LittleEndian.putInt(byArray, 8 + n, this.field_3_unused2);
        byArray[12 + n] = this.field_4_clfolvl;
        byArray[13 + n] = this.field_5_ibstFltAutoNum;
        this.field_6_grfhic.serialize(byArray, 14 + n);
        byArray[15 + n] = this.field_7_unused3;
    }

    public byte[] serialize() {
        byte[] byArray = new byte[LFOAbstractType.getSize()];
        this.serialize(byArray, 0);
        return byArray;
    }

    public static int getSize() {
        return 16;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LFOAbstractType lFOAbstractType = (LFOAbstractType)object;
        if (this.field_1_lsid != lFOAbstractType.field_1_lsid) {
            return false;
        }
        if (this.field_2_unused1 != lFOAbstractType.field_2_unused1) {
            return false;
        }
        if (this.field_3_unused2 != lFOAbstractType.field_3_unused2) {
            return false;
        }
        if (this.field_4_clfolvl != lFOAbstractType.field_4_clfolvl) {
            return false;
        }
        if (this.field_5_ibstFltAutoNum != lFOAbstractType.field_5_ibstFltAutoNum) {
            return false;
        }
        if (this.field_6_grfhic == null ? lFOAbstractType.field_6_grfhic != null : !this.field_6_grfhic.equals(lFOAbstractType.field_6_grfhic)) {
            return false;
        }
        return this.field_7_unused3 == lFOAbstractType.field_7_unused3;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.field_1_lsid;
        n = 31 * n + this.field_2_unused1;
        n = 31 * n + this.field_3_unused2;
        n = 31 * n + this.field_4_clfolvl;
        n = 31 * n + this.field_5_ibstFltAutoNum;
        n = 31 * n + (this.field_6_grfhic == null ? 0 : this.field_6_grfhic.hashCode());
        n = 31 * n + this.field_7_unused3;
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[LFO]\n");
        stringBuilder.append("    .lsid                 = ");
        stringBuilder.append(" ( ").append(this.field_1_lsid).append(" )\n");
        stringBuilder.append("    .unused1              = ");
        stringBuilder.append(" ( ").append(this.field_2_unused1).append(" )\n");
        stringBuilder.append("    .unused2              = ");
        stringBuilder.append(" ( ").append(this.field_3_unused2).append(" )\n");
        stringBuilder.append("    .clfolvl              = ");
        stringBuilder.append(" ( ").append(this.field_4_clfolvl).append(" )\n");
        stringBuilder.append("    .ibstFltAutoNum       = ");
        stringBuilder.append(" ( ").append(this.field_5_ibstFltAutoNum).append(" )\n");
        stringBuilder.append("    .grfhic               = ");
        stringBuilder.append(" ( ").append(this.field_6_grfhic == null ? "null" : this.field_6_grfhic.toString().replaceAll("\n", "\n    ")).append(" )\n");
        stringBuilder.append("    .unused3              = ");
        stringBuilder.append(" ( ").append(this.field_7_unused3).append(" )\n");
        stringBuilder.append("[/LFO]");
        return stringBuilder.toString();
    }

    @Internal
    public int getLsid() {
        return this.field_1_lsid;
    }

    @Internal
    public void setLsid(int n) {
        this.field_1_lsid = n;
    }

    @Internal
    public int getUnused1() {
        return this.field_2_unused1;
    }

    @Internal
    public void setUnused1(int n) {
        this.field_2_unused1 = n;
    }

    @Internal
    public int getUnused2() {
        return this.field_3_unused2;
    }

    @Internal
    public void setUnused2(int n) {
        this.field_3_unused2 = n;
    }

    @Internal
    public byte getClfolvl() {
        return this.field_4_clfolvl;
    }

    @Internal
    public void setClfolvl(byte by) {
        this.field_4_clfolvl = by;
    }

    @Internal
    public byte getIbstFltAutoNum() {
        return this.field_5_ibstFltAutoNum;
    }

    @Internal
    public void setIbstFltAutoNum(byte by) {
        this.field_5_ibstFltAutoNum = by;
    }

    @Internal
    public Grfhic getGrfhic() {
        return this.field_6_grfhic;
    }

    @Internal
    public void setGrfhic(Grfhic grfhic) {
        this.field_6_grfhic = grfhic;
    }

    @Internal
    public byte getUnused3() {
        return this.field_7_unused3;
    }

    @Internal
    public void setUnused3(byte by) {
        this.field_7_unused3 = by;
    }
}

