/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class FibBaseAbstractType {
    protected int field_1_wIdent;
    protected int field_2_nFib;
    protected int field_3_unused;
    protected int field_4_lid;
    protected int field_5_pnNext;
    protected short field_6_flags1;
    private static final BitField fDot = new BitField(1);
    private static final BitField fGlsy = new BitField(2);
    private static final BitField fComplex = new BitField(4);
    private static final BitField fHasPic = new BitField(8);
    private static final BitField cQuickSaves = new BitField(240);
    private static final BitField fEncrypted = new BitField(256);
    private static final BitField fWhichTblStm = new BitField(512);
    private static final BitField fReadOnlyRecommended = new BitField(1024);
    private static final BitField fWriteReservation = new BitField(2048);
    private static final BitField fExtChar = new BitField(4096);
    private static final BitField fLoadOverride = new BitField(8192);
    private static final BitField fFarEast = new BitField(16384);
    private static final BitField fObfuscated = new BitField(32768);
    protected int field_7_nFibBack;
    protected int field_8_lKey;
    @Deprecated
    protected byte field_9_envr;
    protected byte field_10_flags2;
    private static final BitField fMac = new BitField(1);
    private static final BitField fEmptySpecial = new BitField(2);
    private static final BitField fLoadOverridePage = new BitField(4);
    private static final BitField reserved1 = new BitField(8);
    private static final BitField reserved2 = new BitField(16);
    private static final BitField fSpare0 = new BitField(254);
    @Deprecated
    protected short field_11_Chs;
    @Deprecated
    protected short field_12_chsTables;
    @Deprecated
    protected int field_13_fcMin;
    @Deprecated
    protected int field_14_fcMac;

    protected FibBaseAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_wIdent = LittleEndian.getShort(byArray, 0 + n);
        this.field_2_nFib = LittleEndian.getShort(byArray, 2 + n);
        this.field_3_unused = LittleEndian.getShort(byArray, 4 + n);
        this.field_4_lid = LittleEndian.getShort(byArray, 6 + n);
        this.field_5_pnNext = LittleEndian.getShort(byArray, 8 + n);
        this.field_6_flags1 = LittleEndian.getShort(byArray, 10 + n);
        this.field_7_nFibBack = LittleEndian.getShort(byArray, 12 + n);
        this.field_8_lKey = LittleEndian.getInt(byArray, 14 + n);
        this.field_9_envr = byArray[18 + n];
        this.field_10_flags2 = byArray[19 + n];
        this.field_11_Chs = LittleEndian.getShort(byArray, 20 + n);
        this.field_12_chsTables = LittleEndian.getShort(byArray, 22 + n);
        this.field_13_fcMin = LittleEndian.getInt(byArray, 24 + n);
        this.field_14_fcMac = LittleEndian.getInt(byArray, 28 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putUShort(byArray, 0 + n, this.field_1_wIdent);
        LittleEndian.putUShort(byArray, 2 + n, this.field_2_nFib);
        LittleEndian.putUShort(byArray, 4 + n, this.field_3_unused);
        LittleEndian.putUShort(byArray, 6 + n, this.field_4_lid);
        LittleEndian.putUShort(byArray, 8 + n, this.field_5_pnNext);
        LittleEndian.putShort(byArray, 10 + n, this.field_6_flags1);
        LittleEndian.putUShort(byArray, 12 + n, this.field_7_nFibBack);
        LittleEndian.putInt(byArray, 14 + n, this.field_8_lKey);
        byArray[18 + n] = this.field_9_envr;
        byArray[19 + n] = this.field_10_flags2;
        LittleEndian.putShort(byArray, 20 + n, this.field_11_Chs);
        LittleEndian.putShort(byArray, 22 + n, this.field_12_chsTables);
        LittleEndian.putInt(byArray, 24 + n, this.field_13_fcMin);
        LittleEndian.putInt(byArray, 28 + n, this.field_14_fcMac);
    }

    public byte[] serialize() {
        byte[] byArray = new byte[FibBaseAbstractType.getSize()];
        this.serialize(byArray, 0);
        return byArray;
    }

    public static int getSize() {
        return 32;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[FibBase]\n");
        stringBuilder.append("    .wIdent               = ");
        stringBuilder.append(" (").append(this.getWIdent()).append(" )\n");
        stringBuilder.append("    .nFib                 = ");
        stringBuilder.append(" (").append(this.getNFib()).append(" )\n");
        stringBuilder.append("    .unused               = ");
        stringBuilder.append(" (").append(this.getUnused()).append(" )\n");
        stringBuilder.append("    .lid                  = ");
        stringBuilder.append(" (").append(this.getLid()).append(" )\n");
        stringBuilder.append("    .pnNext               = ");
        stringBuilder.append(" (").append(this.getPnNext()).append(" )\n");
        stringBuilder.append("    .flags1               = ");
        stringBuilder.append(" (").append(this.getFlags1()).append(" )\n");
        stringBuilder.append("         .fDot                     = ").append(this.isFDot()).append('\n');
        stringBuilder.append("         .fGlsy                    = ").append(this.isFGlsy()).append('\n');
        stringBuilder.append("         .fComplex                 = ").append(this.isFComplex()).append('\n');
        stringBuilder.append("         .fHasPic                  = ").append(this.isFHasPic()).append('\n');
        stringBuilder.append("         .cQuickSaves              = ").append(this.getCQuickSaves()).append('\n');
        stringBuilder.append("         .fEncrypted               = ").append(this.isFEncrypted()).append('\n');
        stringBuilder.append("         .fWhichTblStm             = ").append(this.isFWhichTblStm()).append('\n');
        stringBuilder.append("         .fReadOnlyRecommended     = ").append(this.isFReadOnlyRecommended()).append('\n');
        stringBuilder.append("         .fWriteReservation        = ").append(this.isFWriteReservation()).append('\n');
        stringBuilder.append("         .fExtChar                 = ").append(this.isFExtChar()).append('\n');
        stringBuilder.append("         .fLoadOverride            = ").append(this.isFLoadOverride()).append('\n');
        stringBuilder.append("         .fFarEast                 = ").append(this.isFFarEast()).append('\n');
        stringBuilder.append("         .fObfuscated              = ").append(this.isFObfuscated()).append('\n');
        stringBuilder.append("    .nFibBack             = ");
        stringBuilder.append(" (").append(this.getNFibBack()).append(" )\n");
        stringBuilder.append("    .lKey                 = ");
        stringBuilder.append(" (").append(this.getLKey()).append(" )\n");
        stringBuilder.append("    .envr                 = ");
        stringBuilder.append(" (").append(this.getEnvr()).append(" )\n");
        stringBuilder.append("    .flags2               = ");
        stringBuilder.append(" (").append(this.getFlags2()).append(" )\n");
        stringBuilder.append("         .fMac                     = ").append(this.isFMac()).append('\n');
        stringBuilder.append("         .fEmptySpecial            = ").append(this.isFEmptySpecial()).append('\n');
        stringBuilder.append("         .fLoadOverridePage        = ").append(this.isFLoadOverridePage()).append('\n');
        stringBuilder.append("         .reserved1                = ").append(this.isReserved1()).append('\n');
        stringBuilder.append("         .reserved2                = ").append(this.isReserved2()).append('\n');
        stringBuilder.append("         .fSpare0                  = ").append(this.getFSpare0()).append('\n');
        stringBuilder.append("    .Chs                  = ");
        stringBuilder.append(" (").append(this.getChs()).append(" )\n");
        stringBuilder.append("    .chsTables            = ");
        stringBuilder.append(" (").append(this.getChsTables()).append(" )\n");
        stringBuilder.append("    .fcMin                = ");
        stringBuilder.append(" (").append(this.getFcMin()).append(" )\n");
        stringBuilder.append("    .fcMac                = ");
        stringBuilder.append(" (").append(this.getFcMac()).append(" )\n");
        stringBuilder.append("[/FibBase]\n");
        return stringBuilder.toString();
    }

    @Internal
    public int getWIdent() {
        return this.field_1_wIdent;
    }

    @Internal
    public void setWIdent(int n) {
        this.field_1_wIdent = n;
    }

    @Internal
    public int getNFib() {
        return this.field_2_nFib;
    }

    @Internal
    public void setNFib(int n) {
        this.field_2_nFib = n;
    }

    @Internal
    public int getUnused() {
        return this.field_3_unused;
    }

    @Internal
    public void setUnused(int n) {
        this.field_3_unused = n;
    }

    @Internal
    public int getLid() {
        return this.field_4_lid;
    }

    @Internal
    public void setLid(int n) {
        this.field_4_lid = n;
    }

    @Internal
    public int getPnNext() {
        return this.field_5_pnNext;
    }

    @Internal
    public void setPnNext(int n) {
        this.field_5_pnNext = n;
    }

    @Internal
    public short getFlags1() {
        return this.field_6_flags1;
    }

    @Internal
    public void setFlags1(short s) {
        this.field_6_flags1 = s;
    }

    @Internal
    public int getNFibBack() {
        return this.field_7_nFibBack;
    }

    @Internal
    public void setNFibBack(int n) {
        this.field_7_nFibBack = n;
    }

    @Internal
    public int getLKey() {
        return this.field_8_lKey;
    }

    @Internal
    public void setLKey(int n) {
        this.field_8_lKey = n;
    }

    @Internal
    public byte getEnvr() {
        return this.field_9_envr;
    }

    @Internal
    public void setEnvr(byte by) {
        this.field_9_envr = by;
    }

    @Internal
    public byte getFlags2() {
        return this.field_10_flags2;
    }

    @Internal
    public void setFlags2(byte by) {
        this.field_10_flags2 = by;
    }

    @Internal
    public short getChs() {
        return this.field_11_Chs;
    }

    @Internal
    public void setChs(short s) {
        this.field_11_Chs = s;
    }

    @Internal
    public short getChsTables() {
        return this.field_12_chsTables;
    }

    @Internal
    public void setChsTables(short s) {
        this.field_12_chsTables = s;
    }

    @Internal
    public int getFcMin() {
        return this.field_13_fcMin;
    }

    @Internal
    public void setFcMin(int n) {
        this.field_13_fcMin = n;
    }

    @Internal
    public int getFcMac() {
        return this.field_14_fcMac;
    }

    @Internal
    public void setFcMac(int n) {
        this.field_14_fcMac = n;
    }

    @Internal
    public void setFDot(boolean bl) {
        this.field_6_flags1 = (short)fDot.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFDot() {
        return fDot.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFGlsy(boolean bl) {
        this.field_6_flags1 = (short)fGlsy.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFGlsy() {
        return fGlsy.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFComplex(boolean bl) {
        this.field_6_flags1 = (short)fComplex.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFComplex() {
        return fComplex.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFHasPic(boolean bl) {
        this.field_6_flags1 = (short)fHasPic.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFHasPic() {
        return fHasPic.isSet(this.field_6_flags1);
    }

    @Internal
    public void setCQuickSaves(byte by) {
        this.field_6_flags1 = (short)cQuickSaves.setValue(this.field_6_flags1, by);
    }

    @Internal
    public byte getCQuickSaves() {
        return (byte)cQuickSaves.getValue(this.field_6_flags1);
    }

    @Internal
    public void setFEncrypted(boolean bl) {
        this.field_6_flags1 = (short)fEncrypted.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFEncrypted() {
        return fEncrypted.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFWhichTblStm(boolean bl) {
        this.field_6_flags1 = (short)fWhichTblStm.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFWhichTblStm() {
        return fWhichTblStm.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFReadOnlyRecommended(boolean bl) {
        this.field_6_flags1 = (short)fReadOnlyRecommended.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFReadOnlyRecommended() {
        return fReadOnlyRecommended.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFWriteReservation(boolean bl) {
        this.field_6_flags1 = (short)fWriteReservation.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFWriteReservation() {
        return fWriteReservation.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFExtChar(boolean bl) {
        this.field_6_flags1 = (short)fExtChar.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFExtChar() {
        return fExtChar.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFLoadOverride(boolean bl) {
        this.field_6_flags1 = (short)fLoadOverride.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFLoadOverride() {
        return fLoadOverride.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFFarEast(boolean bl) {
        this.field_6_flags1 = (short)fFarEast.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFFarEast() {
        return fFarEast.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFObfuscated(boolean bl) {
        this.field_6_flags1 = (short)fObfuscated.setBoolean(this.field_6_flags1, bl);
    }

    @Internal
    public boolean isFObfuscated() {
        return fObfuscated.isSet(this.field_6_flags1);
    }

    @Internal
    public void setFMac(boolean bl) {
        this.field_10_flags2 = (byte)fMac.setBoolean(this.field_10_flags2, bl);
    }

    @Internal
    @Deprecated
    public boolean isFMac() {
        return fMac.isSet(this.field_10_flags2);
    }

    @Internal
    public void setFEmptySpecial(boolean bl) {
        this.field_10_flags2 = (byte)fEmptySpecial.setBoolean(this.field_10_flags2, bl);
    }

    @Internal
    @Deprecated
    public boolean isFEmptySpecial() {
        return fEmptySpecial.isSet(this.field_10_flags2);
    }

    @Internal
    public void setFLoadOverridePage(boolean bl) {
        this.field_10_flags2 = (byte)fLoadOverridePage.setBoolean(this.field_10_flags2, bl);
    }

    @Internal
    public boolean isFLoadOverridePage() {
        return fLoadOverridePage.isSet(this.field_10_flags2);
    }

    @Internal
    public void setReserved1(boolean bl) {
        this.field_10_flags2 = (byte)reserved1.setBoolean(this.field_10_flags2, bl);
    }

    @Internal
    @Deprecated
    public boolean isReserved1() {
        return reserved1.isSet(this.field_10_flags2);
    }

    @Internal
    public void setReserved2(boolean bl) {
        this.field_10_flags2 = (byte)reserved2.setBoolean(this.field_10_flags2, bl);
    }

    @Internal
    @Deprecated
    public boolean isReserved2() {
        return reserved2.isSet(this.field_10_flags2);
    }

    @Internal
    public void setFSpare0(byte by) {
        this.field_10_flags2 = (byte)fSpare0.setValue(this.field_10_flags2, by);
    }

    @Internal
    @Deprecated
    public byte getFSpare0() {
        return (byte)fSpare0.getValue(this.field_10_flags2);
    }
}

