/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class FSPAAbstractType {
    protected int field_1_spid;
    protected int field_2_xaLeft;
    protected int field_3_yaTop;
    protected int field_4_xaRight;
    protected int field_5_yaBottom;
    protected short field_6_flags;
    private static BitField fHdr = new BitField(1);
    private static BitField bx = new BitField(6);
    private static BitField by = new BitField(24);
    private static BitField wr = new BitField(480);
    private static BitField wrk = new BitField(7680);
    private static BitField fRcaSimple = new BitField(8192);
    private static BitField fBelowText = new BitField(16384);
    private static BitField fAnchorLock = new BitField(32768);
    protected int field_7_cTxbx;

    protected FSPAAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_spid = LittleEndian.getInt(byArray, 0 + n);
        this.field_2_xaLeft = LittleEndian.getInt(byArray, 4 + n);
        this.field_3_yaTop = LittleEndian.getInt(byArray, 8 + n);
        this.field_4_xaRight = LittleEndian.getInt(byArray, 12 + n);
        this.field_5_yaBottom = LittleEndian.getInt(byArray, 16 + n);
        this.field_6_flags = LittleEndian.getShort(byArray, 20 + n);
        this.field_7_cTxbx = LittleEndian.getInt(byArray, 22 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putInt(byArray, 0 + n, this.field_1_spid);
        LittleEndian.putInt(byArray, 4 + n, this.field_2_xaLeft);
        LittleEndian.putInt(byArray, 8 + n, this.field_3_yaTop);
        LittleEndian.putInt(byArray, 12 + n, this.field_4_xaRight);
        LittleEndian.putInt(byArray, 16 + n, this.field_5_yaBottom);
        LittleEndian.putShort(byArray, 20 + n, this.field_6_flags);
        LittleEndian.putInt(byArray, 22 + n, this.field_7_cTxbx);
    }

    public static int getSize() {
        return 26;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[FSPA]\n");
        stringBuilder.append("    .spid                 = ");
        stringBuilder.append(" (").append(this.getSpid()).append(" )\n");
        stringBuilder.append("    .xaLeft               = ");
        stringBuilder.append(" (").append(this.getXaLeft()).append(" )\n");
        stringBuilder.append("    .yaTop                = ");
        stringBuilder.append(" (").append(this.getYaTop()).append(" )\n");
        stringBuilder.append("    .xaRight              = ");
        stringBuilder.append(" (").append(this.getXaRight()).append(" )\n");
        stringBuilder.append("    .yaBottom             = ");
        stringBuilder.append(" (").append(this.getYaBottom()).append(" )\n");
        stringBuilder.append("    .flags                = ");
        stringBuilder.append(" (").append(this.getFlags()).append(" )\n");
        stringBuilder.append("         .fHdr                     = ").append(this.isFHdr()).append('\n');
        stringBuilder.append("         .bx                       = ").append(this.getBx()).append('\n');
        stringBuilder.append("         .by                       = ").append(this.getBy()).append('\n');
        stringBuilder.append("         .wr                       = ").append(this.getWr()).append('\n');
        stringBuilder.append("         .wrk                      = ").append(this.getWrk()).append('\n');
        stringBuilder.append("         .fRcaSimple               = ").append(this.isFRcaSimple()).append('\n');
        stringBuilder.append("         .fBelowText               = ").append(this.isFBelowText()).append('\n');
        stringBuilder.append("         .fAnchorLock              = ").append(this.isFAnchorLock()).append('\n');
        stringBuilder.append("    .cTxbx                = ");
        stringBuilder.append(" (").append(this.getCTxbx()).append(" )\n");
        stringBuilder.append("[/FSPA]\n");
        return stringBuilder.toString();
    }

    @Internal
    public int getSpid() {
        return this.field_1_spid;
    }

    @Internal
    public void setSpid(int n) {
        this.field_1_spid = n;
    }

    @Internal
    public int getXaLeft() {
        return this.field_2_xaLeft;
    }

    @Internal
    public void setXaLeft(int n) {
        this.field_2_xaLeft = n;
    }

    @Internal
    public int getYaTop() {
        return this.field_3_yaTop;
    }

    @Internal
    public void setYaTop(int n) {
        this.field_3_yaTop = n;
    }

    @Internal
    public int getXaRight() {
        return this.field_4_xaRight;
    }

    @Internal
    public void setXaRight(int n) {
        this.field_4_xaRight = n;
    }

    @Internal
    public int getYaBottom() {
        return this.field_5_yaBottom;
    }

    @Internal
    public void setYaBottom(int n) {
        this.field_5_yaBottom = n;
    }

    @Internal
    public short getFlags() {
        return this.field_6_flags;
    }

    @Internal
    public void setFlags(short s) {
        this.field_6_flags = s;
    }

    @Internal
    public int getCTxbx() {
        return this.field_7_cTxbx;
    }

    @Internal
    public void setCTxbx(int n) {
        this.field_7_cTxbx = n;
    }

    @Internal
    public void setFHdr(boolean bl) {
        this.field_6_flags = (short)fHdr.setBoolean(this.field_6_flags, bl);
    }

    @Internal
    public boolean isFHdr() {
        return fHdr.isSet(this.field_6_flags);
    }

    @Internal
    public void setBx(byte by) {
        this.field_6_flags = (short)bx.setValue(this.field_6_flags, by);
    }

    @Internal
    public byte getBx() {
        return (byte)bx.getValue(this.field_6_flags);
    }

    @Internal
    public void setBy(byte by) {
        this.field_6_flags = (short)FSPAAbstractType.by.setValue(this.field_6_flags, by);
    }

    @Internal
    public byte getBy() {
        return (byte)by.getValue(this.field_6_flags);
    }

    @Internal
    public void setWr(byte by) {
        this.field_6_flags = (short)wr.setValue(this.field_6_flags, by);
    }

    @Internal
    public byte getWr() {
        return (byte)wr.getValue(this.field_6_flags);
    }

    @Internal
    public void setWrk(byte by) {
        this.field_6_flags = (short)wrk.setValue(this.field_6_flags, by);
    }

    @Internal
    public byte getWrk() {
        return (byte)wrk.getValue(this.field_6_flags);
    }

    @Internal
    public void setFRcaSimple(boolean bl) {
        this.field_6_flags = (short)fRcaSimple.setBoolean(this.field_6_flags, bl);
    }

    @Internal
    public boolean isFRcaSimple() {
        return fRcaSimple.isSet(this.field_6_flags);
    }

    @Internal
    public void setFBelowText(boolean bl) {
        this.field_6_flags = (short)fBelowText.setBoolean(this.field_6_flags, bl);
    }

    @Internal
    public boolean isFBelowText() {
        return fBelowText.isSet(this.field_6_flags);
    }

    @Internal
    public void setFAnchorLock(boolean bl) {
        this.field_6_flags = (short)fAnchorLock.setBoolean(this.field_6_flags, bl);
    }

    @Internal
    public boolean isFAnchorLock() {
        return fAnchorLock.isSet(this.field_6_flags);
    }
}

